/*
 * Copyright 1999-2101 Alibaba Group Holding Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.alibaba.druid.pool;

import java.util.Properties;

public interface DruidDataSourceC3P0AdapterMBean {

    String getDriverClass();

    String getJdbcUrl();

    Properties getProperties();

    String getUser();

    int getCheckoutTimeout();

    boolean isAutoCommitOnClose();

    int getIdleConnectionTestPeriod();

    int getInitialPoolSize();

    int getMaxIdleTime();

    int getMaxPoolSize();

    int getMinPoolSize();

    boolean isTestConnectionOnCheckout();

    boolean isTestConnectionOnCheckin();

    String getPreferredTestQuery();

    int getNumIdleConnections();

    int getNumConnections();

    String getDataSourceName();

    int getNumBusyConnections();

    // //////////

    boolean isEnable();

    void shrink();

    String toString();

    int getWaitThreadCount();

    int getLockQueueLength();

    void close();
}
