/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.config;

import java.lang.reflect.Type;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.SmartMessageConverter;
import org.springframework.messaging.handler.annotation.support.MessageMethodArgumentResolver;
import org.springframework.messaging.handler.annotation.support.MethodArgumentTypeMismatchException;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@Deprecated
class SmartMessageMethodArgumentResolver
extends MessageMethodArgumentResolver {
    private final MessageConverter messageConverter;

    SmartMessageMethodArgumentResolver() {
        this(null);
    }

    SmartMessageMethodArgumentResolver(@Nullable MessageConverter converter) {
        this.messageConverter = converter;
    }

    public Object resolveArgument(MethodParameter parameter, Message<?> message) throws Exception {
        Class targetMessageType = parameter.getParameterType();
        Class<?> targetPayloadType = this.getPayloadType(parameter);
        if (!targetMessageType.isAssignableFrom(message.getClass())) {
            throw new MethodArgumentTypeMismatchException(message, parameter, "Actual message type '" + ClassUtils.getDescriptiveType(message) + "' does not match expected type '" + ClassUtils.getQualifiedName((Class)targetMessageType) + "'");
        }
        Class<?> payloadClass = message.getPayload().getClass();
        if (this.conversionNotRequired(payloadClass, targetPayloadType)) {
            return message;
        }
        Object payload = message.getPayload();
        if (this.isEmptyPayload(payload)) {
            throw new MessageConversionException(message, "Cannot convert from actual payload type '" + ClassUtils.getDescriptiveType((Object)payload) + "' to expected payload type '" + ClassUtils.getQualifiedName(targetPayloadType) + "' when payload is empty");
        }
        payload = this.convertPayload(message, parameter, targetPayloadType);
        return MessageBuilder.createMessage((Object)payload, (MessageHeaders)message.getHeaders());
    }

    private boolean conversionNotRequired(Class<?> a, Class<?> b) {
        return b == Object.class ? ClassUtils.isAssignable(a, b) : ClassUtils.isAssignable(b, a);
    }

    private Class<?> getPayloadType(MethodParameter parameter) {
        Type genericParamType = parameter.getGenericParameterType();
        ResolvableType resolvableType = ResolvableType.forType((Type)genericParamType).as(Message.class);
        return resolvableType.getGeneric(new int[0]).toClass();
    }

    protected boolean isEmptyPayload(@Nullable Object payload) {
        if (payload == null) {
            return true;
        }
        if (payload instanceof byte[]) {
            return ((byte[])payload).length == 0;
        }
        if (payload instanceof String) {
            return !StringUtils.hasText((String)((String)payload));
        }
        return false;
    }

    private Object convertPayload(Message<?> message, MethodParameter parameter, Class<?> targetPayloadType) {
        Object result = null;
        if (this.messageConverter instanceof SmartMessageConverter) {
            SmartMessageConverter smartConverter = (SmartMessageConverter)this.messageConverter;
            result = smartConverter.fromMessage(message, targetPayloadType, (Object)parameter);
        } else if (this.messageConverter != null) {
            result = this.messageConverter.fromMessage(message, targetPayloadType);
        }
        if (result == null) {
            throw new MessageConversionException(message, "No converter found from actual payload type '" + ClassUtils.getDescriptiveType((Object)message.getPayload()) + "' to expected payload type '" + ClassUtils.getQualifiedName(targetPayloadType) + "'");
        }
        return result;
    }
}

