/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.yaml.schema.swapper;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.apache.shardingsphere.infra.metadata.schema.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.schema.model.ColumnMetaData;
import org.apache.shardingsphere.infra.metadata.schema.model.IndexMetaData;
import org.apache.shardingsphere.infra.metadata.schema.model.TableMetaData;
import org.apache.shardingsphere.infra.yaml.config.swapper.YamlConfigurationSwapper;
import org.apache.shardingsphere.infra.yaml.schema.pojo.YamlColumnMetaData;
import org.apache.shardingsphere.infra.yaml.schema.pojo.YamlIndexMetaData;
import org.apache.shardingsphere.infra.yaml.schema.pojo.YamlSchema;
import org.apache.shardingsphere.infra.yaml.schema.pojo.YamlTableMetaData;

public final class SchemaYamlSwapper
implements YamlConfigurationSwapper<YamlSchema, ShardingSphereSchema> {
    @Override
    public YamlSchema swapToYamlConfiguration(ShardingSphereSchema schema) {
        Map tables = schema.getAllTableNames().stream().collect(Collectors.toMap(each -> each, each -> this.swapYamlTable(schema.get((String)each)), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
        YamlSchema result = new YamlSchema();
        result.setTables(tables);
        return result;
    }

    @Override
    public ShardingSphereSchema swapToObject(YamlSchema yamlConfig) {
        return Optional.ofNullable(yamlConfig).map(this::swapSchema).orElseGet(ShardingSphereSchema::new);
    }

    private ShardingSphereSchema swapSchema(YamlSchema schema) {
        return new ShardingSphereSchema(MapUtils.isEmpty(schema.getTables()) ? Maps.newLinkedHashMap() : (Map)schema.getTables().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.swapTable((String)entry.getKey(), (YamlTableMetaData)entry.getValue()), (oldValue, currentValue) -> oldValue, LinkedHashMap::new)));
    }

    private TableMetaData swapTable(String tableName, YamlTableMetaData table) {
        return new TableMetaData(tableName, this.swapColumns(table.getColumns()), this.swapIndexes(table.getIndexes()));
    }

    private Collection<IndexMetaData> swapIndexes(Map<String, YamlIndexMetaData> indexes) {
        return null == indexes ? Collections.emptyList() : (Collection)indexes.values().stream().map(this::swapIndex).collect(Collectors.toList());
    }

    private IndexMetaData swapIndex(YamlIndexMetaData index) {
        return new IndexMetaData(index.getName());
    }

    private Collection<ColumnMetaData> swapColumns(Map<String, YamlColumnMetaData> indexes) {
        return null == indexes ? Collections.emptyList() : (Collection)indexes.values().stream().map(this::swapColumn).collect(Collectors.toList());
    }

    private ColumnMetaData swapColumn(YamlColumnMetaData column) {
        return new ColumnMetaData(column.getName(), column.getDataType(), column.isPrimaryKey(), column.isGenerated(), column.isCaseSensitive());
    }

    private YamlTableMetaData swapYamlTable(TableMetaData table) {
        YamlTableMetaData result = new YamlTableMetaData();
        result.setColumns(this.swapYamlColumns(table.getColumns()));
        result.setIndexes(this.swapYamlIndexes(table.getIndexes()));
        return result;
    }

    private Map<String, YamlIndexMetaData> swapYamlIndexes(Map<String, IndexMetaData> indexes) {
        return indexes.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.swapYamlIndex((IndexMetaData)entry.getValue()), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    private YamlIndexMetaData swapYamlIndex(IndexMetaData index) {
        YamlIndexMetaData result = new YamlIndexMetaData();
        result.setName(index.getName());
        return result;
    }

    private Map<String, YamlColumnMetaData> swapYamlColumns(Map<String, ColumnMetaData> columns) {
        return columns.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.swapYamlColumn((ColumnMetaData)entry.getValue()), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    private YamlColumnMetaData swapYamlColumn(ColumnMetaData column) {
        YamlColumnMetaData result = new YamlColumnMetaData();
        result.setName(column.getName());
        result.setCaseSensitive(column.isCaseSensitive());
        result.setGenerated(column.isGenerated());
        result.setPrimaryKey(column.isPrimaryKey());
        result.setDataType(column.getDataType());
        return result;
    }
}

