/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.schema.loader;

import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.config.properties.ConfigurationProperties;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeRecognizer;
import org.apache.shardingsphere.infra.metadata.schema.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.schema.builder.SchemaBuilderMaterials;
import org.apache.shardingsphere.infra.metadata.schema.builder.TableMetaDataBuilder;
import org.apache.shardingsphere.infra.metadata.schema.model.TableMetaData;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.identifier.type.TableContainedRule;

public final class SchemaLoader {
    private final Map<String, Map<String, DataSource>> dataSources;
    private final Map<String, Collection<RuleConfiguration>> schemaRuleConfigs;
    private final Map<String, Collection<ShardingSphereRule>> rules;
    private final ConfigurationProperties props;

    public SchemaLoader(Map<String, Map<String, DataSource>> dataSources, Map<String, Collection<RuleConfiguration>> schemaRuleConfigs, Map<String, Collection<ShardingSphereRule>> rules, Properties props) {
        this.dataSources = dataSources;
        this.schemaRuleConfigs = schemaRuleConfigs;
        this.rules = rules;
        this.props = new ConfigurationProperties(null == props ? new Properties() : props);
    }

    public Map<String, ShardingSphereSchema> load() throws SQLException {
        HashMap<String, ShardingSphereSchema> result = new HashMap<String, ShardingSphereSchema>(this.schemaRuleConfigs.size(), 1.0f);
        for (String each : this.schemaRuleConfigs.keySet()) {
            Map<String, DataSource> dataSourceMap = this.dataSources.get(each);
            DatabaseType databaseType = DatabaseTypeRecognizer.getDatabaseType(this.dataSources.get(each).values());
            Map<String, TableMetaData> tableMetaDataMap = TableMetaDataBuilder.load(this.getAllTableNames(this.rules.get(each)), new SchemaBuilderMaterials(databaseType, dataSourceMap, this.rules.get(each), this.props));
            result.put(each, new ShardingSphereSchema(tableMetaDataMap));
        }
        return result;
    }

    private Collection<String> getAllTableNames(Collection<ShardingSphereRule> rules) {
        return rules.stream().filter(rule -> rule instanceof TableContainedRule).flatMap(shardingSphereRule -> ((TableContainedRule)shardingSphereRule).getTables().stream()).collect(Collectors.toSet());
    }
}

