/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.schema.builder.loader.dialect;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.shardingsphere.infra.metadata.schema.builder.loader.DataTypeLoader;
import org.apache.shardingsphere.infra.metadata.schema.builder.spi.DialectTableMetaDataLoader;
import org.apache.shardingsphere.infra.metadata.schema.model.ColumnMetaData;
import org.apache.shardingsphere.infra.metadata.schema.model.IndexMetaData;
import org.apache.shardingsphere.infra.metadata.schema.model.TableMetaData;

public final class OracleTableMetaDataLoader
implements DialectTableMetaDataLoader {
    private static final String TABLE_META_DATA_SQL_NO_ORDER = "SELECT OWNER AS TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, DATA_TYPE, COLUMN_ID %s FROM ALL_TAB_COLUMNS WHERE OWNER = ?";
    private static final String ORDER_BY_COLUMN_ID = " ORDER BY COLUMN_ID";
    private static final String TABLE_META_DATA_SQL = "SELECT OWNER AS TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, DATA_TYPE, COLUMN_ID %s FROM ALL_TAB_COLUMNS WHERE OWNER = ? ORDER BY COLUMN_ID";
    private static final String TABLE_META_DATA_SQL_IN_TABLES = "SELECT OWNER AS TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, DATA_TYPE, COLUMN_ID %s FROM ALL_TAB_COLUMNS WHERE OWNER = ? AND TABLE_NAME IN (%s) ORDER BY COLUMN_ID";
    private static final String INDEX_META_DATA_SQL = "SELECT OWNER AS TABLE_SCHEMA, TABLE_NAME, INDEX_NAME FROM ALL_INDEXES WHERE OWNER = ? AND TABLE_NAME IN (%s)";
    private static final String PRIMARY_KEY_META_DATA_SQL = "SELECT A.OWNER AS TABLE_SCHEMA, A.TABLE_NAME AS TABLE_NAME, B.COLUMN_NAME AS COLUMN_NAME FROM ALL_CONSTRAINTS A INNER JOIN ALL_CONS_COLUMNS B ON A.CONSTRAINT_NAME = B.CONSTRAINT_NAME WHERE CONSTRAINT_TYPE = 'P' AND A.OWNER = ?";
    private static final String PRIMARY_KEY_META_DATA_SQL_IN_TABLES = "SELECT A.OWNER AS TABLE_SCHEMA, A.TABLE_NAME AS TABLE_NAME, B.COLUMN_NAME AS COLUMN_NAME FROM ALL_CONSTRAINTS A INNER JOIN ALL_CONS_COLUMNS B ON A.CONSTRAINT_NAME = B.CONSTRAINT_NAME WHERE CONSTRAINT_TYPE = 'P' AND A.OWNER = ? AND A.TABLE_NAME IN (%s)";
    private static final int COLLATION_START_MAJOR_VERSION = 12;
    private static final int COLLATION_START_MINOR_VERSION = 2;
    private static final int IDENTITY_COLUMN_START_MINOR_VERSION = 1;

    @Override
    public Map<String, TableMetaData> load(DataSource dataSource, Collection<String> tables) throws SQLException {
        LinkedHashMap<String, TableMetaData> result = new LinkedHashMap<String, TableMetaData>();
        Map<String, Collection<ColumnMetaData>> columnMetaDataMap = this.loadColumnMetaDataMap(dataSource, tables);
        Map indexMetaDataMap = columnMetaDataMap.isEmpty() ? Collections.emptyMap() : this.loadIndexMetaData(dataSource, columnMetaDataMap.keySet());
        for (Map.Entry<String, Collection<ColumnMetaData>> entry : columnMetaDataMap.entrySet()) {
            result.put(entry.getKey(), new TableMetaData(entry.getKey(), entry.getValue(), indexMetaDataMap.getOrDefault(entry.getKey(), Collections.emptyList())));
        }
        return result;
    }

    private Map<String, Collection<ColumnMetaData>> loadColumnMetaDataMap(DataSource dataSource, Collection<String> tables) throws SQLException {
        HashMap<String, Collection<ColumnMetaData>> result = new HashMap<String, Collection<ColumnMetaData>>();
        try (Connection connection = dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(this.getTableMetaDataSQL(tables, connection.getMetaData()));){
            Map<String, Integer> dataTypes = DataTypeLoader.load(connection.getMetaData());
            this.appendNumberDataType(dataTypes);
            Map<String, Collection<String>> tablePrimaryKeys = this.loadTablePrimaryKeys(connection, tables);
            preparedStatement.setString(1, connection.getSchema());
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    String tableName = resultSet.getString("TABLE_NAME");
                    ColumnMetaData columnMetaData = this.loadColumnMetaData(dataTypes, resultSet, tablePrimaryKeys.getOrDefault(tableName, Collections.emptyList()), connection.getMetaData());
                    if (!result.containsKey(tableName)) {
                        result.put(tableName, new LinkedList());
                    }
                    ((Collection)result.get(tableName)).add(columnMetaData);
                }
            }
        }
        return result;
    }

    private void appendNumberDataType(Map<String, Integer> dataTypes) {
        dataTypes.put("NUMBER", 2);
    }

    private ColumnMetaData loadColumnMetaData(Map<String, Integer> dataTypeMap, ResultSet resultSet, Collection<String> primaryKeys, DatabaseMetaData metaData) throws SQLException {
        String columnName = resultSet.getString("COLUMN_NAME");
        String dataType = this.getOriginalDataType(resultSet.getString("DATA_TYPE"));
        boolean primaryKey = primaryKeys.contains(columnName);
        boolean generated = this.versionContainsIdentityColumn(metaData) && "YES".equals(resultSet.getString("IDENTITY_COLUMN"));
        boolean caseSensitive = this.versionContainsCollation(metaData) && resultSet.getString("COLLATION").endsWith("_CS");
        return new ColumnMetaData(columnName, dataTypeMap.get(dataType), primaryKey, generated, caseSensitive);
    }

    private String getOriginalDataType(String dataType) {
        int index = dataType.indexOf("(");
        if (index > 0) {
            return dataType.substring(0, index);
        }
        return dataType;
    }

    private String getTableMetaDataSQL(Collection<String> tables, DatabaseMetaData metaData) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder(28);
        if (this.versionContainsIdentityColumn(metaData)) {
            stringBuilder.append(", IDENTITY_COLUMN");
        }
        if (this.versionContainsCollation(metaData)) {
            stringBuilder.append(", COLLATION");
        }
        String collation = stringBuilder.toString();
        return tables.isEmpty() ? String.format(TABLE_META_DATA_SQL, collation) : String.format(TABLE_META_DATA_SQL_IN_TABLES, collation, tables.stream().map(each -> String.format("'%s'", each)).collect(Collectors.joining(",")));
    }

    private boolean versionContainsCollation(DatabaseMetaData metaData) throws SQLException {
        return metaData.getDatabaseMajorVersion() >= 12 && metaData.getDatabaseMinorVersion() >= 2;
    }

    private boolean versionContainsIdentityColumn(DatabaseMetaData metaData) throws SQLException {
        return metaData.getDatabaseMajorVersion() >= 12 && metaData.getDatabaseMinorVersion() >= 1;
    }

    private Map<String, Collection<IndexMetaData>> loadIndexMetaData(DataSource dataSource, Collection<String> tableNames) throws SQLException {
        HashMap<String, Collection<IndexMetaData>> result = new HashMap<String, Collection<IndexMetaData>>();
        try (Connection connection = dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(this.getIndexMetaDataSQL(tableNames));){
            preparedStatement.setString(1, connection.getSchema());
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    String indexName = resultSet.getString("INDEX_NAME");
                    String tableName = resultSet.getString("TABLE_NAME");
                    if (!result.containsKey(tableName)) {
                        result.put(tableName, new LinkedList());
                    }
                    ((Collection)result.get(tableName)).add(new IndexMetaData(indexName));
                }
            }
        }
        return result;
    }

    private String getIndexMetaDataSQL(Collection<String> tableNames) {
        return String.format(INDEX_META_DATA_SQL, tableNames.stream().map(each -> String.format("'%s'", each)).collect(Collectors.joining(",")));
    }

    private Map<String, Collection<String>> loadTablePrimaryKeys(Connection connection, Collection<String> tableNames) throws SQLException {
        HashMap<String, Collection<String>> result = new HashMap<String, Collection<String>>();
        try (PreparedStatement preparedStatement = connection.prepareStatement(this.getPrimaryKeyMetaDataSQL(tableNames));){
            preparedStatement.setString(1, connection.getSchema());
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    String columnName = resultSet.getString("COLUMN_NAME");
                    String tableName = resultSet.getString("TABLE_NAME");
                    result.computeIfAbsent(tableName, k -> new LinkedList()).add(columnName);
                }
            }
        }
        return result;
    }

    private String getPrimaryKeyMetaDataSQL(Collection<String> tables) {
        return tables.isEmpty() ? PRIMARY_KEY_META_DATA_SQL : String.format(PRIMARY_KEY_META_DATA_SQL_IN_TABLES, tables.stream().map(each -> String.format("'%s'", each)).collect(Collectors.joining(",")));
    }

    @Override
    public String getDatabaseType() {
        return "Oracle";
    }
}

