/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.database.type;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.type.BranchDatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;

public final class DatabaseTypeRegistry {
    private static final Map<String, DatabaseType> DATABASE_TYPES = new HashMap<String, DatabaseType>();
    private static final String DEFAULT_DATABASE_TYPE = "MySQL";

    public static String getTrunkDatabaseTypeName(DatabaseType databaseType) {
        return databaseType instanceof BranchDatabaseType ? ((BranchDatabaseType)databaseType).getTrunkDatabaseType().getName() : databaseType.getName();
    }

    public static DatabaseType getTrunkDatabaseType(String name) {
        return DATABASE_TYPES.get(name) instanceof BranchDatabaseType ? ((BranchDatabaseType)DATABASE_TYPES.get(name)).getTrunkDatabaseType() : DatabaseTypeRegistry.getActualDatabaseType(name);
    }

    public static DatabaseType getActualDatabaseType(String name) {
        return Optional.ofNullable(DATABASE_TYPES.get(name)).orElseThrow(() -> new ShardingSphereException("Unsupported database:'%s'", name));
    }

    public static DatabaseType getDatabaseTypeByURL(String url) {
        return DATABASE_TYPES.values().stream().filter(each -> DatabaseTypeRegistry.matchURLs(url, each)).findAny().orElseGet(() -> DATABASE_TYPES.get("SQL92"));
    }

    private static boolean matchURLs(String url, DatabaseType databaseType) {
        return databaseType.getJdbcUrlPrefixes().stream().anyMatch(url::startsWith);
    }

    public static DatabaseType getDefaultDatabaseType() {
        return DATABASE_TYPES.get(DEFAULT_DATABASE_TYPE);
    }

    @Generated
    private DatabaseTypeRegistry() {
    }

    static {
        for (DatabaseType each : ServiceLoader.load(DatabaseType.class)) {
            DATABASE_TYPES.put(each.getName(), each);
        }
    }
}

