/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.config.datasource;

import com.google.common.base.Objects;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;

public final class DataSourceConfiguration {
    public static final String CUSTOM_POOL_PROPS_KEY = "customPoolProps";
    private final String dataSourceClassName;
    private final Map<String, Object> props = new LinkedHashMap<String, Object>();
    private final Properties customPoolProps = new Properties();

    public void addPropertySynonym(String originalName, String synonym) {
        if (this.props.containsKey(originalName)) {
            this.props.put(synonym, this.props.get(originalName));
        }
        if (this.props.containsKey(synonym)) {
            this.props.put(originalName, this.props.get(synonym));
        }
    }

    public Map<String, Object> getAllProps() {
        HashMap<String, Object> result = new HashMap<String, Object>(this.props);
        result.putAll(this.customPoolProps);
        return result;
    }

    public boolean equals(Object obj) {
        return this == obj || null != obj && this.getClass() == obj.getClass() && this.equalsByProperties((DataSourceConfiguration)obj);
    }

    private boolean equalsByProperties(DataSourceConfiguration dataSourceConfig) {
        if (!this.dataSourceClassName.equals(dataSourceConfig.dataSourceClassName)) {
            return false;
        }
        for (Map.Entry<String, Object> entry : this.props.entrySet()) {
            if (!dataSourceConfig.props.containsKey(entry.getKey()) || String.valueOf(entry.getValue()).equals(String.valueOf(dataSourceConfig.props.get(entry.getKey())))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, Object> entry : this.props.entrySet()) {
            stringBuilder.append(entry.getKey()).append(entry.getValue());
        }
        return Objects.hashCode((Object[])new Object[]{this.dataSourceClassName, stringBuilder.toString()});
    }

    @Generated
    public DataSourceConfiguration(String dataSourceClassName) {
        this.dataSourceClassName = dataSourceClassName;
    }

    @Generated
    public String getDataSourceClassName() {
        return this.dataSourceClassName;
    }

    @Generated
    public Map<String, Object> getProps() {
        return this.props;
    }

    @Generated
    public Properties getCustomPoolProps() {
        return this.customPoolProps;
    }
}

