/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tools.command.message;

import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.MessageQueueSelector;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.tools.command.SubCommand;

public class CheckMsgSendRTCommand
implements SubCommand {
    private static String brokerName = "";
    private static int queueId = 0;

    @Override
    public String commandName() {
        return "checkMsgSendRT";
    }

    @Override
    public String commandDesc() {
        return "check message send response time";
    }

    @Override
    public Options buildCommandlineOptions(Options options) {
        Option opt = new Option("t", "topic", true, "topic name");
        opt.setRequired(true);
        options.addOption(opt);
        opt = new Option("a", "amout", true, "message amout | default 100");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("s", "size", true, "message size | default 128 Byte");
        opt.setRequired(true);
        options.addOption(opt);
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(CommandLine commandLine, Options options, RPCHook rpcHook) {
        DefaultMQProducer producer = new DefaultMQProducer(rpcHook);
        producer.setProducerGroup(Long.toString(System.currentTimeMillis()));
        try {
            producer.start();
            long start = 0L;
            long end = 0L;
            long timeElapsed = 0L;
            boolean sendSuccess = false;
            String topic = commandLine.getOptionValue('t').trim();
            long amount = !commandLine.hasOption('a') ? 100L : Long.parseLong(commandLine.getOptionValue('a').trim());
            long msgSize = !commandLine.hasOption('s') ? 128L : Long.parseLong(commandLine.getOptionValue('s').trim());
            Message msg = new Message(topic, this.getStringBySize(msgSize).getBytes("UTF-8"));
            System.out.printf("%-32s  %-4s  %-20s    %s%n", "#Broker Name", "#QID", "#Send Result", "#RT");
            int i = 0;
            while ((long)i < amount) {
                start = System.currentTimeMillis();
                try {
                    producer.send(msg, new MessageQueueSelector(){

                        public MessageQueue select(List<MessageQueue> mqs, Message msg, Object arg) {
                            int queueIndex = (Integer)arg % mqs.size();
                            MessageQueue queue = mqs.get(queueIndex);
                            brokerName = queue.getBrokerName();
                            queueId = queue.getQueueId();
                            return queue;
                        }
                    }, (Object)i);
                    sendSuccess = true;
                    end = System.currentTimeMillis();
                }
                catch (Exception e) {
                    sendSuccess = false;
                    end = System.currentTimeMillis();
                }
                if (i != 0) {
                    timeElapsed += end - start;
                }
                System.out.printf("%-32s  %-4s  %-20s    %s%n", brokerName, queueId, sendSuccess, end - start);
                ++i;
            }
            double rt = (double)timeElapsed / (double)(amount - 1L);
            System.out.printf("Avg RT: %s%n", String.format("%.2f", rt));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            producer.shutdown();
        }
    }

    public String getStringBySize(long size) {
        StringBuilder res = new StringBuilder();
        int i = 0;
        while ((long)i < size) {
            res.append('a');
            ++i;
        }
        return res.toString();
    }
}

