/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import org.apache.kerby.util.Base64;

public class PublicKeyReader {
    public static PublicKey loadPublicKey(InputStream in) throws Exception {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
            String readLine = null;
            StringBuilder sb = new StringBuilder();
            while ((readLine = br.readLine()) != null) {
                if (readLine.charAt(0) == '-') continue;
                sb.append(readLine);
                sb.append('\r');
            }
            return PublicKeyReader.loadPublicKey(sb.toString());
        }
        catch (IOException e) {
            throw e;
        }
        catch (NullPointerException e) {
            throw e;
        }
    }

    public static PublicKey loadPublicKey(String publicKeyStr) throws Exception {
        try {
            Base64 base64 = new Base64();
            byte[] buffer = base64.decode(publicKeyStr);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(buffer);
            return keyFactory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw e;
        }
        catch (InvalidKeySpecException e) {
            throw e;
        }
        catch (NullPointerException e) {
            throw e;
        }
    }
}

