/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.source;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;

class SerializedCheckpointData
implements Serializable {
    private static final long serialVersionUID = -8783744683896503488L;
    private final long checkpointId;
    private final byte[] serializedData;
    private final int numIds;

    public SerializedCheckpointData(long checkpointId, byte[] serializedData, int numIds) {
        this.checkpointId = checkpointId;
        this.serializedData = serializedData;
        this.numIds = numIds;
    }

    public long getCheckpointId() {
        return this.checkpointId;
    }

    public byte[] getSerializedData() {
        return this.serializedData;
    }

    public int getNumIds() {
        return this.numIds;
    }

    public static <T> SerializedCheckpointData[] fromDeque(ArrayDeque<Tuple2<Long, Set<T>>> checkpoints, TypeSerializer<T> serializer) throws IOException {
        return SerializedCheckpointData.fromDeque(checkpoints, serializer, new DataOutputSerializer(128));
    }

    public static <T> SerializedCheckpointData[] fromDeque(ArrayDeque<Tuple2<Long, Set<T>>> checkpoints, TypeSerializer<T> serializer, DataOutputSerializer outputBuffer) throws IOException {
        SerializedCheckpointData[] serializedCheckpoints = new SerializedCheckpointData[checkpoints.size()];
        int pos = 0;
        for (Tuple2<Long, Set<T>> checkpoint : checkpoints) {
            outputBuffer.clear();
            Set checkpointIds = (Set)checkpoint.f1;
            for (Object id : checkpointIds) {
                serializer.serialize(id, (DataOutputView)outputBuffer);
            }
            serializedCheckpoints[pos++] = new SerializedCheckpointData((Long)checkpoint.f0, outputBuffer.getCopyOfBuffer(), checkpointIds.size());
        }
        return serializedCheckpoints;
    }

    public static <T> ArrayDeque<Tuple2<Long, Set<T>>> toDeque(SerializedCheckpointData[] data, TypeSerializer<T> serializer) throws IOException {
        ArrayDeque<Tuple2<Long, Set<T>>> deque = new ArrayDeque<Tuple2<Long, Set<T>>>(data.length);
        DataInputDeserializer deser = null;
        for (SerializedCheckpointData checkpoint : data) {
            byte[] serializedData = checkpoint.getSerializedData();
            if (deser == null) {
                deser = new DataInputDeserializer(serializedData, 0, serializedData.length);
            } else {
                deser.setBuffer(serializedData, 0, serializedData.length);
            }
            HashSet<Object> ids = new HashSet<Object>(checkpoint.getNumIds());
            int numIds = checkpoint.getNumIds();
            for (int i = 0; i < numIds; ++i) {
                ids.add(serializer.deserialize((DataInputView)deser));
            }
            deque.addLast(new Tuple2((Object)checkpoint.checkpointId, ids));
        }
        return deque;
    }
}

