/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.jackson2.com.fasterxml.jackson.module.jsonSchema.factories;

import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JavaType;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonMapFormatVisitor;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.module.jsonSchema.factories.JsonSchemaProducer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.module.jsonSchema.factories.SchemaFactoryWrapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.module.jsonSchema.factories.Visitor;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.module.jsonSchema.factories.VisitorContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.module.jsonSchema.factories.WrapperFactory;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.module.jsonSchema.types.ObjectSchema;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.module.jsonSchema.types.ReferenceSchema;

public class MapVisitor
extends JsonMapFormatVisitor.Base
implements JsonSchemaProducer,
Visitor {
    protected final ObjectSchema schema;
    protected SerializerProvider provider;
    private WrapperFactory wrapperFactory;
    private VisitorContext visitorContext;

    public MapVisitor(SerializerProvider provider, ObjectSchema schema) {
        this(provider, schema, new WrapperFactory());
    }

    public MapVisitor(SerializerProvider provider, ObjectSchema schema, WrapperFactory wrapperFactory) {
        this.provider = provider;
        this.schema = schema;
        this.wrapperFactory = wrapperFactory;
    }

    @Override
    public ObjectSchema getSchema() {
        return this.schema;
    }

    @Override
    public SerializerProvider getProvider() {
        return this.provider;
    }

    @Override
    public void setProvider(SerializerProvider p) {
        this.provider = p;
    }

    @Override
    public void keyFormat(JsonFormatVisitable handler, JavaType keyType) throws JsonMappingException {
    }

    @Override
    public void valueFormat(JsonFormatVisitable handler, JavaType valueType) throws JsonMappingException {
        JsonSchema valueSchema = this.propertySchema(handler, valueType);
        ObjectSchema.SchemaAdditionalProperties ap = new ObjectSchema.SchemaAdditionalProperties(valueSchema.asSimpleTypeSchema());
        this.schema.setAdditionalProperties(ap);
    }

    protected JsonSchema propertySchema(JsonFormatVisitable handler, JavaType propertyTypeHint) throws JsonMappingException {
        String seenSchemaUri;
        if (this.visitorContext != null && (seenSchemaUri = this.visitorContext.getSeenSchemaUri(propertyTypeHint)) != null) {
            return new ReferenceSchema(seenSchemaUri);
        }
        SchemaFactoryWrapper visitor = this.wrapperFactory.getWrapper(this.getProvider(), this.visitorContext);
        handler.acceptJsonFormatVisitor(visitor, propertyTypeHint);
        return visitor.finalSchema();
    }

    @Override
    public Visitor setVisitorContext(VisitorContext rvc) {
        this.visitorContext = rvc;
        return this;
    }
}

