/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderretrieval;

import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalListener;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.util.Preconditions;

public class SettableLeaderRetrievalService
implements LeaderRetrievalService {
    private String leaderAddress;
    private UUID leaderSessionID;
    private LeaderRetrievalListener listener;

    public SettableLeaderRetrievalService() {
        this(null, null);
    }

    public SettableLeaderRetrievalService(@Nullable String leaderAddress, @Nullable UUID leaderSessionID) {
        this.leaderAddress = leaderAddress;
        this.leaderSessionID = leaderSessionID;
    }

    @Override
    public synchronized void start(LeaderRetrievalListener listener) throws Exception {
        this.listener = (LeaderRetrievalListener)Preconditions.checkNotNull((Object)listener);
        if (this.leaderSessionID != null && this.leaderAddress != null) {
            listener.notifyLeaderAddress(this.leaderAddress, this.leaderSessionID);
        }
    }

    @Override
    public void stop() throws Exception {
    }

    public synchronized void notifyListener(@Nullable String address, @Nullable UUID leaderSessionID) {
        this.leaderAddress = address;
        this.leaderSessionID = leaderSessionID;
        if (this.listener != null) {
            this.listener.notifyLeaderAddress(address, leaderSessionID);
        }
    }
}

