/*
 * Decompiled with CFR 0.152.
 */
package brave.spring.web;

import brave.Span;
import brave.Tracing;
import brave.http.HttpClientHandler;
import brave.http.HttpClientRequest;
import brave.http.HttpClientResponse;
import brave.http.HttpTracing;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import brave.spring.web.TraceContextListenableFuture;
import brave.spring.web.TracingClientHttpRequestInterceptor;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.AsyncClientHttpRequestExecution;
import org.springframework.http.client.AsyncClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;

public final class TracingAsyncClientHttpRequestInterceptor
implements AsyncClientHttpRequestInterceptor {
    final CurrentTraceContext currentTraceContext;
    final HttpClientHandler<HttpClientRequest, HttpClientResponse> handler;

    public static AsyncClientHttpRequestInterceptor create(Tracing tracing) {
        return TracingAsyncClientHttpRequestInterceptor.create(HttpTracing.create((Tracing)tracing));
    }

    public static AsyncClientHttpRequestInterceptor create(HttpTracing httpTracing) {
        return new TracingAsyncClientHttpRequestInterceptor(httpTracing);
    }

    @Autowired
    TracingAsyncClientHttpRequestInterceptor(HttpTracing httpTracing) {
        this.currentTraceContext = httpTracing.tracing().currentTraceContext();
        this.handler = HttpClientHandler.create((HttpTracing)httpTracing);
    }

    public ListenableFuture<ClientHttpResponse> intercept(HttpRequest req, byte[] body, AsyncClientHttpRequestExecution execution) throws IOException {
        TraceContextListenableFuture traceContextListenableFuture;
        block8: {
            TracingClientHttpRequestInterceptor.HttpRequestWrapper request = new TracingClientHttpRequestInterceptor.HttpRequestWrapper(req);
            Span span = this.handler.handleSend((HttpClientRequest)request);
            TraceContext invocationContext = span.context().parentIdAsLong() != 0L ? this.currentTraceContext.get() : null;
            CurrentTraceContext.Scope ws = this.currentTraceContext.maybeScope(span.context());
            try {
                TraceContextListenableFuture result = execution.executeAsync(req, body);
                result.addCallback(new TraceListenableFutureCallback(request, span, this.handler));
                TraceContextListenableFuture traceContextListenableFuture2 = traceContextListenableFuture = invocationContext != null ? new TraceContextListenableFuture(result, this.currentTraceContext, invocationContext) : result;
                if (ws == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ws != null) {
                        try {
                            ws.close();
                        }
                        catch (Throwable throwable2) {
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    this.handler.handleReceive(null, e, span);
                    throw e;
                }
            }
            ws.close();
        }
        return traceContextListenableFuture;
    }

    static final class TraceListenableFutureCallback
    implements ListenableFutureCallback<ClientHttpResponse> {
        final TracingClientHttpRequestInterceptor.HttpRequestWrapper request;
        final Span span;
        final HttpClientHandler<HttpClientRequest, HttpClientResponse> handler;

        TraceListenableFutureCallback(TracingClientHttpRequestInterceptor.HttpRequestWrapper request, Span span, HttpClientHandler<HttpClientRequest, HttpClientResponse> handler) {
            this.request = request;
            this.span = span;
            this.handler = handler;
        }

        public void onFailure(Throwable ex) {
            this.handler.handleReceive(null, ex, this.span);
        }

        public void onSuccess(ClientHttpResponse result) {
            this.handler.handleReceive((Object)new TracingClientHttpRequestInterceptor.ClientHttpResponseWrapper(this.request, result, null), null, this.span);
        }
    }
}

