/*
 * Decompiled with CFR 0.152.
 */
package Glacier2;

import Glacier2.SessionCallback;
import Glacier2.SessionHelper;
import Ice.Identity;
import Ice.InitializationData;
import Ice.InitializationException;
import Ice.Properties;
import Ice.Util;
import java.util.Map;

public class SessionFactoryHelper {
    private SessionCallback _callback;
    private String _routerHost = "localhost";
    private InitializationData _initData;
    private Identity _identity = null;
    private String _protocol = "ssl";
    private int _port = 0;
    private int _timeout = 10000;
    private Map<String, String> _context;
    private boolean _useCallbacks = true;
    private static final int GLACIER2_SSL_PORT = 4064;
    private static final int GLACIER2_TCP_PORT = 4063;

    public SessionFactoryHelper(SessionCallback callback) throws InitializationException {
        this.initialize(callback, new InitializationData(), Util.createProperties());
    }

    public SessionFactoryHelper(InitializationData initData, SessionCallback callback) throws InitializationException {
        this.initialize(callback, initData, initData.properties);
    }

    public SessionFactoryHelper(Properties properties, SessionCallback callback) throws InitializationException {
        this.initialize(callback, new InitializationData(), properties);
    }

    private void initialize(SessionCallback callback, InitializationData initData, Properties properties) throws InitializationException {
        if (callback == null) {
            throw new InitializationException("Attempt to create a SessionFactoryHelper with a null SessionCallback argument");
        }
        if (initData == null) {
            throw new InitializationException("Attempt to create a SessionFactoryHelper with a null InitializationData argument");
        }
        if (properties == null) {
            throw new InitializationException("Attempt to create a SessionFactoryHelper with a null Properties argument");
        }
        this._callback = callback;
        this._initData = initData;
        this._initData.properties = properties;
        this._initData.properties.setProperty("Ice.RetryIntervals", "-1");
    }

    public synchronized void setRouterIdentity(Identity identity) {
        this._identity = identity;
    }

    public synchronized Identity getRouterIdentity() {
        return this._identity;
    }

    public synchronized void setRouterHost(String hostname) {
        this._routerHost = hostname;
    }

    public synchronized String getRouterHost() {
        return this._routerHost;
    }

    @Deprecated
    public void setSecure(boolean secure) {
        this.setProtocol(secure ? "ssl" : "tcp");
    }

    @Deprecated
    public boolean getSecure() {
        return this.getProtocol().equals("ssl");
    }

    public synchronized void setProtocol(String protocol) {
        if (protocol == null) {
            throw new IllegalArgumentException("You must use a valid protocol");
        }
        if (!(protocol.equals("tcp") || protocol.equals("ssl") || protocol.equals("wss") || protocol.equals("ws"))) {
            throw new IllegalArgumentException("Unknow protocol `" + protocol + "'");
        }
        this._protocol = protocol;
    }

    public synchronized String getProtocol() {
        return this._protocol;
    }

    public synchronized void setTimeout(int timeoutMillisecs) {
        this._timeout = timeoutMillisecs;
    }

    public synchronized int getTimeout() {
        return this._timeout;
    }

    public synchronized void setPort(int port) {
        this._port = port;
    }

    public synchronized int getPort() {
        return this.getPortInternal();
    }

    private int getPortInternal() {
        return this._port == 0 ? (this._protocol.equals("ssl") || this._protocol.equals("wss") ? 4064 : 4063) : this._port;
    }

    public synchronized InitializationData getInitializationData() {
        return this._initData;
    }

    public synchronized void setConnectContext(Map<String, String> context) {
        this._context = context;
    }

    public synchronized void setUseCallbacks(boolean useCallbacks) {
        this._useCallbacks = useCallbacks;
    }

    public synchronized boolean getUseCallbacks() {
        return this._useCallbacks;
    }

    public synchronized SessionHelper connect() {
        SessionHelper session = new SessionHelper(this._callback, this.createInitData(), this.getRouterFinderStr(), this._useCallbacks);
        session.connect(this._context);
        return session;
    }

    public synchronized SessionHelper connect(String username, String password) {
        SessionHelper session = new SessionHelper(this._callback, this.createInitData(), this.getRouterFinderStr(), this._useCallbacks);
        session.connect(username, password, this._context);
        return session;
    }

    private InitializationData createInitData() {
        InitializationData initData = this._initData.clone();
        initData.properties = initData.properties._clone();
        if (initData.properties.getProperty("Ice.Default.Router").length() == 0 && this._identity != null) {
            initData.properties.setProperty("Ice.Default.Router", this.getProxyStr(this._identity));
        }
        if ((this._protocol.equals("ssl") || this._protocol.equals("wss")) && initData.properties.getProperty("Ice.Plugin.IceSSL").length() == 0) {
            initData.properties.setProperty("Ice.Plugin.IceSSL", "IceSSL.PluginFactory");
        }
        return initData;
    }

    private String getRouterFinderStr() {
        Identity ident = new Identity("RouterFinder", "Ice");
        return this.getProxyStr(ident);
    }

    private String getProxyStr(Identity ident) {
        StringBuilder sb = new StringBuilder();
        sb.append("\"");
        sb.append(Util.identityToString((Identity)ident));
        sb.append("\":");
        sb.append(this._protocol + " -p ");
        sb.append(this.getPortInternal());
        sb.append(" -h \"");
        sb.append(this._routerHost);
        sb.append("\"");
        if (this._timeout > 0) {
            sb.append(" -t ");
            sb.append(this._timeout);
        }
        return sb.toString();
    }
}

