/*
 * Decompiled with CFR 0.152.
 */
package com.truthbean.logger.log4j2.boot;

import com.truthbean.logger.LogLevel;
import com.truthbean.logger.LoggerFactory;
import com.truthbean.logger.LoggerInitiation;
import java.util.Map;
import java.util.logging.LogManager;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.AbstractConfiguration;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;

public class Log4j2BootInitiation
implements LoggerInitiation {
    private static final String LOG_MANAGER_CLASS = "org.apache.logging.log4j.jul.LogManager";

    public void init() {
        Map config = LoggerFactory.getConfig().getLoggers();
        config.forEach(this::setLogLevel);
    }

    public void flush() {
        Map config = LoggerFactory.getConfig().getLoggers();
        config.forEach(this::setLogLevel);
    }

    public void destroy() {
    }

    public void setLogLevel(String loggerName, LogLevel logLevel) {
        Level level = Level.ERROR;
        switch (logLevel) {
            case OFF: {
                level = Level.OFF;
                break;
            }
            case FATAL: {
                level = Level.FATAL;
                break;
            }
            case ERROR: {
                break;
            }
            case WARN: {
                level = Level.WARN;
                break;
            }
            case INFO: {
                level = Level.INFO;
                break;
            }
            case DEBUG: {
                level = Level.DEBUG;
                break;
            }
            case TRACE: {
                level = Level.TRACE;
                break;
            }
            default: {
                level = Level.ERROR;
            }
        }
        LoggerConfig logger = this.getLogger(loggerName);
        if (logger == null) {
            logger = new LoggerConfig(loggerName, level, true);
            this.getLoggerContext().getConfiguration().addLogger(loggerName, logger);
        } else {
            logger.setLevel(level);
        }
        this.getLoggerContext().updateLoggers();
    }

    private LoggerConfig getLogger(String name) {
        boolean isRootLogger = name != null && !name.isBlank() || "ROOT".equals(name);
        return this.findLogger(isRootLogger ? "" : name);
    }

    private LoggerConfig findLogger(String name) {
        Configuration configuration = this.getLoggerContext().getConfiguration();
        if (configuration instanceof AbstractConfiguration) {
            return ((AbstractConfiguration)configuration).getLogger(name);
        }
        return (LoggerConfig)configuration.getLoggers().get(name);
    }

    private LoggerContext getLoggerContext() {
        return (LoggerContext)org.apache.logging.log4j.LogManager.getContext((boolean)false);
    }

    static {
        System.setProperty("java.util.logging.manager", LOG_MANAGER_CLASS);
        LogManager logManager = LogManager.getLogManager();
        if (!LOG_MANAGER_CLASS.equals(logManager.getClass().getName())) {
            try {
                ClassLoader.getSystemClassLoader().loadClass(LOG_MANAGER_CLASS);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }
}

