/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly;

import com.sun.grizzly.BaseSelectionKeyHandler;
import com.sun.grizzly.CallbackHandler;
import com.sun.grizzly.CallbackHandlerSelectionKeyAttachment;
import com.sun.grizzly.ConnectorHandler;
import com.sun.grizzly.ConnectorInstanceHandler;
import com.sun.grizzly.Context;
import com.sun.grizzly.Controller;
import com.sun.grizzly.Role;
import com.sun.grizzly.SelectionKeyHandler;
import com.sun.grizzly.SelectionKeyOP;
import com.sun.grizzly.TCPSelectorHandler;
import com.sun.grizzly.UDPConnectorHandler;
import com.sun.grizzly.async.UDPAsyncQueueReader;
import com.sun.grizzly.async.UDPAsyncQueueWriter;
import com.sun.grizzly.util.Copyable;
import com.sun.grizzly.util.State;
import java.io.IOException;
import java.net.BindException;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.concurrent.Callable;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UDPSelectorHandler
extends TCPSelectorHandler {
    private static final String NOT_SUPPORTED = "Not supported by this SelectorHandler";
    protected DatagramSocket datagramSocket;
    protected DatagramChannel datagramChannel;

    public UDPSelectorHandler() {
        this(Role.CLIENT_SERVER);
    }

    public UDPSelectorHandler(boolean isClient) {
        this(UDPSelectorHandler.boolean2Role(isClient));
    }

    public UDPSelectorHandler(Role role) {
        super(role);
    }

    @Override
    public void copyTo(Copyable copy) {
        super.copyTo(copy);
        UDPSelectorHandler copyHandler = (UDPSelectorHandler)copy;
        copyHandler.datagramSocket = this.datagramSocket;
        copyHandler.datagramChannel = this.datagramChannel;
    }

    @Override
    public void preSelect(Context ctx) throws IOException {
        this.initOpRegistriesIfRequired();
        if (this.asyncQueueReader == null) {
            this.asyncQueueReader = new UDPAsyncQueueReader(this);
        }
        if (this.asyncQueueWriter == null) {
            this.asyncQueueWriter = new UDPAsyncQueueWriter(this);
        }
        if (this.selector == null) {
            try {
                this.isShutDown.set(false);
                this.connectorInstanceHandler = new ConnectorInstanceHandler.ConcurrentQueueDelegateCIH<ConnectorHandler>(this.getConnectorInstanceHandlerDelegate());
                this.datagramChannel = DatagramChannel.open();
                this.selector = Selector.open();
                if (this.role != Role.CLIENT) {
                    this.datagramSocket = this.datagramChannel.socket();
                    this.datagramSocket.setReuseAddress(this.reuseAddress);
                    if (this.inet == null) {
                        this.datagramSocket.bind(new InetSocketAddress(this.port));
                    } else {
                        this.datagramSocket.bind(new InetSocketAddress(this.inet, this.port));
                    }
                    this.datagramChannel.configureBlocking(false);
                    this.datagramChannel.register(this.selector, 1);
                    this.datagramSocket.setSoTimeout(this.serverTimeout);
                }
                ctx.getController().notifyReady();
            }
            catch (SocketException ex) {
                throw new BindException(ex.getMessage() + ": " + this.port);
            }
        } else {
            this.processPendingOperations(ctx);
        }
    }

    @Override
    protected void connect(SocketAddress remoteAddress, SocketAddress localAddress, CallbackHandler callbackHandler) throws IOException {
        DatagramChannel newDatagramChannel = DatagramChannel.open();
        newDatagramChannel.socket().setReuseAddress(this.reuseAddress);
        if (localAddress != null) {
            newDatagramChannel.socket().bind(localAddress);
        }
        newDatagramChannel.configureBlocking(false);
        SelectionKeyOP.ConnectSelectionKeyOP keyOP = new SelectionKeyOP.ConnectSelectionKeyOP();
        keyOP.setOp(8);
        keyOP.setChannel(newDatagramChannel);
        keyOP.setRemoteAddress(remoteAddress);
        keyOP.setCallbackHandler(callbackHandler);
        this.initOpRegistriesIfRequired();
        this.opToRegister.offer((Object)keyOP);
        this.selector.wakeup();
    }

    @Override
    protected void onConnectOp(Context ctx, SelectionKeyOP.ConnectSelectionKeyOP selectionKeyOp) throws IOException {
        SelectionKey key;
        block2: {
            DatagramChannel newDatagramChannel = (DatagramChannel)selectionKeyOp.getChannel();
            SocketAddress remoteAddress = selectionKeyOp.getRemoteAddress();
            CallbackHandler callbackHandler = selectionKeyOp.getCallbackHandler();
            CallbackHandlerSelectionKeyAttachment attachment = CallbackHandlerSelectionKeyAttachment.create(callbackHandler);
            key = newDatagramChannel.register(this.selector, 5, (Object)attachment);
            attachment.associateKey(key);
            try {
                newDatagramChannel.connect(remoteAddress);
            }
            catch (Exception e) {
                if (!this.logger.isLoggable(Level.FINE)) break block2;
                this.logger.log(Level.FINE, "Exception occured when tried to connect datagram channel", e);
            }
        }
        this.onConnectInterest(key, ctx);
    }

    @Override
    public void shutdown() {
        if (this.isShutDown.getAndSet(true)) {
            return;
        }
        this.stateHolder.setState((Object)State.STOPPED);
        try {
            if (this.datagramSocket != null) {
                this.datagramSocket.close();
            }
        }
        catch (Throwable ex) {
            Controller.logger().log(Level.SEVERE, "closeSocketException", ex);
        }
        try {
            if (this.datagramChannel != null) {
                this.datagramChannel.close();
            }
        }
        catch (Throwable ex) {
            Controller.logger().log(Level.SEVERE, "closeSocketException", ex);
        }
        try {
            if (this.selector != null) {
                this.selector.close();
            }
        }
        catch (Throwable ex) {
            Controller.logger().log(Level.SEVERE, "closeSocketException", ex);
        }
        if (this.asyncQueueReader != null) {
            this.asyncQueueReader.close();
            this.asyncQueueReader = null;
        }
        if (this.asyncQueueWriter != null) {
            this.asyncQueueWriter.close();
            this.asyncQueueWriter = null;
        }
    }

    @Override
    public boolean onAcceptInterest(SelectionKey key, Context ctx) throws IOException {
        return false;
    }

    @Override
    public Class<? extends SelectionKeyHandler> getPreferredSelectionKeyHandler() {
        return BaseSelectionKeyHandler.class;
    }

    @Override
    public Controller.Protocol protocol() {
        return Controller.Protocol.UDP;
    }

    @Override
    public int getPortLowLevel() {
        if (this.datagramSocket != null) {
            return this.datagramSocket.getLocalPort();
        }
        return -1;
    }

    public void setSocketNativeSendBufferSize(int sendBuffSize) throws SocketException {
        this.datagramSocket.setSendBufferSize(sendBuffSize);
    }

    public void setSocketNativeReceiveBufferSize(int recBuffSize) throws SocketException {
        this.datagramSocket.setReceiveBufferSize(recBuffSize);
    }

    public int getSocketNativeReceiveBufferSize() throws SocketException {
        return this.datagramSocket.getReceiveBufferSize();
    }

    public int getSocketNativeSendBufferSize() throws SocketException {
        return this.datagramSocket.getSendBufferSize();
    }

    @Override
    public int getSsBackLog() {
        throw new IllegalStateException(NOT_SUPPORTED);
    }

    @Override
    public void setSsBackLog(int ssBackLog) {
        throw new IllegalStateException(NOT_SUPPORTED);
    }

    @Override
    public boolean isTcpNoDelay() {
        throw new IllegalStateException(NOT_SUPPORTED);
    }

    @Override
    public void setTcpNoDelay(boolean tcpNoDelay) {
        throw new IllegalStateException(NOT_SUPPORTED);
    }

    @Override
    public int getLinger() {
        throw new IllegalStateException(NOT_SUPPORTED);
    }

    @Override
    public void setLinger(int linger) {
        throw new IllegalStateException(NOT_SUPPORTED);
    }

    @Override
    public int getSocketTimeout() {
        throw new IllegalStateException(NOT_SUPPORTED);
    }

    @Override
    public void setSocketTimeout(int socketTimeout) {
        throw new IllegalStateException(NOT_SUPPORTED);
    }

    @Override
    public void closeChannel(SelectableChannel channel) {
        try {
            channel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.asyncQueueReader != null) {
            this.asyncQueueReader.onClose(channel);
        }
        if (this.asyncQueueWriter != null) {
            this.asyncQueueWriter.onClose(channel);
        }
    }

    @Override
    protected Callable<ConnectorHandler> getConnectorInstanceHandlerDelegate() {
        return new Callable<ConnectorHandler>(){

            @Override
            public ConnectorHandler call() throws Exception {
                return new UDPConnectorHandler();
            }
        };
    }
}

