/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.model.AbortMultipartUploadRequest;
import com.qcloud.cos.model.CompleteMultipartUploadRequest;
import com.qcloud.cos.model.CompleteMultipartUploadResult;
import com.qcloud.cos.model.CopyPartRequest;
import com.qcloud.cos.model.CopyPartResult;
import com.qcloud.cos.model.InitiateMultipartUploadRequest;
import com.qcloud.cos.model.InitiateMultipartUploadResult;
import com.qcloud.cos.model.ListPartsRequest;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.PartETag;
import com.qcloud.cos.model.PartListing;
import com.qcloud.cos.model.PartSummary;
import com.qcloud.cos.model.StorageClass;
import com.qcloud.cos.model.UploadPartRequest;
import com.qcloud.cos.model.UploadPartResult;
import com.qcloud.cos.region.Region;
import java.io.ByteArrayInputStream;
import java.util.LinkedList;
import java.util.List;

public class MultipartUploadDemo {
    private static String secretId = System.getenv("SECRETID");
    private static String secretKey = System.getenv("SECRETKEY");
    private static String region = System.getenv("REGION");
    private static String bucketName = System.getenv("BUCKET_NAME");
    private static String key = "aaa/bbb.txt";
    private static COSClient cosClient = MultipartUploadDemo.createCli(region);

    public static void main(String[] args) {
        try {
            MultipartUploadDemo.multipartUploadDemo();
        }
        catch (CosServiceException cse) {
            cse.printStackTrace();
        }
        catch (CosClientException cce) {
            cce.printStackTrace();
        }
        finally {
            cosClient.shutdown();
        }
    }

    private static void multipartUploadDemo() {
        try {
            String uploadId = MultipartUploadDemo.initMultipartUploadDemo();
            List<PartETag> partETags = MultipartUploadDemo.uploadPartDemo(uploadId);
            MultipartUploadDemo.completePartDemo(uploadId, partETags);
        }
        catch (CosServiceException cse) {
            throw cse;
        }
        catch (CosClientException cce) {
            throw cce;
        }
    }

    private static void multipartUploadCopyDemo() {
        try {
            String uploadId = MultipartUploadDemo.initMultipartUploadDemo();
            List<PartETag> partETags = MultipartUploadDemo.copyPartUploadDemo(uploadId);
            if (partETags != null) {
                MultipartUploadDemo.completePartDemo(uploadId, partETags);
            } else {
                MultipartUploadDemo.abortPartUploadDemo(uploadId);
            }
        }
        catch (CosServiceException cse) {
            throw cse;
        }
        catch (CosClientException cce) {
            throw cce;
        }
    }

    private static COSClient createCli(String region) {
        BasicCOSCredentials cred = new BasicCOSCredentials(secretId, secretKey);
        ClientConfig clientConfig = new ClientConfig(new Region(region));
        return new COSClient(cred, clientConfig);
    }

    private static String initMultipartUploadDemo() {
        InitiateMultipartUploadRequest request = new InitiateMultipartUploadRequest(bucketName, key);
        request.setStorageClass(StorageClass.Standard);
        try {
            InitiateMultipartUploadResult initResult = cosClient.initiateMultipartUpload(request);
            String uploadId = initResult.getUploadId();
            System.out.println("succeed to init multipart upload, uploadId:" + uploadId + ", reqId:" + initResult.getRequestId());
            return uploadId;
        }
        catch (CosServiceException e) {
            throw e;
        }
        catch (CosClientException e) {
            throw e;
        }
    }

    private static List<PartETag> listPartDemo(String uploadId) {
        LinkedList<PartETag> partETags = new LinkedList<PartETag>();
        PartListing partListing = null;
        ListPartsRequest listPartsRequest = new ListPartsRequest(bucketName, key, uploadId);
        do {
            try {
                partListing = cosClient.listParts(listPartsRequest);
            }
            catch (CosServiceException e) {
                throw e;
            }
            catch (CosClientException e) {
                throw e;
            }
            for (PartSummary partSummary : partListing.getParts()) {
                partETags.add(new PartETag(partSummary.getPartNumber(), partSummary.getETag()));
                System.out.println("list multipart upload parts, partNum:" + partSummary.getPartNumber() + ", etag:" + partSummary.getETag());
            }
            listPartsRequest.setPartNumberMarker(partListing.getNextPartNumberMarker());
        } while (partListing.isTruncated());
        return partETags;
    }

    private static List<PartETag> uploadPartDemo(String uploadId) {
        boolean userTrafficLimit = false;
        LinkedList<PartETag> partETags = new LinkedList<PartETag>();
        for (int i = 0; i < 10; ++i) {
            byte[] data = new byte[0x100000];
            UploadPartRequest uploadPartRequest = new UploadPartRequest();
            uploadPartRequest.setBucketName(bucketName);
            uploadPartRequest.setKey(key);
            uploadPartRequest.setUploadId(uploadId);
            uploadPartRequest.setInputStream(new ByteArrayInputStream(data));
            uploadPartRequest.setPartSize(data.length);
            uploadPartRequest.setPartNumber(i + 1);
            if (userTrafficLimit) {
                uploadPartRequest.setTrafficLimit(0x800000);
            }
            try {
                UploadPartResult uploadPartResult = cosClient.uploadPart(uploadPartRequest);
                PartETag partETag = uploadPartResult.getPartETag();
                partETags.add(partETag);
                System.out.println("succeed to upload part, partNum:" + uploadPartRequest.getPartNumber() + ", reqId:" + uploadPartResult.getRequestId());
                continue;
            }
            catch (CosServiceException e) {
                throw e;
            }
            catch (CosClientException e) {
                throw e;
            }
        }
        return partETags;
    }

    private static void completePartDemo(String uploadId, List<PartETag> partETags) {
        CompleteMultipartUploadRequest completeMultipartUploadRequest = new CompleteMultipartUploadRequest(bucketName, key, uploadId, partETags);
        try {
            CompleteMultipartUploadResult completeResult = cosClient.completeMultipartUpload(completeMultipartUploadRequest);
            System.out.println("succeed to complete multipart upload");
        }
        catch (CosServiceException e) {
            throw e;
        }
        catch (CosClientException e) {
            throw e;
        }
    }

    private static void abortPartUploadDemo(String uploadId) {
        AbortMultipartUploadRequest abortMultipartUploadRequest = new AbortMultipartUploadRequest(bucketName, key, uploadId);
        try {
            cosClient.abortMultipartUpload(abortMultipartUploadRequest);
            System.out.println("succeed to abort multipart upload, uploadid:" + uploadId);
        }
        catch (CosServiceException e) {
            e.printStackTrace();
        }
        catch (CosClientException e) {
            e.printStackTrace();
        }
    }

    private static List<PartETag> copyPartUploadDemo(String uploadId) {
        CopyPartRequest copyPartRequest = new CopyPartRequest();
        copyPartRequest.setSourceBucketRegion(new Region(region));
        copyPartRequest.setSourceBucketName(bucketName);
        String srcKey = "copySrc.txt";
        copyPartRequest.setSourceKey(srcKey);
        long totalLength = 0L;
        try {
            ObjectMetadata objectMetadata = cosClient.getObjectMetadata(bucketName, srcKey);
            totalLength = objectMetadata.getContentLength();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        int partNum = 1;
        long startIndex = 0L;
        long partSize = 0x100000L;
        long remainLength = totalLength;
        LinkedList<PartETag> partETags = new LinkedList<PartETag>();
        while (remainLength > 0L) {
            copyPartRequest.setFirstByte(startIndex);
            long endIndex = remainLength < partSize ? startIndex + remainLength - 1L : startIndex + partSize - 1L;
            copyPartRequest.setLastByte(endIndex);
            copyPartRequest.setDestinationBucketName(bucketName);
            copyPartRequest.setDestinationKey(key);
            copyPartRequest.setPartNumber(partNum);
            copyPartRequest.setUploadId(uploadId);
            try {
                CopyPartResult copyPartResult = cosClient.copyPart(copyPartRequest);
                PartETag partETag = copyPartResult.getPartETag();
                partETags.add(partETag);
                System.out.println("succeed to copy part, partNum:" + copyPartRequest.getPartNumber() + ", reqId:" + copyPartResult.getRequestId());
            }
            catch (CosServiceException e) {
                e.printStackTrace();
                return null;
            }
            catch (CosClientException e) {
                e.printStackTrace();
                return null;
            }
            remainLength = remainLength < partSize ? 0L : remainLength - partSize;
            startIndex += partSize;
            ++partNum;
        }
        return partETags;
    }
}

