/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.rest.v2.policy;

import com.microsoft.rest.v2.http.HttpPipelineLogLevel;
import com.microsoft.rest.v2.http.HttpRequest;
import com.microsoft.rest.v2.http.HttpResponse;
import com.microsoft.rest.v2.http.UrlBuilder;
import com.microsoft.rest.v2.policy.AbstractRequestPolicy;
import com.microsoft.rest.v2.policy.RequestPolicy;
import com.microsoft.rest.v2.policy.RequestPolicyFactory;
import com.microsoft.rest.v2.policy.RequestPolicyOptions;
import io.reactivex.Single;
import java.net.MalformedURLException;

public class PortPolicyFactory
implements RequestPolicyFactory {
    private final int port;
    private final boolean overwrite;

    public PortPolicyFactory(int port) {
        this(port, true);
    }

    public PortPolicyFactory(int port, boolean overwrite) {
        this.port = port;
        this.overwrite = overwrite;
    }

    @Override
    public RequestPolicy create(RequestPolicy next, RequestPolicyOptions options) {
        return new PortPolicy(next, options);
    }

    private class PortPolicy
    extends AbstractRequestPolicy {
        PortPolicy(RequestPolicy nextPolicy, RequestPolicyOptions options) {
            super(nextPolicy, options);
        }

        @Override
        public Single<HttpResponse> sendAsync(HttpRequest request) {
            UrlBuilder urlBuilder = UrlBuilder.parse(request.url());
            if (PortPolicyFactory.this.overwrite || urlBuilder.port() == null) {
                if (this.shouldLog(HttpPipelineLogLevel.INFO)) {
                    this.log(HttpPipelineLogLevel.INFO, "Changing port to {0}", PortPolicyFactory.this.port);
                }
                try {
                    request.withUrl(urlBuilder.withPort(PortPolicyFactory.this.port).toURL());
                }
                catch (MalformedURLException e) {
                    return Single.error((Throwable)e);
                }
            }
            return this.nextPolicy().sendAsync(request);
        }
    }
}

