/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.zookeeper.zkclient;

import com.github.ltsopensource.core.cluster.Config;
import com.github.ltsopensource.core.registry.NodeRegistryUtils;
import com.github.ltsopensource.zookeeper.ChildListener;
import com.github.ltsopensource.zookeeper.DataListener;
import com.github.ltsopensource.zookeeper.support.AbstractZkClient;
import java.util.List;
import org.I0Itec.zkclient.IZkChildListener;
import org.I0Itec.zkclient.IZkDataListener;
import org.I0Itec.zkclient.IZkStateListener;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.exception.ZkNoNodeException;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.zookeeper.Watcher;

public class ZkClientZkClient
extends AbstractZkClient<IZkChildListener, IZkDataListener> {
    public static final int connectionTimeout = 30000;
    private final ZkClient zkClient;
    private volatile Watcher.Event.KeeperState state = Watcher.Event.KeeperState.SyncConnected;

    public ZkClientZkClient(Config config) {
        String registryAddress = NodeRegistryUtils.getRealRegistryAddress(config.getRegistryAddress());
        this.zkClient = new ZkClient(registryAddress, 30000);
        this.zkClient.subscribeStateChanges(new IZkStateListener(){

            public void handleStateChanged(Watcher.Event.KeeperState state) throws Exception {
                ZkClientZkClient.this.state = state;
                if (state == Watcher.Event.KeeperState.Disconnected) {
                    ZkClientZkClient.this.stateChanged(0);
                } else if (state == Watcher.Event.KeeperState.SyncConnected) {
                    ZkClientZkClient.this.stateChanged(1);
                } else if (state == Watcher.Event.KeeperState.Expired) {
                    ZkClientZkClient.this.stateChanged(0);
                }
            }

            public void handleNewSession() throws Exception {
                ZkClientZkClient.this.stateChanged(2);
            }
        });
    }

    @Override
    protected String createPersistent(String path, boolean sequential) {
        try {
            if (sequential) {
                return this.zkClient.createPersistentSequential(path, (Object)true);
            }
            this.zkClient.createPersistent(path, true);
            return path;
        }
        catch (ZkNodeExistsException zkNodeExistsException) {
            return null;
        }
    }

    @Override
    protected String createPersistent(String path, Object data, boolean sequential) {
        try {
            if (sequential) {
                return this.zkClient.createPersistentSequential(path, data);
            }
            this.zkClient.createPersistent(path, data);
            return path;
        }
        catch (ZkNodeExistsException ignored) {
            return null;
        }
    }

    @Override
    protected String createEphemeral(String path, boolean sequential) {
        try {
            if (sequential) {
                return this.zkClient.createEphemeralSequential(path, (Object)true);
            }
            this.zkClient.createEphemeral(path);
            return path;
        }
        catch (ZkNodeExistsException zkNodeExistsException) {
            return null;
        }
    }

    @Override
    protected String createEphemeral(String path, Object data, boolean sequential) {
        try {
            if (sequential) {
                return this.zkClient.createEphemeralSequential(path, data);
            }
            this.zkClient.createEphemeral(path, data);
            return path;
        }
        catch (ZkNodeExistsException ignored) {
            return null;
        }
    }

    @Override
    protected IZkChildListener createTargetChildListener(String path, final ChildListener listener) {
        return new IZkChildListener(){

            public void handleChildChange(String parentPath, List<String> currentChildes) throws Exception {
                listener.childChanged(parentPath, currentChildes);
            }
        };
    }

    @Override
    protected List<String> addTargetChildListener(String path, IZkChildListener iZkChildListener) {
        return this.zkClient.subscribeChildChanges(path, iZkChildListener);
    }

    @Override
    protected void removeTargetChildListener(String path, IZkChildListener iZkChildListener) {
        this.zkClient.unsubscribeChildChanges(path, iZkChildListener);
    }

    @Override
    protected void addTargetDataListener(String path, IZkDataListener listener) {
        this.zkClient.subscribeDataChanges(path, listener);
    }

    @Override
    protected IZkDataListener createTargetDataListener(String path, final DataListener listener) {
        return new IZkDataListener(){

            public void handleDataChange(String dataPath, Object data) throws Exception {
                listener.dataChange(dataPath, data);
            }

            public void handleDataDeleted(String dataPath) throws Exception {
                listener.dataDeleted(dataPath);
            }
        };
    }

    @Override
    protected void removeTargetDataListener(String path, IZkDataListener listener) {
        this.zkClient.unsubscribeDataChanges(path, listener);
    }

    @Override
    public boolean delete(String path) {
        try {
            return this.zkClient.delete(path);
        }
        catch (ZkNoNodeException zkNoNodeException) {
            return false;
        }
    }

    @Override
    public boolean exists(String path) {
        try {
            return this.zkClient.exists(path);
        }
        catch (ZkNoNodeException zkNoNodeException) {
            return false;
        }
    }

    @Override
    public <T> T getData(String path) {
        return (T)this.zkClient.readData(path);
    }

    @Override
    public void setData(String path, Object data) {
        this.zkClient.writeData(path, data);
    }

    @Override
    public List<String> getChildren(String path) {
        try {
            return this.zkClient.getChildren(path);
        }
        catch (ZkNoNodeException e) {
            return null;
        }
    }

    @Override
    public boolean isConnected() {
        return this.state == Watcher.Event.KeeperState.SyncConnected;
    }

    @Override
    protected void doClose() {
        this.zkClient.close();
    }
}

