/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.tasktracker.runner;

import com.github.ltsopensource.core.commons.utils.DotLogUtils;
import com.github.ltsopensource.core.domain.Action;
import com.github.ltsopensource.core.domain.Job;
import com.github.ltsopensource.core.domain.JobMeta;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.core.support.JobUtils;
import com.github.ltsopensource.core.support.SystemClock;
import com.github.ltsopensource.tasktracker.Result;
import com.github.ltsopensource.tasktracker.domain.Response;
import com.github.ltsopensource.tasktracker.domain.TaskTrackerAppContext;
import com.github.ltsopensource.tasktracker.logger.BizLoggerAdapter;
import com.github.ltsopensource.tasktracker.logger.BizLoggerFactory;
import com.github.ltsopensource.tasktracker.monitor.TaskTrackerMStatReporter;
import com.github.ltsopensource.tasktracker.runner.InterruptibleJobRunner;
import com.github.ltsopensource.tasktracker.runner.JobContext;
import com.github.ltsopensource.tasktracker.runner.JobExtInfo;
import com.github.ltsopensource.tasktracker.runner.JobRunner;
import com.github.ltsopensource.tasktracker.runner.LtsLoggerFactory;
import com.github.ltsopensource.tasktracker.runner.RunnerCallback;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.atomic.AtomicBoolean;
import sun.misc.SharedSecrets;
import sun.nio.ch.Interruptible;

public class JobRunnerDelegate
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobRunnerDelegate.class);
    private JobMeta jobMeta;
    private RunnerCallback callback;
    private BizLoggerAdapter logger;
    private TaskTrackerAppContext appContext;
    private TaskTrackerMStatReporter stat;
    private Interruptible interruptor;
    private JobRunner curJobRunner;
    private AtomicBoolean interrupted = new AtomicBoolean(false);
    private Thread thread;

    public JobRunnerDelegate(TaskTrackerAppContext appContext, JobMeta jobMeta, RunnerCallback callback) {
        this.appContext = appContext;
        this.callback = callback;
        this.jobMeta = jobMeta;
        this.logger = (BizLoggerAdapter)BizLoggerFactory.getLogger(appContext.getBizLogLevel(), appContext.getRemotingClient(), appContext);
        this.stat = (TaskTrackerMStatReporter)appContext.getMStatReporter();
        this.interruptor = new InterruptibleAdapter(){

            @Override
            public void interrupt() {
                JobRunnerDelegate.this.interrupt();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.thread = Thread.currentThread();
        try {
            JobRunnerDelegate.blockedOn(this.interruptor);
            if (Thread.currentThread().isInterrupted()) {
                ((InterruptibleAdapter)this.interruptor).interrupt();
            }
            LtsLoggerFactory.setLogger(this.logger);
            while (this.jobMeta != null) {
                long startTime = SystemClock.now();
                this.logger.setJobMeta(this.jobMeta);
                Response response = new Response();
                response.setJobMeta(this.jobMeta);
                try {
                    this.appContext.getRunnerPool().getRunningJobManager().in(this.jobMeta.getJobId(), this);
                    this.curJobRunner = this.appContext.getRunnerPool().getRunnerFactory().newRunner();
                    Result result = this.curJobRunner.run(this.buildJobContext(this.jobMeta));
                    if (result == null) {
                        response.setAction(Action.EXECUTE_SUCCESS);
                    } else {
                        if (result.getAction() == null) {
                            response.setAction(Action.EXECUTE_SUCCESS);
                        } else {
                            response.setAction(result.getAction());
                        }
                        response.setMsg(result.getMsg());
                    }
                    long time = SystemClock.now() - startTime;
                    this.stat.addRunningTime(time);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Job execute completed : {}, time:{} ms.", this.jobMeta.getJob(), time);
                    }
                }
                catch (Throwable t) {
                    StringWriter sw = new StringWriter();
                    t.printStackTrace(new PrintWriter(sw));
                    response.setAction(Action.EXECUTE_EXCEPTION);
                    response.setMsg(sw.toString());
                    long time = SystemClock.now() - startTime;
                    this.stat.addRunningTime(time);
                    LOGGER.error("Job execute error : {}, time: {}, {}", this.jobMeta.getJob(), time, t.getMessage(), t);
                }
                finally {
                    this.checkInterrupted();
                    this.logger.removeJobMeta();
                    this.appContext.getRunnerPool().getRunningJobManager().out(this.jobMeta.getJobId());
                }
                this.stat(response.getAction());
                if (this.isStopToGetNewJob()) {
                    response.setReceiveNewJob(false);
                }
                this.jobMeta = this.callback.runComplete(response);
                DotLogUtils.dot("JobRunnerDelegate.run get job " + (this.jobMeta == null ? "NULL" : "NOT_NULL"), new Object[0]);
            }
        }
        finally {
            LtsLoggerFactory.remove();
            JobRunnerDelegate.blockedOn(null);
        }
    }

    private JobContext buildJobContext(JobMeta jobMeta) {
        JobContext jobContext = new JobContext();
        Job job = JobUtils.copy(jobMeta.getJob());
        job.setTaskId(jobMeta.getRealTaskId());
        jobContext.setJob(job);
        JobExtInfo jobExtInfo = new JobExtInfo();
        jobExtInfo.setRepeatedCount(jobMeta.getRepeatedCount());
        jobExtInfo.setRetryTimes(jobMeta.getRetryTimes());
        jobExtInfo.setRetry(Boolean.TRUE.toString().equals(jobMeta.getInternalExtParam("__LTS_Is_Retry_Job")));
        jobExtInfo.setJobType(jobMeta.getJobType());
        jobExtInfo.setSeqId(jobMeta.getInternalExtParam("__LTS_Seq_Id"));
        jobContext.setJobExtInfo(jobExtInfo);
        jobContext.setBizLogger(LtsLoggerFactory.getBizLogger());
        return jobContext;
    }

    private void interrupt() {
        if (!this.interrupted.compareAndSet(false, true)) {
            return;
        }
        if (this.curJobRunner != null && this.curJobRunner instanceof InterruptibleJobRunner) {
            ((InterruptibleJobRunner)this.curJobRunner).interrupt();
        }
    }

    private boolean isInterrupted() {
        return this.interrupted.get();
    }

    private void stat(Action action) {
        if (action == null) {
            return;
        }
        switch (action) {
            case EXECUTE_SUCCESS: {
                this.stat.incSuccessNum();
                break;
            }
            case EXECUTE_FAILED: {
                this.stat.incFailedNum();
                break;
            }
            case EXECUTE_LATER: {
                this.stat.incExeLaterNum();
                break;
            }
            case EXECUTE_EXCEPTION: {
                this.stat.incExeExceptionNum();
            }
        }
    }

    private static void blockedOn(Interruptible interruptible) {
        SharedSecrets.getJavaLangAccess().blockedOn(Thread.currentThread(), interruptible);
    }

    private boolean isStopToGetNewJob() {
        if (this.isInterrupted()) {
            return true;
        }
        return this.appContext.getConfig().getInternalData("__LTS.INNER.MACHINE.RES.ENOUGH", true) == false;
    }

    private void checkInterrupted() {
        try {
            if (this.isInterrupted()) {
                this.logger.info("SYSTEM:Interrupted");
            }
        }
        catch (Throwable t) {
            LOGGER.warn("checkInterrupted error", t);
        }
    }

    public Thread currentThread() {
        return this.thread;
    }

    public JobMeta currentJob() {
        return this.jobMeta;
    }

    private abstract class InterruptibleAdapter
    implements Interruptible {
        private InterruptibleAdapter() {
        }

        @Override
        public void interrupt(Thread thread) {
            this.interrupt();
        }

        public abstract void interrupt();
    }
}

