/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.store.mongo;

import com.github.ltsopensource.core.cluster.Config;
import com.github.ltsopensource.core.commons.utils.StringUtils;
import com.github.ltsopensource.store.mongo.MongoFactoryBean;
import com.mongodb.MongoClient;
import java.util.concurrent.ConcurrentHashMap;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.Morphia;

public class DataStoreProvider {
    private static final ConcurrentHashMap<String, Datastore> DATA_STORE_MAP = new ConcurrentHashMap();
    private static final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Datastore getDataStore(Config config) {
        String[] addresses = config.getParameter("mongo.addresses", new String[]{"127.0.0.1:27017"});
        String database = config.getParameter("mongo.database", "lts");
        String username = config.getParameter("mongo.username");
        String pwd = config.getParameter("mongo.password");
        String cachedKey = StringUtils.concat(StringUtils.concat(addresses), database, username, pwd);
        Datastore datastore = DATA_STORE_MAP.get(cachedKey);
        if (datastore == null) {
            try {
                Object object = lock;
                synchronized (object) {
                    datastore = DATA_STORE_MAP.get(cachedKey);
                    if (datastore != null) {
                        return datastore;
                    }
                    Morphia morphia = new Morphia();
                    MongoFactoryBean mongoFactoryBean = new MongoFactoryBean(addresses, username, database, pwd);
                    MongoClient mongo = mongoFactoryBean.createInstance();
                    datastore = morphia.createDatastore(mongo, database);
                    DATA_STORE_MAP.put(cachedKey, datastore);
                }
            }
            catch (Exception e) {
                throw new IllegalStateException(StringUtils.format("connect mongo failed! addresses: {}, database: {}", addresses, database), e);
            }
        }
        return datastore;
    }
}

