/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.store.jdbc.builder;

import com.github.ltsopensource.core.commons.utils.StringUtils;
import java.util.LinkedList;
import java.util.List;

public class WhereSql {
    private StringBuilder sql = new StringBuilder();
    private List<Object> params = new LinkedList<Object>();
    private boolean isFirstCondition = true;
    private static final String PREFIX = " WHERE ";

    public WhereSql() {
        this.sql.append(PREFIX);
    }

    public WhereSql and(String condition, Object value) {
        if (!this.isFirstCondition) {
            this.sql.append(" AND ");
        }
        this.isFirstCondition = false;
        this.sql.append(condition);
        this.params.add(value);
        return this;
    }

    public WhereSql or(String condition, Object value) {
        if (!this.isFirstCondition) {
            this.sql.append(" OR ");
        }
        this.isFirstCondition = false;
        this.sql.append(condition);
        this.params.add(value);
        return this;
    }

    public WhereSql and(String condition) {
        if (!this.isFirstCondition) {
            this.sql.append(" AND ");
        }
        this.isFirstCondition = false;
        this.sql.append(condition);
        return this;
    }

    public WhereSql or(String condition) {
        if (!this.isFirstCondition) {
            this.sql.append(" OR ");
        }
        this.isFirstCondition = false;
        this.sql.append(condition);
        return this;
    }

    public WhereSql andOnNotEmpty(String condition, String value) {
        if (StringUtils.isEmpty(value)) {
            return this;
        }
        return this.and(condition, value);
    }

    public WhereSql orOnNotEmpty(String condition, String value) {
        if (StringUtils.isEmpty(value)) {
            return this;
        }
        return this.or(condition, value);
    }

    public WhereSql andOnNotNull(String condition, Object value) {
        if (value == null) {
            return this;
        }
        return this.and(condition, value);
    }

    public WhereSql orOnNotNull(String condition, Object value) {
        if (value == null) {
            return this;
        }
        return this.or(condition, value);
    }

    public WhereSql andBetween(String column, Object start, Object end) {
        if (start == null && end == null) {
            return this;
        }
        if (!this.isFirstCondition) {
            this.sql.append(" AND ");
        }
        this.isFirstCondition = false;
        if (start != null && end != null) {
            this.sql.append(" (").append(column).append(" BETWEEN ? AND ? ").append(")");
            this.params.add(start);
            this.params.add(end);
            return this;
        }
        if (start == null) {
            this.sql.append(column).append(" <= ? ");
            this.params.add(end);
            return this;
        }
        this.sql.append(column).append(" >= ? ");
        this.params.add(start);
        return this;
    }

    public WhereSql orBetween(String column, Object start, Object end) {
        if (start == null && end == null) {
            return this;
        }
        if (!this.isFirstCondition) {
            this.sql.append(" OR ");
        }
        this.isFirstCondition = false;
        if (start != null && end != null) {
            this.sql.append(" (").append(column).append(" BETWEEN ? AND ? ").append(")");
            this.params.add(start);
            this.params.add(end);
            return this;
        }
        if (start == null) {
            this.sql.append(column).append(" <= ? ");
            this.params.add(end);
            return this;
        }
        this.sql.append(column).append(" >= ? ");
        this.params.add(start);
        return this;
    }

    public List<Object> params() {
        return this.params;
    }

    public String getSQL() {
        String finalSQL = this.sql.toString();
        if (finalSQL.length() == PREFIX.length()) {
            return "";
        }
        return this.sql.toString();
    }
}

