/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.store.jdbc;

import com.github.ltsopensource.store.jdbc.SqlExecutor;
import com.github.ltsopensource.store.jdbc.SqlExecutorVoid;
import com.github.ltsopensource.store.jdbc.SqlTemplate;
import com.github.ltsopensource.store.jdbc.StateException;
import com.github.ltsopensource.store.jdbc.TxConnectionFactory;
import com.github.ltsopensource.store.jdbc.dbutils.DbRunner;
import com.github.ltsopensource.store.jdbc.dbutils.ResultSetHandler;
import com.github.ltsopensource.store.jdbc.dbutils.ScalarHandler;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

class SqlTemplateImpl
implements SqlTemplate {
    private final DataSource dataSource;
    private static final DbRunner dbRunner = new DbRunner();

    public SqlTemplateImpl(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(boolean isReadOnly, SqlExecutor<T> executor) throws SQLException {
        Connection conn = null;
        try {
            conn = this.dataSource.getConnection();
            if (isReadOnly) {
                conn.setReadOnly(true);
            }
            T t = executor.run(conn);
            return t;
        }
        finally {
            this.close(conn);
        }
    }

    private void close(Connection conn) throws SQLException {
        if (conn != null) {
            if (conn.isReadOnly()) {
                conn.setReadOnly(false);
            }
            conn.close();
        }
    }

    @Override
    public void createTable(String sql) throws SQLException {
        this.update(sql, new Object[0]);
    }

    @Override
    public int[] batchInsert(String sql, Object[][] params) throws SQLException {
        return this.batchUpdate(sql, params);
    }

    public int[] batchUpdate(Connection conn, String sql, Object[][] params) throws SQLException {
        return dbRunner.batch(conn, sql, params);
    }

    @Override
    public int[] batchUpdate(final String sql, final Object[][] params) throws SQLException {
        return this.execute(false, new SqlExecutor<int[]>(){

            @Override
            public int[] run(Connection conn) throws SQLException {
                return SqlTemplateImpl.this.batchUpdate(conn, sql, params);
            }
        });
    }

    @Override
    public int insert(String sql, Object ... params) throws SQLException {
        return this.update(sql, params);
    }

    @Override
    public int update(final String sql, final Object ... params) throws SQLException {
        return this.execute(false, new SqlExecutor<Integer>(){

            @Override
            public Integer run(Connection conn) throws SQLException {
                return SqlTemplateImpl.this.update(conn, sql, params);
            }
        });
    }

    @Override
    public int delete(String sql, Object ... params) throws SQLException {
        return this.update(sql, params);
    }

    public int update(Connection conn, String sql, Object ... params) throws SQLException {
        return dbRunner.update(conn, sql, params);
    }

    @Override
    public <T> T query(final String sql, final ResultSetHandler<T> rsh, final Object ... params) throws SQLException {
        return this.execute(true, new SqlExecutor<T>(){

            @Override
            public T run(Connection conn) throws SQLException {
                return SqlTemplateImpl.this.query(conn, sql, rsh, params);
            }
        });
    }

    public <T> T query(Connection conn, String sql, ResultSetHandler<T> rsh, Object ... params) throws SQLException {
        return dbRunner.query(conn, sql, rsh, params);
    }

    @Override
    public <T> T queryForValue(String sql, Object ... params) throws SQLException {
        return this.query(sql, new ScalarHandler(), params);
    }

    public <T> T queryForValue(Connection conn, String sql, Object ... params) throws SQLException {
        return this.query(conn, sql, new ScalarHandler(), params);
    }

    private SqlExecutor<Void> getWrapperExecutor(final SqlExecutorVoid voidExecutor) {
        return new SqlExecutor<Void>(){

            @Override
            public Void run(Connection conn) throws SQLException {
                voidExecutor.run(conn);
                return null;
            }
        };
    }

    @Override
    public void executeInTransaction(SqlExecutorVoid executor) {
        this.executeInTransaction(this.getWrapperExecutor(executor));
    }

    @Override
    public <T> T executeInTransaction(SqlExecutor<T> executor) {
        Connection conn = null;
        try {
            conn = TxConnectionFactory.getTxConnection(this.dataSource);
            T res = executor.run(conn);
            conn.commit();
            T t = res;
            return t;
        }
        catch (Error e) {
            throw this.rollback(conn, e);
        }
        catch (Exception e) {
            throw this.rollback(conn, e);
        }
        finally {
            TxConnectionFactory.closeTx(conn);
        }
    }

    private StateException rollback(Connection conn, Throwable e) {
        try {
            if (conn != null) {
                conn.rollback();
            }
            return new StateException(e);
        }
        catch (SQLException se) {
            return new StateException("Unable to rollback transaction", e);
        }
    }
}

