/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.spring.tasktracker;

import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.spring.tasktracker.JobRunnerHolder;
import com.github.ltsopensource.spring.tasktracker.LTS;
import java.lang.reflect.Method;
import java.util.regex.Pattern;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;

public class Scanner
implements DisposableBean,
BeanFactoryPostProcessor,
BeanPostProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(Scanner.class);
    private String[] annotationPackages;

    public void setBasePackage(String annotationPackage) {
        this.annotationPackages = annotationPackage == null || annotationPackage.length() == 0 ? null : Pattern.compile("\\s*[,]+\\s*").split(annotationPackage);
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (beanFactory instanceof BeanDefinitionRegistry) {
            try {
                Class<?> scannerClass = Class.forName("org.springframework.context.annotation.ClassPathBeanDefinitionScanner");
                Object scanner = scannerClass.getConstructor(BeanDefinitionRegistry.class, Boolean.TYPE).newInstance(beanFactory, true);
                Class<?> filterClass = Class.forName("org.springframework.core.type.filter.AnnotationTypeFilter");
                Object filter = filterClass.getConstructor(Class.class).newInstance(LTS.class);
                Method addIncludeFilter = scannerClass.getMethod("addIncludeFilter", Class.forName("org.springframework.core.type.filter.TypeFilter"));
                addIncludeFilter.invoke(scanner, filter);
                Method scan = scannerClass.getMethod("scan", String[].class);
                scan.invoke(scanner, new Object[]{this.annotationPackages});
            }
            catch (Throwable e) {
                LOGGER.error(e.getMessage(), e);
            }
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class<?> clazz = bean.getClass();
        if (!this.isMatchPackage(clazz)) {
            return bean;
        }
        if (!clazz.isAnnotationPresent(LTS.class)) {
            return bean;
        }
        JobRunnerHolder.addLTSBean(bean);
        return bean;
    }

    public void destroy() throws Exception {
    }

    private boolean isMatchPackage(Class<?> clazz) {
        if (this.annotationPackages == null || this.annotationPackages.length == 0) {
            return true;
        }
        String beanClassName = clazz.getName();
        for (String pkg : this.annotationPackages) {
            if (!beanClassName.startsWith(pkg)) continue;
            return true;
        }
        return false;
    }
}

