/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.spring.tasktracker;

import com.github.ltsopensource.core.commons.utils.StringUtils;
import com.github.ltsopensource.core.domain.Job;
import com.github.ltsopensource.spring.tasktracker.JobDispatchException;
import com.github.ltsopensource.spring.tasktracker.JobRunnerHolder;
import com.github.ltsopensource.tasktracker.Result;
import com.github.ltsopensource.tasktracker.runner.JobContext;
import com.github.ltsopensource.tasktracker.runner.JobRunner;

public class JobDispatcher
implements JobRunner {
    private String shardField = "taskId";

    @Override
    public Result run(JobContext jobContext) throws Throwable {
        Job job = jobContext.getJob();
        String value = this.shardField.equals("taskId") ? job.getTaskId() : job.getParam(this.shardField);
        JobRunner jobRunner = null;
        if (StringUtils.isNotEmpty(value)) {
            jobRunner = JobRunnerHolder.getJobRunner(value);
        }
        if (jobRunner == null && (jobRunner = JobRunnerHolder.getJobRunner("_LTS_DEFAULT")) == null) {
            throw new JobDispatchException("Can not find JobRunner by Shard Value : [" + value + "]");
        }
        return jobRunner.run(jobContext);
    }

    public void setShardField(String shardField) {
        if (StringUtils.isNotEmpty(shardField)) {
            this.shardField = shardField;
        }
    }
}

