/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.spring;

import com.github.ltsopensource.autoconfigure.PropertiesConfigurationFactory;
import com.github.ltsopensource.core.commons.utils.CollectionUtils;
import com.github.ltsopensource.core.listener.MasterChangeListener;
import com.github.ltsopensource.core.properties.JobClientProperties;
import com.github.ltsopensource.jobclient.JobClient;
import com.github.ltsopensource.jobclient.JobClientBuilder;
import com.github.ltsopensource.jobclient.support.JobCompletedHandler;
import java.util.Properties;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class JobClientFactoryBean
implements FactoryBean<JobClient>,
InitializingBean,
DisposableBean {
    private JobClient jobClient;
    private boolean started;
    private String clusterName;
    private String nodeGroup;
    private String registryAddress;
    private String dataPath;
    private String identity;
    private String bindIp;
    private MasterChangeListener[] masterChangeListeners;
    private Properties configs = new Properties();
    private boolean useRetryClient = true;
    private JobCompletedHandler jobCompletedHandler;
    private String[] locations;

    public JobClient getObject() throws Exception {
        return this.jobClient;
    }

    public Class<?> getObjectType() {
        return JobClient.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        JobClientProperties properties = null;
        if (this.locations == null || this.locations.length == 0) {
            properties = new JobClientProperties();
            properties.setUseRetryClient(this.useRetryClient);
            properties.setClusterName(this.clusterName);
            properties.setDataPath(this.dataPath);
            properties.setNodeGroup(this.nodeGroup);
            properties.setRegistryAddress(this.registryAddress);
            properties.setBindIp(this.bindIp);
            properties.setIdentity(this.identity);
            properties.setConfigs(CollectionUtils.toMap(this.configs));
        } else {
            properties = PropertiesConfigurationFactory.createPropertiesConfiguration(JobClientProperties.class, this.locations);
        }
        this.jobClient = JobClientBuilder.buildByProperties(properties);
        if (this.jobCompletedHandler != null) {
            this.jobClient.setJobCompletedHandler(this.jobCompletedHandler);
        }
        if (this.masterChangeListeners != null) {
            for (MasterChangeListener masterChangeListener : this.masterChangeListeners) {
                this.jobClient.addMasterChangeListener(masterChangeListener);
            }
        }
    }

    public void start() {
        if (!this.started) {
            this.jobClient.start();
            this.started = true;
        }
    }

    public void destroy() throws Exception {
        this.jobClient.stop();
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setNodeGroup(String nodeGroup) {
        this.nodeGroup = nodeGroup;
    }

    public void setRegistryAddress(String registryAddress) {
        this.registryAddress = registryAddress;
    }

    public void setDataPath(String dataPath) {
        this.dataPath = dataPath;
    }

    public void setMasterChangeListeners(MasterChangeListener ... masterChangeListeners) {
        this.masterChangeListeners = masterChangeListeners;
    }

    public void setConfigs(Properties configs) {
        this.configs = configs;
    }

    public void setJobCompletedHandler(JobCompletedHandler jobCompletedHandler) {
        this.jobCompletedHandler = jobCompletedHandler;
    }

    public void setUseRetryClient(boolean useRetryClient) {
        this.useRetryClient = useRetryClient;
    }

    public void setLocations(String ... locations) {
        this.locations = locations;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    public void setBindIp(String bindIp) {
        this.bindIp = bindIp;
    }
}

