/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.queue.mongo;

import com.github.ltsopensource.core.cluster.Config;
import com.github.ltsopensource.core.commons.utils.CollectionUtils;
import com.github.ltsopensource.queue.ExecutingJobQueue;
import com.github.ltsopensource.queue.domain.JobPo;
import com.github.ltsopensource.queue.mongo.AbstractMongoJobQueue;
import com.github.ltsopensource.store.jdbc.exception.DupEntryException;
import com.mongodb.DBCollection;
import com.mongodb.DuplicateKeyException;
import com.mongodb.WriteResult;
import java.util.List;
import org.mongodb.morphia.query.Query;

public class MongoExecutingJobQueue
extends AbstractMongoJobQueue
implements ExecutingJobQueue {
    public MongoExecutingJobQueue(Config config) {
        super(config);
        this.setTableName("lts_executing_job_queue");
        DBCollection dbCollection = this.template.getCollection();
        List indexInfo = dbCollection.getIndexInfo();
        if (CollectionUtils.sizeOf(indexInfo) <= 1) {
            this.template.ensureIndex("idx_jobId", "jobId", true, true);
            this.template.ensureIndex("idx_taskId_taskTrackerNodeGroup", "taskId, taskTrackerNodeGroup", true, true);
            this.template.ensureIndex("idx_realTaskId_taskTrackerNodeGroup", "realTaskId, taskTrackerNodeGroup");
            this.template.ensureIndex("idx_jobType", "jobType");
            this.template.ensureIndex("idx_taskTrackerIdentity", "taskTrackerIdentity");
            this.template.ensureIndex("idx_gmtCreated", "gmtCreated");
        }
    }

    @Override
    protected String getTargetTable(String taskTrackerNodeGroup) {
        return "lts_executing_job_queue";
    }

    @Override
    public boolean add(JobPo jobPo) {
        try {
            this.template.save(jobPo);
        }
        catch (DuplicateKeyException e) {
            throw new DupEntryException(e);
        }
        return true;
    }

    @Override
    public boolean remove(String jobId) {
        Query<JobPo> query = this.template.createQuery(JobPo.class);
        query.field("jobId").equal((Object)jobId);
        WriteResult wr = this.template.delete(query);
        return wr.getN() == 1;
    }

    @Override
    public List<JobPo> getJobs(String taskTrackerIdentity) {
        Query<JobPo> query = this.template.createQuery(JobPo.class);
        query.field("taskTrackerIdentity").equal((Object)taskTrackerIdentity);
        return query.asList();
    }

    @Override
    public List<JobPo> getDeadJobs(long deadline) {
        Query<JobPo> query = this.template.createQuery(JobPo.class);
        query.filter("gmtModified < ", (Object)deadline);
        return query.asList();
    }

    @Override
    public JobPo getJob(String taskTrackerNodeGroup, String taskId) {
        Query<JobPo> query = this.template.createQuery(JobPo.class);
        ((Query)query.field("taskId").equal((Object)taskId)).field("taskTrackerNodeGroup").equal((Object)taskTrackerNodeGroup);
        return (JobPo)query.get();
    }

    @Override
    public JobPo getJob(String jobId) {
        Query<JobPo> query = this.template.createQuery(JobPo.class);
        query.field("jobId").equal((Object)jobId);
        return (JobPo)query.get();
    }
}

