/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.json.deserializer;

import com.github.ltsopensource.json.JSONArray;
import com.github.ltsopensource.json.JSONException;
import com.github.ltsopensource.json.JSONParser;
import com.github.ltsopensource.json.deserializer.Deserializer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.TreeSet;

public class CollectionDeserializer
implements Deserializer {
    public static final CollectionDeserializer INSTANCE = new CollectionDeserializer();

    @Override
    public <T> T deserialize(Object object, Type type) {
        Object itemType;
        Collection<Object> list;
        if (object instanceof String) {
            object = new JSONArray(object);
        }
        if (!(object instanceof JSONArray) && !(object instanceof Collection)) {
            throw new IllegalArgumentException("object=" + object);
        }
        Class<AbstractCollection> rawClass = this.getRawClass(type);
        if (rawClass == AbstractCollection.class) {
            list = new ArrayList();
        } else if (rawClass.isAssignableFrom(HashSet.class)) {
            list = new HashSet();
        } else if (rawClass.isAssignableFrom(LinkedHashSet.class)) {
            list = new LinkedHashSet();
        } else if (rawClass.isAssignableFrom(TreeSet.class)) {
            list = new TreeSet();
        } else if (rawClass.isAssignableFrom(ArrayList.class)) {
            list = new ArrayList();
        } else if (rawClass.isAssignableFrom(EnumSet.class)) {
            itemType = type instanceof ParameterizedType ? ((ParameterizedType)type).getActualTypeArguments()[0] : Object.class;
            list = EnumSet.noneOf(itemType);
        } else {
            try {
                list = (Collection)rawClass.newInstance();
            }
            catch (Exception e) {
                throw new JSONException("create instance error, class " + rawClass.getName());
            }
        }
        itemType = type instanceof ParameterizedType ? ((ParameterizedType)type).getActualTypeArguments()[0] : Object.class;
        Iterable it = (Iterable)object;
        for (Object o : it) {
            Deserializer itemDeserializer = JSONParser.getDeserializer((Type)itemType);
            list.add(itemDeserializer.deserialize(o, (Type)itemType));
        }
        return (T)list;
    }

    public Class<?> getRawClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return this.getRawClass(((ParameterizedType)type).getRawType());
        }
        throw new JSONException("can't resolve the rawClass by " + type);
    }
}

