/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.jobtracker.processor;

import com.github.ltsopensource.core.protocol.command.JobCompletedRequest;
import com.github.ltsopensource.jobtracker.complete.biz.JobCompletedBiz;
import com.github.ltsopensource.jobtracker.complete.biz.JobProcBiz;
import com.github.ltsopensource.jobtracker.complete.biz.JobStatBiz;
import com.github.ltsopensource.jobtracker.complete.biz.PushNewJobBiz;
import com.github.ltsopensource.jobtracker.domain.JobTrackerAppContext;
import com.github.ltsopensource.jobtracker.processor.AbstractRemotingProcessor;
import com.github.ltsopensource.remoting.Channel;
import com.github.ltsopensource.remoting.exception.RemotingCommandException;
import com.github.ltsopensource.remoting.protocol.RemotingCommand;
import com.github.ltsopensource.remoting.protocol.RemotingProtos;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class JobCompletedProcessor
extends AbstractRemotingProcessor {
    private List<JobCompletedBiz> bizChain = new CopyOnWriteArrayList<JobCompletedBiz>();

    public JobCompletedProcessor(JobTrackerAppContext appContext) {
        super(appContext);
        this.bizChain.add(new JobStatBiz(appContext));
        this.bizChain.add(new JobProcBiz(appContext));
        this.bizChain.add(new PushNewJobBiz(appContext));
    }

    @Override
    public RemotingCommand processRequest(Channel channel, RemotingCommand request) throws RemotingCommandException {
        JobCompletedRequest requestBody = (JobCompletedRequest)request.getBody();
        for (JobCompletedBiz biz : this.bizChain) {
            RemotingCommand remotingCommand = biz.doBiz(requestBody);
            if (remotingCommand == null) continue;
            return remotingCommand;
        }
        return RemotingCommand.createResponseCommand(RemotingProtos.ResponseCode.SUCCESS.code());
    }
}

