/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.jobtracker.complete;

import com.github.ltsopensource.biz.logger.domain.JobLogPo;
import com.github.ltsopensource.biz.logger.domain.LogType;
import com.github.ltsopensource.core.commons.utils.CollectionUtils;
import com.github.ltsopensource.core.constant.Level;
import com.github.ltsopensource.core.domain.JobMeta;
import com.github.ltsopensource.core.domain.JobRunResult;
import com.github.ltsopensource.core.json.JSON;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.core.support.CronExpressionUtils;
import com.github.ltsopensource.core.support.JobDomainConverter;
import com.github.ltsopensource.core.support.JobUtils;
import com.github.ltsopensource.core.support.SystemClock;
import com.github.ltsopensource.jobtracker.domain.JobTrackerAppContext;
import com.github.ltsopensource.queue.domain.JobPo;
import com.github.ltsopensource.store.jdbc.exception.DupEntryException;
import java.util.Date;
import java.util.List;

public class JobFinishHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobFinishHandler.class);
    private JobTrackerAppContext appContext;

    public JobFinishHandler(JobTrackerAppContext appContext) {
        this.appContext = appContext;
    }

    public void onComplete(List<JobRunResult> results) {
        if (CollectionUtils.isEmpty(results)) {
            return;
        }
        for (JobRunResult result : results) {
            JobMeta jobMeta = result.getJobMeta();
            boolean isRetryForThisTime = Boolean.TRUE.toString().equals(jobMeta.getInternalExtParam("__LTS_Is_Retry_Job"));
            boolean isOnce = Boolean.TRUE.toString().equals(jobMeta.getInternalExtParam("__LTS_ONCE"));
            if (jobMeta.getJob().isCron()) {
                if (isOnce) {
                    this.finishNoReplyPrevCronJob(jobMeta);
                } else {
                    this.finishCronJob(jobMeta.getJobId());
                }
            } else if (jobMeta.getJob().isRepeatable()) {
                if (isOnce) {
                    this.finishNoReplyPrevRepeatJob(jobMeta, isRetryForThisTime);
                } else {
                    this.finishRepeatJob(jobMeta.getJobId(), isRetryForThisTime);
                }
            }
            this.appContext.getExecutingJobQueue().remove(jobMeta.getJobId());
        }
    }

    private void finishCronJob(String jobId) {
        JobPo jobPo = this.appContext.getCronJobQueue().getJob(jobId);
        if (jobPo == null) {
            return;
        }
        Date nextTriggerTime = CronExpressionUtils.getNextTriggerTime(jobPo.getCronExpression());
        if (nextTriggerTime == null) {
            this.appContext.getCronJobQueue().remove(jobId);
            this.jobRemoveLog(jobPo, "Cron");
            return;
        }
        try {
            jobPo.setTaskTrackerIdentity(null);
            jobPo.setIsRunning(false);
            jobPo.setTriggerTime(nextTriggerTime.getTime());
            jobPo.setGmtModified(SystemClock.now());
            jobPo.setInternalExtParam("__LTS_Seq_Id", JobUtils.generateExeSeqId(jobPo));
            this.appContext.getExecutableJobQueue().add(jobPo);
        }
        catch (DupEntryException e) {
            LOGGER.warn("ExecutableJobQueue already exist:" + JSON.toJSONString(jobPo));
        }
    }

    private void finishNoReplyPrevCronJob(JobMeta jobMeta) {
        JobPo jobPo = this.appContext.getCronJobQueue().getJob(jobMeta.getJob().getTaskTrackerNodeGroup(), jobMeta.getRealTaskId());
        if (jobPo == null) {
            return;
        }
        Date nextTriggerTime = CronExpressionUtils.getNextTriggerTime(jobPo.getCronExpression());
        if (nextTriggerTime == null && this.appContext.getExecutableJobQueue().countJob(jobPo.getRealTaskId(), jobPo.getTaskTrackerNodeGroup()) == 0L) {
            this.appContext.getCronJobQueue().remove(jobPo.getJobId());
            this.jobRemoveLog(jobPo, "Cron");
        }
    }

    private void finishNoReplyPrevRepeatJob(JobMeta jobMeta, boolean isRetryForThisTime) {
        JobPo jobPo = this.appContext.getRepeatJobQueue().getJob(jobMeta.getJob().getTaskTrackerNodeGroup(), jobMeta.getRealTaskId());
        if (jobPo == null) {
            return;
        }
        if (jobPo.getRepeatCount() != -1 && jobPo.getRepeatedCount() >= jobPo.getRepeatCount()) {
            this.appContext.getRepeatJobQueue().remove(jobPo.getJobId());
            this.jobRemoveLog(jobPo, "Repeat");
            return;
        }
        if (!isRetryForThisTime) {
            this.appContext.getRepeatJobQueue().incRepeatedCount(jobPo.getJobId());
        }
    }

    private void finishRepeatJob(String jobId, boolean isRetryForThisTime) {
        JobPo jobPo = this.appContext.getRepeatJobQueue().getJob(jobId);
        if (jobPo == null) {
            return;
        }
        if (jobPo.getRepeatCount() != -1 && jobPo.getRepeatedCount() >= jobPo.getRepeatCount()) {
            this.appContext.getRepeatJobQueue().remove(jobId);
            this.jobRemoveLog(jobPo, "Repeat");
            return;
        }
        int repeatedCount = jobPo.getRepeatedCount();
        if (!isRetryForThisTime) {
            repeatedCount = this.appContext.getRepeatJobQueue().incRepeatedCount(jobId);
        }
        if (repeatedCount == -1) {
            return;
        }
        long nexTriggerTime = JobUtils.getRepeatNextTriggerTime(jobPo);
        try {
            jobPo.setRepeatedCount(repeatedCount);
            jobPo.setTaskTrackerIdentity(null);
            jobPo.setIsRunning(false);
            jobPo.setTriggerTime(nexTriggerTime);
            jobPo.setGmtModified(SystemClock.now());
            jobPo.setInternalExtParam("__LTS_Seq_Id", JobUtils.generateExeSeqId(jobPo));
            this.appContext.getExecutableJobQueue().add(jobPo);
        }
        catch (DupEntryException e) {
            LOGGER.warn("ExecutableJobQueue already exist:" + JSON.toJSONString(jobPo));
        }
    }

    private void jobRemoveLog(JobPo jobPo, String type) {
        JobLogPo jobLogPo = JobDomainConverter.convertJobLog(jobPo);
        jobLogPo.setSuccess(true);
        jobLogPo.setLogType(LogType.DEL);
        jobLogPo.setLogTime(SystemClock.now());
        jobLogPo.setLevel(Level.INFO);
        jobLogPo.setMsg(type + " Job Finished");
        this.appContext.getJobLogger().log(jobLogPo);
    }
}

