/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.jobtracker.cmd;

import com.github.ltsopensource.cmd.HttpCmdProc;
import com.github.ltsopensource.cmd.HttpCmdRequest;
import com.github.ltsopensource.cmd.HttpCmdResponse;
import com.github.ltsopensource.core.commons.utils.StringUtils;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.jobtracker.domain.JobTrackerAppContext;

public class TriggerJobManuallyHttpCmd
implements HttpCmdProc {
    private final Logger LOGGER = LoggerFactory.getLogger(TriggerJobManuallyHttpCmd.class);
    private JobTrackerAppContext appContext;

    public TriggerJobManuallyHttpCmd(JobTrackerAppContext appContext) {
        this.appContext = appContext;
    }

    @Override
    public String nodeIdentity() {
        return this.appContext.getConfig().getIdentity();
    }

    @Override
    public String getCommand() {
        return "trigger_job_manually_cmd";
    }

    @Override
    public HttpCmdResponse execute(HttpCmdRequest request) throws Exception {
        String taskTrackerNodeGroup = request.getParam("nodeGroup");
        String jobId = request.getParam("jobId");
        if (StringUtils.isEmpty(taskTrackerNodeGroup)) {
            return HttpCmdResponse.newResponse(true, "nodeGroup should not be empty");
        }
        if (StringUtils.isEmpty(jobId)) {
            return HttpCmdResponse.newResponse(true, "jobId should not be empty");
        }
        this.appContext.getPreLoader().loadOne2First(taskTrackerNodeGroup, jobId);
        this.LOGGER.info("Trigger Job jobId={} taskTrackerNodeGroup={}", jobId, taskTrackerNodeGroup);
        return HttpCmdResponse.newResponse(true, "trigger job succeed");
    }
}

