/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.jobtracker.cmd;

import com.github.ltsopensource.cmd.HttpCmdProc;
import com.github.ltsopensource.cmd.HttpCmdRequest;
import com.github.ltsopensource.cmd.HttpCmdResponse;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.jobtracker.domain.JobTrackerAppContext;

public class LoadJobHttpCmd
implements HttpCmdProc {
    private final Logger LOGGER = LoggerFactory.getLogger(LoadJobHttpCmd.class);
    private JobTrackerAppContext appContext;

    public LoadJobHttpCmd(JobTrackerAppContext appContext) {
        this.appContext = appContext;
    }

    @Override
    public String nodeIdentity() {
        return this.appContext.getConfig().getIdentity();
    }

    @Override
    public String getCommand() {
        return "job_load_cmd";
    }

    @Override
    public HttpCmdResponse execute(HttpCmdRequest request) throws Exception {
        String taskTrackerNodeGroup = request.getParam("nodeGroup");
        this.appContext.getPreLoader().load(taskTrackerNodeGroup);
        this.LOGGER.info("load job succeed : nodeGroup={}", taskTrackerNodeGroup);
        return HttpCmdResponse.newResponse(true, "load job succeed");
    }
}

