/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.core.commons.file;

import com.github.ltsopensource.core.commons.file.FileUtils;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;

public class FileLock {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileLock.class);
    private FileChannel channel = null;
    private java.nio.channels.FileLock lock = null;
    private RandomAccessFile randomAccessFile;

    public FileLock(String filename) {
        this(new File(filename));
    }

    public FileLock(File file) {
        FileUtils.createFileIfNotExist(file);
        try {
            this.randomAccessFile = new RandomAccessFile(file, "rw");
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryLock() {
        block18: {
            boolean bl;
            boolean success = false;
            try {
                if (this.channel != null && this.channel.isOpen()) {
                    boolean bl2 = false;
                    return bl2;
                }
                this.channel = this.randomAccessFile.getChannel();
                this.lock = this.channel.tryLock();
                if (this.lock == null) break block18;
                success = true;
                bl = true;
            }
            catch (Exception e) {
                boolean bl3 = false;
                return bl3;
            }
            finally {
                if (!success && this.channel != null) {
                    try {
                        this.channel.close();
                    }
                    catch (IOException ignored) {}
                }
            }
            return bl;
        }
        return false;
    }

    public void release() {
        try {
            if (this.lock != null) {
                this.lock.release();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (this.channel != null) {
                try {
                    this.channel.close();
                }
                catch (IOException e) {
                    LOGGER.error("file channel close failed.", e);
                }
            }
        }
    }
}

