/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.jobclient.support;

import com.github.ltsopensource.core.AppContext;
import com.github.ltsopensource.core.cluster.NodeType;
import com.github.ltsopensource.core.domain.monitor.JobClientMData;
import com.github.ltsopensource.core.domain.monitor.MData;
import com.github.ltsopensource.core.monitor.AbstractMStatReporter;
import java.util.concurrent.atomic.AtomicLong;

public class JobClientMStatReporter
extends AbstractMStatReporter {
    private AtomicLong submitSuccessNum = new AtomicLong(0L);
    private AtomicLong submitFailedNum = new AtomicLong(0L);
    private AtomicLong failStoreNum = new AtomicLong(0L);
    private AtomicLong submitFailStoreNum = new AtomicLong(0L);
    private AtomicLong handleFeedbackNum = new AtomicLong(0L);

    public JobClientMStatReporter(AppContext appContext) {
        super(appContext);
    }

    public void incSubmitSuccessNum(int num) {
        this.submitSuccessNum.addAndGet(num);
    }

    public void incSubmitFailedNum(int num) {
        this.submitFailedNum.addAndGet(num);
    }

    public void incFailStoreNum() {
        this.failStoreNum.incrementAndGet();
    }

    public void incSubmitFailStoreNum(int num) {
        this.submitFailStoreNum.addAndGet(num);
    }

    public void incHandleFeedbackNum(int num) {
        this.handleFeedbackNum.addAndGet(num);
    }

    protected MData collectMData() {
        JobClientMData mData = new JobClientMData();
        mData.setSubmitSuccessNum(Long.valueOf(this.submitSuccessNum.getAndSet(0L)));
        mData.setSubmitFailedNum(Long.valueOf(this.submitFailedNum.getAndSet(0L)));
        mData.setFailStoreNum(Long.valueOf(this.failStoreNum.getAndSet(0L)));
        mData.setSubmitFailStoreNum(Long.valueOf(this.submitFailStoreNum.getAndSet(0L)));
        mData.setHandleFeedbackNum(Long.valueOf(this.handleFeedbackNum.getAndSet(0L)));
        return mData;
    }

    protected NodeType getNodeType() {
        return NodeType.JOB_CLIENT;
    }
}

