/*
 * Decompiled with CFR 0.152.
 */
package com.github.fakemongo.impl.aggregation;

import com.github.fakemongo.impl.ExpressionParser;
import com.github.fakemongo.impl.aggregation.PipelineKeyword;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.annotations.ThreadSafe;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bson.BSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddFields
extends PipelineKeyword {
    private static final Logger LOGGER = LoggerFactory.getLogger(AddFields.class);
    public static AddFields INSTANCE = new AddFields();

    @Override
    public DBCollection apply(DB originalDB, DBCollection parentColl, DBObject addFieldsQuery) {
        LOGGER.trace(">>>> applying $addFields pipeline operation");
        DBObject fieldsToAddExpr = ExpressionParser.toDbObject(addFieldsQuery.get(this.getKeyword()));
        List<DBObject> dbObjects = this.addFieldsToDocument(parentColl, fieldsToAddExpr);
        LOGGER.trace("<<<< applying $addFields pipeline operation");
        return this.dropAndInsert(parentColl, dbObjects);
    }

    private List<DBObject> addFieldsToDocument(DBCollection parentColl, DBObject fieldsToAddExpr) {
        ArrayList<DBObject> dbObjects = new ArrayList<DBObject>();
        DBCursor cursor = parentColl.find();
        for (DBObject item : cursor) {
            BasicDBObject newObject = new BasicDBObject();
            newObject.putAll((BSONObject)item);
            dbObjects.add((DBObject)newObject);
            for (String fieldToAdd : fieldsToAddExpr.keySet()) {
                Object object = fieldsToAddExpr.get(fieldToAdd);
                AddFields.validateNull(object, "Expression for field " + fieldToAdd + " cannot be null");
                for (AddFieldsExpr addFieldsExpr : AddFieldsExpr.values()) {
                    if (!addFieldsExpr.canApply(object)) continue;
                    addFieldsExpr.apply((DBObject)newObject, fieldToAdd, object);
                }
            }
        }
        return dbObjects;
    }

    @Override
    public String getKeyword() {
        return "$addFields";
    }

    @ThreadSafe
    static enum AddFieldsExpr {
        SUM("$sum"){

            @Override
            void apply(DBObject itemToAddFieldsTo, String newFieldName, Object sumExprObjParam) {
                PipelineKeyword.validateTrue(DBObject.class.isAssignableFrom(sumExprObjParam.getClass()), "expr must be of DBObject type");
                DBObject sumExprObj = (DBObject)sumExprObjParam;
                Object sumExpr = sumExprObj.get(this.getKeyword());
                double result = 0.0;
                if (String.class.isAssignableFrom(sumExpr.getClass())) {
                    String sumExprStr = (String)sumExpr;
                    if (sumExprStr.charAt(0) == '$') {
                        String fieldNameToSum = sumExprStr.substring(1);
                        Object fieldToSum = itemToAddFieldsTo.get(fieldNameToSum);
                        PipelineKeyword.validateNull(fieldToSum, "field expr " + sumExprStr + " evaluated to null");
                        PipelineKeyword.validateTrue(Iterable.class.isAssignableFrom(fieldToSum.getClass()), "field to sum must be an iterable type");
                        Iterable iterable = (Iterable)fieldToSum;
                        int index = 0;
                        for (Object iterableItem : iterable) {
                            PipelineKeyword.validateTrue(Number.class.isAssignableFrom(iterableItem.getClass()), "Value at index [" + index++ + "] must be numeric");
                            Number number = (Number)iterableItem;
                            result += number.doubleValue();
                        }
                    } else {
                        PipelineKeyword.fongo.errorResult(15955, "String expr for $sum must start with $").throwOnError();
                    }
                    itemToAddFieldsTo.put(newFieldName, (Object)result);
                } else if (Number.class.isAssignableFrom(sumExpr.getClass())) {
                    itemToAddFieldsTo.put(newFieldName, (Object)((Number)sumExpr).doubleValue());
                } else {
                    PipelineKeyword.fongo.errorResult(15955, "$sum must either be a numeric field or a literal number").throwOnError();
                }
            }
        }
        ,
        ADD("$add"){

            @Override
            void apply(DBObject itemToAddFieldsTo, String newFieldName, Object addExprObjParam) {
                PipelineKeyword.validateTrue(DBObject.class.isAssignableFrom(addExprObjParam.getClass()), "expr must be of DBObject type");
                DBObject addExprObj = (DBObject)addExprObjParam;
                Object addExpr = addExprObj.get(this.getKeyword());
                PipelineKeyword.validateTrue(Iterable.class.isAssignableFrom(addExpr.getClass()), "add expression must be an array");
                Iterable iterable = (Iterable)addExpr;
                double result = 0.0;
                int index = 0;
                for (Object iterableItem : iterable) {
                    if (String.class.isAssignableFrom(iterableItem.getClass())) {
                        String iterableItemStr = (String)iterableItem;
                        PipelineKeyword.validateTrue(iterableItemStr.startsWith("$"), "Field expression must start with $ at index [" + index + "]");
                        String fieldValueToAdd = iterableItemStr.substring(1);
                        Object value = itemToAddFieldsTo.get(fieldValueToAdd);
                        PipelineKeyword.validateTrue(Number.class.isAssignableFrom(value.getClass()), "Field value to add must be numeric  at index [" + index + "]");
                        result += ((Number)value).doubleValue();
                        continue;
                    }
                    PipelineKeyword.validateTrue(Number.class.isAssignableFrom(iterableItem.getClass()), "Field value to add must be numeric  at index [" + index + "]");
                    result += ((Number)iterableItem).doubleValue();
                }
                itemToAddFieldsTo.put(newFieldName, (Object)result);
            }
        }
        ,
        LITERAL(""){
            private Set<Class> SUPPORTED_TYPES;

            @Override
            void apply(DBObject itemToAddFieldsTo, String newFieldName, Object addExprObjParam) {
                if (addExprObjParam instanceof String) {
                    String addExprObj = (String)addExprObjParam;
                    if (addExprObj.startsWith("$")) {
                        itemToAddFieldsTo.put(newFieldName, itemToAddFieldsTo.get(addExprObj.substring(1)));
                    } else {
                        itemToAddFieldsTo.put(newFieldName, addExprObjParam);
                    }
                } else {
                    itemToAddFieldsTo.put(newFieldName, addExprObjParam);
                }
            }

            @Override
            public boolean canApply(Object parameter) {
                return this.SUPPORTED_TYPES.contains(parameter.getClass());
            }

            @Override
            protected void init() {
                this.SUPPORTED_TYPES = new HashSet<Class>();
                this.SUPPORTED_TYPES.add(Boolean.class);
                this.SUPPORTED_TYPES.add(Character.class);
                this.SUPPORTED_TYPES.add(Byte.class);
                this.SUPPORTED_TYPES.add(Short.class);
                this.SUPPORTED_TYPES.add(String.class);
                this.SUPPORTED_TYPES.add(Integer.class);
                this.SUPPORTED_TYPES.add(Long.class);
                this.SUPPORTED_TYPES.add(Float.class);
                this.SUPPORTED_TYPES.add(Double.class);
                this.SUPPORTED_TYPES.add(Void.class);
            }
        };

        private final String keyword;

        private AddFieldsExpr(String keyword) {
            this.keyword = keyword;
            this.init();
        }

        abstract void apply(DBObject var1, String var2, Object var3);

        public boolean canApply(Object parameter) {
            return parameter instanceof DBObject && ((DBObject)parameter).containsField(this.keyword);
        }

        protected void init() {
        }

        public String getKeyword() {
            return this.keyword;
        }
    }
}

