/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.template;

import com.frameworkset.util.VariableHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.frameworkset.elasticsearch.template.ESInfo;
import org.frameworkset.util.annotations.DateFormateMeta;

public class ESTemplateCache {
    private Lock lock = new ReentrantLock();
    private Lock vtplLock = new ReentrantLock();
    private Map<String, VariableHandler.URLStruction> parserTempateStructions = new HashMap<String, VariableHandler.URLStruction>();
    private Map<String, Map<String, VariableHandler.URLStruction>> parserVTPLTempateStructions = new HashMap<String, Map<String, VariableHandler.URLStruction>>();
    private static TempateStructionBuiler tempateStructionBuiler = new TempateStructionBuiler();

    public void clear() {
        this.parserTempateStructions.clear();
        this.parserVTPLTempateStructions.clear();
    }

    public VariableHandler.URLStruction getTemplateStruction(ESInfo sqlinfo, String template) {
        if (sqlinfo.isTpl()) {
            return this._getVTPLTemplateStruction(sqlinfo, template);
        }
        return this._getTemplateStruction(sqlinfo, template);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VariableHandler.URLStruction _getTemplateStruction(ESInfo sqlinfo, String template) {
        String key = sqlinfo.getTemplateName();
        VariableHandler.URLStruction sqlstruction = this.parserTempateStructions.get(key);
        if (sqlstruction == null) {
            try {
                this.lock.lock();
                sqlstruction = this.parserTempateStructions.get(key);
                if (sqlstruction == null) {
                    sqlstruction = VariableHandler.parserStruction((String)template, (VariableHandler.StructionBuiler)tempateStructionBuiler);
                    this.parserTempateStructions.put(key, sqlstruction);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return sqlstruction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VariableHandler.URLStruction _getVTPLTemplateStruction(ESInfo sqlinfo, String template) {
        VariableHandler.URLStruction urlStruction;
        String ikey = template;
        String okey = sqlinfo.getTemplateName();
        Map<String, VariableHandler.URLStruction> sqlstructionMap = this.parserVTPLTempateStructions.get(okey);
        if (sqlstructionMap == null) {
            try {
                this.vtplLock.lock();
                sqlstructionMap = this.parserVTPLTempateStructions.get(okey);
                if (sqlstructionMap == null) {
                    sqlstructionMap = new WeakHashMap<String, VariableHandler.URLStruction>();
                    this.parserVTPLTempateStructions.put(okey, sqlstructionMap);
                }
            }
            finally {
                this.vtplLock.unlock();
            }
        }
        if ((urlStruction = sqlstructionMap.get(ikey)) == null) {
            try {
                this.vtplLock.lock();
                urlStruction = sqlstructionMap.get(ikey);
                if (urlStruction == null) {
                    urlStruction = VariableHandler.parserStruction((String)template, (VariableHandler.StructionBuiler)tempateStructionBuiler);
                    sqlstructionMap.put(ikey, urlStruction);
                }
            }
            finally {
                this.vtplLock.unlock();
            }
        }
        return urlStruction;
    }

    static class TempateStructionBuiler
    extends VariableHandler.URLStructionBuiler {
        TempateStructionBuiler() {
        }

        public VariableHandler.Variable buildVariable() {
            return new TempateVariable();
        }
    }

    public static class TempateVariable
    extends VariableHandler.Variable {
        protected boolean quoted = true;
        protected String dateFormat;
        protected String locale;
        protected String timeZone;
        private Boolean escape;
        protected DateFormateMeta dateFormateMeta;
        protected String lpad;
        protected String rpad;

        private String handlePad(String pad_) {
            int idx = pad_.indexOf("|");
            String pad = null;
            if (idx > 0) {
                String value = pad_.substring(0, idx);
                int count = Integer.parseInt(pad_.substring(idx + 1));
                pad = value;
                if (count > 0) {
                    for (int j = 1; j < count; ++j) {
                        pad = pad + value;
                    }
                }
            } else {
                pad = pad_;
            }
            return pad;
        }

        public void after() {
            int pos;
            super.after();
            if (this.variableName != null && (pos = this.variableName.indexOf(",")) > 0) {
                String[] ts = this.variableName.split(",");
                this.variableName = ts[0];
                for (int i = 1; i < ts.length; ++i) {
                    String t = ts[i];
                    if (t.startsWith("quoted=")) {
                        String q = t.substring("quoted=".length()).trim();
                        if (!q.equals("false")) continue;
                        this.quoted = false;
                        continue;
                    }
                    if (t.startsWith("dateformat=")) {
                        this.dateFormat = t.substring("dateformat=".length()).trim();
                        continue;
                    }
                    if (t.startsWith("locale=")) {
                        this.locale = t.substring("locale=".length()).trim();
                        continue;
                    }
                    if (t.startsWith("timezone=")) {
                        this.timeZone = t.substring("timezone=".length()).trim();
                        continue;
                    }
                    if (t.startsWith("lpad=")) {
                        String lpad_ = t.substring("lpad=".length()).trim();
                        this.lpad = this.handlePad(lpad_);
                        continue;
                    }
                    if (t.startsWith("rpad=")) {
                        String rpad_ = t.substring("rpad=".length()).trim();
                        this.rpad = this.handlePad(rpad_);
                        continue;
                    }
                    if (!t.startsWith("escape=")) continue;
                    String escape_ = t.substring("escape=".length()).trim();
                    if (escape_.equals("false")) {
                        this.escape = new Boolean(false);
                        continue;
                    }
                    if (!escape_.equals("true")) continue;
                    this.escape = new Boolean(true);
                }
                if (this.dateFormat != null) {
                    this.dateFormateMeta = DateFormateMeta.buildDateFormateMeta((String)this.dateFormat, (String)this.locale);
                }
            }
        }

        public boolean isQuoted() {
            return this.quoted;
        }

        public String getDateFormat() {
            return this.dateFormat;
        }

        public String getLocale() {
            return this.locale;
        }

        public DateFormateMeta getDateFormateMeta() {
            return this.dateFormateMeta;
        }

        public String getTimeZone() {
            return this.timeZone;
        }

        public String getLpad() {
            return this.lpad;
        }

        public String getRpad() {
            return this.rpad;
        }

        public Boolean getEscape() {
            return this.escape;
        }

        public void setEscape(Boolean escape) {
            this.escape = escape;
        }
    }
}

