/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.handler;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.util.EntityUtils;
import org.frameworkset.elasticsearch.ElasticSearchException;
import org.frameworkset.elasticsearch.entity.MGetDocs;
import org.frameworkset.elasticsearch.handler.BaseResponsehandler;
import org.frameworkset.elasticsearch.serial.ESSerialThreadLocal;

public class MGetDocumentsSourceResponseHandler
extends BaseResponsehandler
implements ResponseHandler<MGetDocs> {
    private Class type;

    public MGetDocumentsSourceResponseHandler(Class type) {
        super(type);
    }

    public MGetDocs handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
        int status = response.getStatusLine().getStatusCode();
        if (status >= 200 && status < 300) {
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                try {
                    ESSerialThreadLocal.setESTypeReferences(this.types);
                    MGetDocs mGetDocs = (MGetDocs)super.converJson(entity, MGetDocs.class);
                    return mGetDocs;
                }
                catch (Exception e) {
                    throw new ElasticSearchException(e);
                }
                finally {
                    ESSerialThreadLocal.clean();
                }
            }
            return null;
        }
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            throw new ElasticSearchException(EntityUtils.toString((HttpEntity)entity));
        }
        throw new ElasticSearchException("Unexpected response status: " + status);
    }
}

