/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch;

import com.frameworkset.util.SimpleStringUtil;
import java.util.Date;
import java.util.Properties;
import java.util.TimeZone;
import org.frameworkset.elasticsearch.IndexNameBuilder;
import org.frameworkset.util.FastDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeBasedIndexNameBuilder
implements IndexNameBuilder {
    private static final Logger logger = LoggerFactory.getLogger(TimeBasedIndexNameBuilder.class);
    public static final String DATE_FORMAT = "elasticsearch.dateFormat";
    public static final String TIME_ZONE = "elasticsearch.timeZone";
    public static final String DEFAULT_DATE_FORMAT = "yyyy.MM.dd";
    public static final String DEFAULT_TIME_ZONE = "";
    protected FastDateFormat fastDateFormat = FastDateFormat.getInstance((String)"yyyy.MM.dd", (TimeZone)TimeZone.getTimeZone("Etc/UTC"));
    protected String indexPrefix;

    @Override
    public FastDateFormat getFastDateFormat() {
        return this.fastDateFormat;
    }

    @Override
    public String getIndexName(String index) {
        String indexName = index + '-' + this.fastDateFormat.format(new Date());
        return indexName;
    }

    @Override
    public void configure(Properties elasticsearchPropes) {
        String dateFormatString = elasticsearchPropes.getProperty(DATE_FORMAT);
        String timeZoneString = elasticsearchPropes.getProperty(TIME_ZONE);
        if (SimpleStringUtil.isEmpty((String)dateFormatString)) {
            dateFormatString = DEFAULT_DATE_FORMAT;
        }
        if (SimpleStringUtil.isEmpty((String)timeZoneString)) {
            timeZoneString = DEFAULT_TIME_ZONE;
        }
        this.fastDateFormat = FastDateFormat.getInstance((String)dateFormatString, (TimeZone)TimeZone.getTimeZone(timeZoneString));
        this.indexPrefix = elasticsearchPropes.getProperty("elasticsearch.indexName");
        logger.debug("dateFormatString = " + dateFormatString + ",timeZoneString=" + timeZoneString + ",indexPrefix=" + this.indexPrefix);
    }
}

