/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.frameworkset.elasticsearch.Clock;
import org.frameworkset.elasticsearch.Preconditions;
import org.frameworkset.elasticsearch.SystemClock;
import org.frameworkset.elasticsearch.TimestampRoundDownUtil;

public class BucketPath {
    public static final String TAG_REGEX = "%(\\w|%)|%\\{([\\w\\.-]+)\\}|%\\[(\\w+)\\]";
    public static final Pattern tagPattern = Pattern.compile("%(\\w|%)|%\\{([\\w\\.-]+)\\}|%\\[(\\w+)\\]");
    private static Clock clock = new SystemClock();
    protected static final ThreadLocal<HashMap<String, SimpleDateFormat>> simpleDateFormatCache = new ThreadLocal<HashMap<String, SimpleDateFormat>>(){

        @Override
        protected HashMap<String, SimpleDateFormat> initialValue() {
            return new HashMap<String, SimpleDateFormat>();
        }
    };

    @Deprecated
    public static boolean containsTag(String in) {
        return tagPattern.matcher(in).find();
    }

    @Deprecated
    public static String expandShorthand(char c) {
        switch (c) {
            case 'a': {
                return "weekday_short";
            }
            case 'A': {
                return "weekday_full";
            }
            case 'b': {
                return "monthname_short";
            }
            case 'B': {
                return "monthname_full";
            }
            case 'c': {
                return "datetime";
            }
            case 'd': {
                return "day_of_month_xx";
            }
            case 'e': {
                return "day_of_month_x";
            }
            case 'D': {
                return "date_short";
            }
            case 'H': {
                return "hour_24_xx";
            }
            case 'I': {
                return "hour_12_xx";
            }
            case 'j': {
                return "day_of_year_xxx";
            }
            case 'k': {
                return "hour_24";
            }
            case 'l': {
                return "hour_12";
            }
            case 'm': {
                return "month_xx";
            }
            case 'n': {
                return "month_x";
            }
            case 'M': {
                return "minute_xx";
            }
            case 'p': {
                return "am_pm";
            }
            case 's': {
                return "unix_seconds";
            }
            case 'S': {
                return "seconds_xx";
            }
            case 't': {
                return "unix_millis";
            }
            case 'y': {
                return "year_xx";
            }
            case 'Y': {
                return "year_xxxx";
            }
            case 'z': {
                return "timezone_delta";
            }
        }
        return "" + c;
    }

    @Deprecated
    public static String replaceShorthand(char c, Map<String, String> headers) {
        return BucketPath.replaceShorthand(c, headers, false, 0, 0);
    }

    @Deprecated
    public static String replaceShorthand(char c, Map<String, String> headers, boolean needRounding, int unit, int roundDown) {
        return BucketPath.replaceShorthand(c, headers, null, needRounding, unit, roundDown, false);
    }

    @Deprecated
    public static String replaceShorthand(char c, Map<String, String> headers, TimeZone timeZone, boolean needRounding, int unit, int roundDown, boolean useLocalTimestamp) {
        long ts = 0L;
        if (useLocalTimestamp) {
            ts = clock.currentTimeMillis();
        }
        return BucketPath.replaceShorthand(c, headers, timeZone, needRounding, unit, roundDown, false, ts);
    }

    protected static SimpleDateFormat getSimpleDateFormat(String string) {
        HashMap<String, SimpleDateFormat> localCache = simpleDateFormatCache.get();
        SimpleDateFormat simpleDateFormat = localCache.get(string);
        if (simpleDateFormat == null) {
            simpleDateFormat = new SimpleDateFormat(string);
            localCache.put(string, simpleDateFormat);
            simpleDateFormatCache.set(localCache);
        }
        return simpleDateFormat;
    }

    protected static String replaceStaticString(String key) {
        String replacementString = "";
        try {
            InetAddress addr = InetAddress.getLocalHost();
            switch (key.toLowerCase()) {
                case "localhost": {
                    replacementString = addr.getHostName();
                    break;
                }
                case "ip": {
                    replacementString = addr.getHostAddress();
                    break;
                }
                case "fqdn": {
                    replacementString = addr.getCanonicalHostName();
                    break;
                }
                default: {
                    throw new RuntimeException("The static escape string '" + key + "' was provided but does not match any of (localhost,IP,FQDN)");
                }
            }
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Flume wasn't able to parse the static escape  sequence '" + key + "' due to UnkownHostException.", e);
        }
        return replacementString;
    }

    protected static String replaceShorthand(char c, Map<String, String> headers, TimeZone timeZone, boolean needRounding, int unit, int roundDown, boolean useLocalTimestamp, long ts) {
        String timestampHeader = null;
        try {
            if (!useLocalTimestamp) {
                timestampHeader = headers.get("timestamp");
                Preconditions.checkNotNull(timestampHeader, "Expected timestamp in the Flume event headers, but it was null");
                ts = Long.valueOf(timestampHeader);
            } else {
                timestampHeader = String.valueOf(ts);
            }
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Flume wasn't able to parse timestamp header in the event to resolve time based bucketing. Please check that you're correctly populating timestamp header (for example using TimestampInterceptor source interceptor).", e);
        }
        if (needRounding) {
            ts = BucketPath.roundDown(roundDown, unit, ts, timeZone);
        }
        String formatString = "";
        switch (c) {
            case '%': {
                return "%";
            }
            case 'a': {
                formatString = "EEE";
                break;
            }
            case 'A': {
                formatString = "EEEE";
                break;
            }
            case 'b': {
                formatString = "MMM";
                break;
            }
            case 'B': {
                formatString = "MMMM";
                break;
            }
            case 'c': {
                formatString = "EEE MMM d HH:mm:ss yyyy";
                break;
            }
            case 'd': {
                formatString = "dd";
                break;
            }
            case 'e': {
                formatString = "d";
                break;
            }
            case 'D': {
                formatString = "MM/dd/yy";
                break;
            }
            case 'H': {
                formatString = "HH";
                break;
            }
            case 'I': {
                formatString = "hh";
                break;
            }
            case 'j': {
                formatString = "DDD";
                break;
            }
            case 'k': {
                formatString = "H";
                break;
            }
            case 'l': {
                formatString = "h";
                break;
            }
            case 'm': {
                formatString = "MM";
                break;
            }
            case 'M': {
                formatString = "mm";
                break;
            }
            case 'n': {
                formatString = "M";
                break;
            }
            case 'p': {
                formatString = "a";
                break;
            }
            case 's': {
                return "" + ts / 1000L;
            }
            case 'S': {
                formatString = "ss";
                break;
            }
            case 't': {
                return timestampHeader;
            }
            case 'y': {
                formatString = "yy";
                break;
            }
            case 'Y': {
                formatString = "yyyy";
                break;
            }
            case 'z': {
                formatString = "ZZZ";
                break;
            }
            default: {
                return "";
            }
        }
        SimpleDateFormat format = BucketPath.getSimpleDateFormat(formatString);
        if (timeZone != null) {
            format.setTimeZone(timeZone);
        } else {
            format.setTimeZone(TimeZone.getDefault());
        }
        Date date = new Date(ts);
        return format.format(date);
    }

    private static long roundDown(int roundDown, int unit, long ts, TimeZone timeZone) {
        long timestamp = ts;
        if (roundDown <= 0) {
            roundDown = 1;
        }
        switch (unit) {
            case 13: {
                timestamp = TimestampRoundDownUtil.roundDownTimeStampSeconds(ts, roundDown, timeZone);
                break;
            }
            case 12: {
                timestamp = TimestampRoundDownUtil.roundDownTimeStampMinutes(ts, roundDown, timeZone);
                break;
            }
            case 11: {
                timestamp = TimestampRoundDownUtil.roundDownTimeStampHours(ts, roundDown, timeZone);
                break;
            }
            default: {
                timestamp = ts;
            }
        }
        return timestamp;
    }

    public static String escapeString(String in, Map<String, String> headers) {
        return BucketPath.escapeString(in, headers, false, 0, 0);
    }

    public static String escapeString(String in, Map<String, String> headers, boolean needRounding, int unit, int roundDown) {
        return BucketPath.escapeString(in, headers, null, needRounding, unit, roundDown, false);
    }

    public static String escapeString(String in, Map<String, String> headers, TimeZone timeZone, boolean needRounding, int unit, int roundDown, boolean useLocalTimeStamp) {
        long ts = clock.currentTimeMillis();
        Matcher matcher = tagPattern.matcher(in);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String replacement = "";
            if (matcher.group(2) != null) {
                replacement = headers.get(matcher.group(2));
                if (replacement == null) {
                    replacement = "";
                }
            } else if (matcher.group(3) != null) {
                replacement = BucketPath.replaceStaticString(matcher.group(3));
            } else {
                Preconditions.checkState(matcher.group(1) != null && matcher.group(1).length() == 1, "Expected to match single character tag in string " + in);
                char c = matcher.group(1).charAt(0);
                replacement = BucketPath.replaceShorthand(c, headers, timeZone, needRounding, unit, roundDown, useLocalTimeStamp, ts);
            }
            replacement = replacement.replaceAll("\\\\", "\\\\\\\\");
            replacement = replacement.replaceAll("\\$", "\\\\\\$");
            matcher.appendReplacement(sb, replacement);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    @Deprecated
    public static Map<String, String> getEscapeMapping(String in, Map<String, String> headers) {
        return BucketPath.getEscapeMapping(in, headers, false, 0, 0);
    }

    @Deprecated
    public static Map<String, String> getEscapeMapping(String in, Map<String, String> headers, boolean needRounding, int unit, int roundDown) {
        HashMap<String, String> mapping = new HashMap<String, String>();
        Matcher matcher = tagPattern.matcher(in);
        while (matcher.find()) {
            String replacement = "";
            if (matcher.group(2) != null) {
                replacement = headers.get(matcher.group(2));
                if (replacement == null) {
                    replacement = "";
                }
                mapping.put(matcher.group(2), replacement);
                continue;
            }
            Preconditions.checkState(matcher.group(1) != null && matcher.group(1).length() == 1, "Expected to match single character tag in string " + in);
            char c = matcher.group(1).charAt(0);
            replacement = BucketPath.replaceShorthand(c, headers, needRounding, unit, roundDown);
            mapping.put(BucketPath.expandShorthand(c), replacement);
        }
        return mapping;
    }

    public static void setClock(Clock clk) {
        clock = clk;
    }

    public static Clock getClock() {
        return clock;
    }
}

