/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.shaded.io.grpc.internal;

import com.alibaba.nacos.shaded.com.google.common.base.MoreObjects;
import com.alibaba.nacos.shaded.com.google.common.base.Objects;
import com.alibaba.nacos.shaded.com.google.common.collect.ImmutableSet;
import com.alibaba.nacos.shaded.io.grpc.Status;
import com.alibaba.nacos.shaded.javax.annotation.concurrent.Immutable;
import java.util.Collections;
import java.util.Set;

@Immutable
final class HedgingPolicy {
    final int maxAttempts;
    final long hedgingDelayNanos;
    final Set<Status.Code> nonFatalStatusCodes;
    static final HedgingPolicy DEFAULT = new HedgingPolicy(1, 0L, Collections.emptySet());

    HedgingPolicy(int maxAttempts, long hedgingDelayNanos, Set<Status.Code> nonFatalStatusCodes) {
        this.maxAttempts = maxAttempts;
        this.hedgingDelayNanos = hedgingDelayNanos;
        this.nonFatalStatusCodes = ImmutableSet.copyOf(nonFatalStatusCodes);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        HedgingPolicy that = (HedgingPolicy)other;
        return this.maxAttempts == that.maxAttempts && this.hedgingDelayNanos == that.hedgingDelayNanos && Objects.equal(this.nonFatalStatusCodes, that.nonFatalStatusCodes);
    }

    public int hashCode() {
        return Objects.hashCode(this.maxAttempts, this.hedgingDelayNanos, this.nonFatalStatusCodes);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("maxAttempts", this.maxAttempts).add("hedgingDelayNanos", this.hedgingDelayNanos).add("nonFatalStatusCodes", this.nonFatalStatusCodes).toString();
    }

    static interface Provider {
        public HedgingPolicy get();
    }
}

