/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.sqlline;

import com.alibaba.lindorm.thirdparty.sqlline.OutputFormat;
import com.alibaba.lindorm.thirdparty.sqlline.Rows;
import com.alibaba.lindorm.thirdparty.sqlline.SqlLine;

class SeparatedValuesOutputFormat
implements OutputFormat {
    private final SqlLine sqlLine;
    private char separator;

    public SeparatedValuesOutputFormat(SqlLine sqlLine, char separator) {
        this.sqlLine = sqlLine;
        this.setSeparator(separator);
    }

    @Override
    public int print(Rows rows) {
        int count = 0;
        while (rows.hasNext()) {
            this.printRow(rows, (Rows.Row)rows.next());
            ++count;
        }
        return count - 1;
    }

    public void printRow(Rows rows, Rows.Row row) {
        String[] vals = row.values;
        StringBuilder buf = new StringBuilder();
        for (String val : vals) {
            buf.append(buf.length() == 0 ? "" : "" + this.getSeparator()).append('\'').append(val == null ? "" : val).append('\'');
        }
        this.sqlLine.output(buf.toString());
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    public char getSeparator() {
        return this.separator;
    }
}

