/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.fun;

import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.type.RelDataType;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlCall;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlCallBinding;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlKind;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlOperatorBinding;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlSelect;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlSpecialOperator;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlWriter;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.OperandTypes;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.ReturnTypes;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.SqlTypeUtil;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.validate.SqlValidator;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.validate.SqlValidatorNamespace;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.Static;
import java.util.List;

public class SqlMultisetQueryConstructor
extends SqlSpecialOperator {
    public SqlMultisetQueryConstructor() {
        this("MULTISET", SqlKind.MULTISET_QUERY_CONSTRUCTOR);
    }

    protected SqlMultisetQueryConstructor(String name, SqlKind kind) {
        super(name, kind, 200, false, ReturnTypes.ARG0, null, OperandTypes.VARIADIC);
    }

    @Override
    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        RelDataType type = this.getComponentType(opBinding.getTypeFactory(), opBinding.collectOperandTypes());
        if (null == type) {
            return null;
        }
        return SqlTypeUtil.createMultisetType(opBinding.getTypeFactory(), type, false);
    }

    private RelDataType getComponentType(RelDataTypeFactory typeFactory, List<RelDataType> argTypes) {
        return typeFactory.leastRestrictive(argTypes);
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        List<RelDataType> argTypes = SqlTypeUtil.deriveAndCollectTypes(callBinding.getValidator(), callBinding.getScope(), callBinding.operands());
        RelDataType componentType = this.getComponentType(callBinding.getTypeFactory(), argTypes);
        if (null == componentType) {
            if (throwOnFailure) {
                throw callBinding.newValidationError(Static.RESOURCE.needSameTypeParameter());
            }
            return false;
        }
        return true;
    }

    @Override
    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        SqlSelect subSelect = (SqlSelect)call.operand(0);
        subSelect.validateExpr(validator, scope);
        SqlValidatorNamespace ns = validator.getNamespace(subSelect);
        assert (null != ns.getRowType());
        return SqlTypeUtil.createMultisetType(validator.getTypeFactory(), ns.getRowType(), false);
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        writer.keyword(this.getName());
        SqlWriter.Frame frame = writer.startList("(", ")");
        assert (call.operandCount() == 1);
        ((SqlNode)call.operand(0)).unparse(writer, leftPrec, rightPrec);
        writer.endList(frame);
    }

    @Override
    public boolean argumentMustBeScalar(int ordinal) {
        return false;
    }
}

