/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.fun;

import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.type.RelDataType;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.type.RelDataTypeField;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlCall;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlCallBinding;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlKind;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlOperandCountRange;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlOperatorBinding;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlSpecialOperator;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlUtil;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlWriter;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.parser.SqlParserPos;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.OperandTypes;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.SqlOperandCountRanges;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.SqlTypeFamily;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.SqlTypeName;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.util.SqlBasicVisitor;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.util.SqlVisitor;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.validate.SqlValidator;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.validate.SqlValidatorUtil;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.Static;
import java.util.Arrays;

public class SqlDotOperator
extends SqlSpecialOperator {
    SqlDotOperator() {
        super("DOT", SqlKind.DOT, 100, true, null, null, null);
    }

    @Override
    public SqlSpecialOperator.ReduceResult reduceExpr(int ordinal, SqlSpecialOperator.TokenSequence list) {
        SqlNode left = list.node(ordinal - 1);
        SqlNode right = list.node(ordinal + 1);
        return new SqlSpecialOperator.ReduceResult(this, ordinal - 1, ordinal + 2, this.createCall(SqlParserPos.sum(Arrays.asList(left.getParserPosition(), right.getParserPosition(), list.pos(ordinal))), left, right));
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.IDENTIFIER);
        ((SqlNode)call.operand(0)).unparse(writer, leftPrec, 0);
        writer.sep(".");
        ((SqlNode)call.operand(1)).unparse(writer, 0, 0);
        writer.endList(frame);
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of(2);
    }

    @Override
    public <R> void acceptCall(SqlVisitor<R> visitor, SqlCall call, boolean onlyExpressions, SqlBasicVisitor.ArgHandler<R> argHandler) {
        if (onlyExpressions) {
            argHandler.visitChild(visitor, call, 0, (SqlNode)call.operand(0));
        } else {
            super.acceptCall(visitor, call, onlyExpressions, argHandler);
        }
    }

    @Override
    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        RelDataType nodeType = validator.deriveType(scope, call.getOperandList().get(0));
        assert (nodeType != null);
        String fieldName = call.getOperandList().get(1).toString();
        RelDataTypeField field = nodeType.getField(fieldName, false, false);
        if (field == null) {
            throw SqlUtil.newContextException(SqlParserPos.ZERO, Static.RESOURCE.unknownField(fieldName));
        }
        RelDataType type = field.getType();
        type = this.adjustType(validator, call, type);
        SqlValidatorUtil.checkCharsetAndCollateConsistentIfCharType(type);
        return type;
    }

    @Override
    public void validateCall(SqlCall call, SqlValidator validator, SqlValidatorScope scope, SqlValidatorScope operandScope) {
        assert (call.getOperator() == this);
        call.getOperandList().get(0).validateExpr(validator, operandScope);
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        SqlNode left = callBinding.operand(0);
        SqlNode right = callBinding.operand(1);
        RelDataType type = callBinding.getValidator().deriveType(callBinding.getScope(), left);
        if (type.getSqlTypeName() != SqlTypeName.ROW) {
            return false;
        }
        RelDataType operandType = callBinding.getOperandType(0);
        SqlSingleOperandTypeChecker checker = this.getChecker(operandType);
        return checker.checkSingleOperandType(callBinding, right, 0, throwOnFailure);
    }

    private SqlSingleOperandTypeChecker getChecker(RelDataType operandType) {
        switch (operandType.getSqlTypeName()) {
            case ROW: {
                return OperandTypes.family(SqlTypeFamily.STRING);
            }
        }
        throw new AssertionError((Object)operandType.getSqlTypeName());
    }

    @Override
    public String getAllowedSignatures(String name) {
        return "<A>.<B>";
    }

    @Override
    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        RelDataType recordType = opBinding.getOperandType(0);
        switch (recordType.getSqlTypeName()) {
            case ROW: {
                String fieldName = opBinding.getOperandLiteralValue(1, String.class);
                RelDataType type = opBinding.getOperandType(0).getField(fieldName, false, false).getType();
                if (recordType.isNullable()) {
                    return typeFactory.createTypeWithNullability(type, true);
                }
                return type;
            }
        }
        throw new AssertionError();
    }
}

