/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.ddl;

import com.alibaba.lindorm.thirdparty.com.google.common.base.Preconditions;
import com.alibaba.lindorm.thirdparty.com.google.common.collect.ImmutableCollection;
import com.alibaba.lindorm.thirdparty.com.google.common.collect.ImmutableList;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.jdbc.CalcitePrepare;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.jdbc.CalciteSchema;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j.Enumerator;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j.Linq4j;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j.Ord;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j.QueryProvider;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j.Queryable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j.tree.Expression;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptCluster;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptTable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.prepare.Prepare;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.TableModify;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.logical.LogicalTableModify;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.type.RelDataType;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.type.RelDataTypeField;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.type.RelDataTypeImpl;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.type.RelProtoDataType;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rex.RexNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.ColumnStrategy;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.ModifiableTable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.SchemaPlus;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.Schemas;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.TranslatableTable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.Wrapper;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.impl.AbstractTable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.impl.AbstractTableQueryable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.impl.ViewTable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.impl.ViewTableMacro;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlCreate;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlExecutableStatement;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlIdentifier;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlKind;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlNodeList;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlOperator;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlSpecialOperator;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlUtil;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlWriter;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.ddl.SqlColumnDeclaration;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.ddl.SqlDdlNodes;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.dialect.CalciteSqlDialect;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.parser.SqlParserPos;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql2rel.InitializerContext;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql2rel.InitializerExpressionFactory;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql2rel.NullInitializerExpressionFactory;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.ImmutableNullableList;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.Pair;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.Static;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SqlCreateTable
extends SqlCreate
implements SqlExecutableStatement {
    private final SqlIdentifier name;
    private final SqlNodeList columnList;
    private final SqlNode query;
    private final List<Pair<String, String>> tableAttrsList;
    private final boolean isPipe;
    private static final SqlOperator OPERATOR = new SqlSpecialOperator("CREATE TABLE", SqlKind.CREATE_TABLE);

    SqlCreateTable(SqlParserPos pos, boolean replace, boolean isPipe, boolean ifNotExists, SqlIdentifier name, SqlNodeList columnList, SqlNode query, List<Pair<String, String>> tableAttrsList) {
        super(OPERATOR, pos, replace, ifNotExists);
        this.isPipe = isPipe;
        this.name = Preconditions.checkNotNull(name);
        this.columnList = columnList;
        this.query = query;
        this.tableAttrsList = tableAttrsList;
    }

    public String getTableName() {
        return this.name.toString();
    }

    public boolean getIsPipe() {
        return this.isPipe;
    }

    public boolean getIfNotExists() {
        return this.ifNotExists;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.name, this.columnList, this.query);
    }

    public List<Pair<String, String>> getTableAttrsList() {
        return this.tableAttrsList;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("CREATE");
        writer.keyword("TABLE");
        if (this.ifNotExists) {
            writer.keyword("IF NOT EXISTS");
        }
        this.name.unparse(writer, leftPrec, rightPrec);
        if (this.columnList != null) {
            SqlWriter.Frame frame = writer.startList("(", ")");
            for (SqlNode c : this.columnList) {
                writer.sep(",");
                c.unparse(writer, 0, 0);
            }
            writer.endList(frame);
        }
        if (this.query != null) {
            writer.keyword("AS");
            writer.newlineAndIndent();
            this.query.unparse(writer, 0, 0);
        }
        if (this.tableAttrsList != null) {
            for (int i = 0; i < this.tableAttrsList.size(); ++i) {
                Pair<String, String> p = this.tableAttrsList.get(i);
                writer.print(p.getKey() + "=" + p.getValue());
                if (i == this.tableAttrsList.size() - 1) continue;
                writer.print(", ");
            }
        }
    }

    @Override
    public void execute(CalcitePrepare.Context context) {
        List<SqlNode> columnList;
        RelDataType queryRowType;
        Pair<CalciteSchema, String> pair = SqlDdlNodes.schema(context, true, this.name);
        JavaTypeFactoryImpl typeFactory = new JavaTypeFactoryImpl();
        if (this.query != null) {
            String sql = this.query.toSqlString(CalciteSqlDialect.DEFAULT).getSql();
            ViewTableMacro viewTableMacro = ViewTable.viewMacro(((CalciteSchema)pair.left).plus(), sql, ((CalciteSchema)pair.left).path(null), context.getObjectPath(), false);
            TranslatableTable x = viewTableMacro.apply(ImmutableList.of());
            queryRowType = x.getRowType(typeFactory);
            if (this.columnList != null && queryRowType.getFieldCount() != this.columnList.size()) {
                throw SqlUtil.newContextException(this.columnList.getParserPosition(), Static.RESOURCE.columnCountMismatch());
            }
        } else {
            queryRowType = null;
        }
        if (this.columnList != null) {
            columnList = this.columnList.getList();
        } else {
            if (queryRowType == null) {
                throw SqlUtil.newContextException(this.name.getParserPosition(), Static.RESOURCE.createTableRequiresColumnList());
            }
            columnList = new ArrayList<SqlNode>();
            for (String name : queryRowType.getFieldNames()) {
                columnList.add(new SqlIdentifier(name, SqlParserPos.ZERO));
            }
        }
        ImmutableList.Builder b = ImmutableList.builder();
        RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
        RelDataTypeFactory.FieldInfoBuilder storedBuilder = typeFactory.builder();
        for (Ord<SqlNode> c : Ord.zip(columnList)) {
            if (c.e instanceof SqlColumnDeclaration) {
                SqlColumnDeclaration d = (SqlColumnDeclaration)c.e;
                RelDataType type = d.dataType.deriveType(typeFactory, true);
                ((RelDataTypeFactory.Builder)builder).add(d.name.getSimple(), type);
                if (d.strategy != ColumnStrategy.VIRTUAL) {
                    ((RelDataTypeFactory.Builder)storedBuilder).add(d.name.getSimple(), type);
                }
                b.add(ColumnDef.of(d.expression, type, d.strategy));
                continue;
            }
            if (c.e instanceof SqlIdentifier) {
                SqlIdentifier id = (SqlIdentifier)c.e;
                if (queryRowType == null) {
                    throw SqlUtil.newContextException(id.getParserPosition(), Static.RESOURCE.createTableRequiresColumnTypes(id.getSimple()));
                }
                RelDataTypeField f = queryRowType.getFieldList().get(c.i);
                ColumnStrategy strategy = f.getType().isNullable() ? ColumnStrategy.NULLABLE : ColumnStrategy.NOT_NULLABLE;
                b.add(ColumnDef.of((SqlNode)c.e, f.getType(), strategy));
                ((RelDataTypeFactory.Builder)builder).add(id.getSimple(), f.getType());
                ((RelDataTypeFactory.Builder)storedBuilder).add(id.getSimple(), f.getType());
                continue;
            }
            throw new AssertionError(((SqlNode)c.e).getClass());
        }
        RelDataType rowType = builder.build();
        RelDataType storedRowType = storedBuilder.build();
        ImmutableCollection columns = b.build();
        NullInitializerExpressionFactory ief = new NullInitializerExpressionFactory((List)((Object)columns)){
            final /* synthetic */ List val$columns;
            {
                this.val$columns = list;
            }

            @Override
            public ColumnStrategy generationStrategy(RelOptTable table, int iColumn) {
                return ((ColumnDef)this.val$columns.get((int)iColumn)).strategy;
            }

            @Override
            public RexNode newColumnDefaultValue(RelOptTable table, int iColumn, InitializerContext context) {
                ColumnDef c = (ColumnDef)this.val$columns.get(iColumn);
                if (c.expr != null) {
                    return context.convertExpression(c.expr);
                }
                return super.newColumnDefaultValue(table, iColumn, context);
            }
        };
        if (((CalciteSchema)pair.left).plus().getTable((String)pair.right) != null) {
            if (!this.ifNotExists) {
                throw SqlUtil.newContextException(this.name.getParserPosition(), Static.RESOURCE.tableExists((String)pair.right));
            }
            return;
        }
        ((CalciteSchema)pair.left).add((String)pair.right, new MutableArrayTable((String)pair.right, RelDataTypeImpl.proto(storedRowType), RelDataTypeImpl.proto(rowType), ief));
        if (this.query != null) {
            SqlDdlNodes.populate(this.name, this.query, context);
        }
    }

    static class MutableArrayTable
    extends AbstractModifiableTable
    implements Wrapper {
        final List rows = new ArrayList();
        private final RelProtoDataType protoStoredRowType;
        private final RelProtoDataType protoRowType;
        private final InitializerExpressionFactory initializerExpressionFactory;

        MutableArrayTable(String name, RelProtoDataType protoStoredRowType, RelProtoDataType protoRowType, InitializerExpressionFactory initializerExpressionFactory) {
            super(name);
            this.protoStoredRowType = Preconditions.checkNotNull(protoStoredRowType);
            this.protoRowType = Preconditions.checkNotNull(protoRowType);
            this.initializerExpressionFactory = Preconditions.checkNotNull(initializerExpressionFactory);
        }

        @Override
        public Collection getModifiableCollection() {
            return this.rows;
        }

        @Override
        public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
            return new AbstractTableQueryable<T>(queryProvider, schema, this, tableName){

                @Override
                public Enumerator<T> enumerator() {
                    return Linq4j.enumerator(MutableArrayTable.this.rows);
                }
            };
        }

        @Override
        public Type getElementType() {
            return Object[].class;
        }

        @Override
        public Expression getExpression(SchemaPlus schema, String tableName, Class clazz) {
            return Schemas.tableExpression(schema, this.getElementType(), tableName, clazz);
        }

        @Override
        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return (RelDataType)this.protoRowType.apply(typeFactory);
        }

        @Override
        public <C> C unwrap(Class<C> aClass) {
            if (aClass.isInstance(this.initializerExpressionFactory)) {
                return aClass.cast(this.initializerExpressionFactory);
            }
            return super.unwrap(aClass);
        }
    }

    static abstract class AbstractModifiableTable
    extends AbstractTable
    implements ModifiableTable {
        AbstractModifiableTable(String tableName) {
        }

        @Override
        public TableModify toModificationRel(RelOptCluster cluster, RelOptTable table, Prepare.CatalogReader catalogReader, RelNode child, TableModify.Operation operation, List<String> updateColumnList, List<RexNode> sourceExpressionList, boolean flattened) {
            return LogicalTableModify.create(table, catalogReader, child, operation, updateColumnList, sourceExpressionList, flattened);
        }
    }

    private static class ColumnDef {
        final SqlNode expr;
        final RelDataType type;
        final ColumnStrategy strategy;

        private ColumnDef(SqlNode expr, RelDataType type, ColumnStrategy strategy) {
            this.expr = expr;
            this.type = type;
            this.strategy = Preconditions.checkNotNull(strategy);
            Preconditions.checkArgument(strategy == ColumnStrategy.NULLABLE || strategy == ColumnStrategy.NOT_NULLABLE || expr != null);
        }

        static ColumnDef of(SqlNode expr, RelDataType type, ColumnStrategy strategy) {
            return new ColumnDef(expr, type, strategy);
        }
    }
}

