/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core;

import com.alibaba.lindorm.thirdparty.com.google.common.collect.ImmutableList;
import com.alibaba.lindorm.thirdparty.com.google.common.collect.ImmutableSet;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.Convention;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptCluster;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptCost;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptPlanner;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelTrait;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelTraitSet;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.EquiJoin;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.JoinInfo;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.JoinRelType;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.metadata.RelMdUtil;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.type.RelDataType;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rex.RexNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.validate.SqlValidatorUtil;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.ImmutableIntList;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.Util;

public class SemiJoin
extends EquiJoin {
    public SemiJoin(RelOptCluster cluster, RelTraitSet traitSet, RelNode left, RelNode right, RexNode condition, ImmutableIntList leftKeys, ImmutableIntList rightKeys) {
        super(cluster, traitSet, left, right, condition, leftKeys, rightKeys, ImmutableSet.of(), JoinRelType.INNER);
    }

    public static SemiJoin create(RelNode left, RelNode right, RexNode condition, ImmutableIntList leftKeys, ImmutableIntList rightKeys) {
        RelOptCluster cluster = left.getCluster();
        return new SemiJoin(cluster, cluster.traitSetOf((RelTrait)Convention.NONE), left, right, condition, leftKeys, rightKeys);
    }

    @Override
    public SemiJoin copy(RelTraitSet traitSet, RexNode condition, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        assert (joinType == JoinRelType.INNER);
        JoinInfo joinInfo = JoinInfo.of(left, right, condition);
        assert (joinInfo.isEqui());
        return new SemiJoin(this.getCluster(), traitSet, left, right, condition, joinInfo.leftKeys, joinInfo.rightKeys);
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return planner.getCostFactory().makeTinyCost();
    }

    @Override
    public double estimateRowCount(RelMetadataQuery mq) {
        return Util.first(RelMdUtil.getSemiJoinRowCount(mq, this.left, this.right, this.joinType, this.condition), 1.0);
    }

    @Override
    public RelDataType deriveRowType() {
        return SqlValidatorUtil.deriveJoinRowType(this.left.getRowType(), null, JoinRelType.INNER, this.getCluster().getTypeFactory(), null, ImmutableList.of());
    }
}

