/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.enumerable;

import com.alibaba.lindorm.thirdparty.com.google.common.collect.ImmutableList;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.enumerable.EnumUtils;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.enumerable.EnumerableConvention;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.enumerable.EnumerableRel;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.enumerable.JavaRowFormat;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.enumerable.PhysType;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j.tree.BlockBuilder;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j.tree.Expression;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j.tree.Expressions;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptCluster;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptCost;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptPlanner;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelTrait;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelTraitSet;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.InvalidRelException;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelNodes;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.CorrelationId;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.EquiJoin;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.JoinInfo;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.JoinRelType;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rex.RexNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.BuiltInMethod;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.ImmutableIntList;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.Util;
import java.util.Set;

public class EnumerableJoin
extends EquiJoin
implements EnumerableRel {
    protected EnumerableJoin(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, RexNode condition, ImmutableIntList leftKeys, ImmutableIntList rightKeys, Set<CorrelationId> variablesSet, JoinRelType joinType) throws InvalidRelException {
        super(cluster, traits, left, right, condition, leftKeys, rightKeys, variablesSet, joinType);
    }

    @Deprecated
    protected EnumerableJoin(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, RexNode condition, ImmutableIntList leftKeys, ImmutableIntList rightKeys, JoinRelType joinType, Set<String> variablesStopped) throws InvalidRelException {
        this(cluster, traits, left, right, condition, leftKeys, rightKeys, CorrelationId.setOf(variablesStopped), joinType);
    }

    public static EnumerableJoin create(RelNode left, RelNode right, RexNode condition, ImmutableIntList leftKeys, ImmutableIntList rightKeys, Set<CorrelationId> variablesSet, JoinRelType joinType) throws InvalidRelException {
        RelOptCluster cluster = left.getCluster();
        RelTraitSet traitSet = cluster.traitSetOf((RelTrait)EnumerableConvention.INSTANCE);
        return new EnumerableJoin(cluster, traitSet, left, right, condition, leftKeys, rightKeys, variablesSet, joinType);
    }

    @Deprecated
    public static EnumerableJoin create(RelNode left, RelNode right, RexNode condition, ImmutableIntList leftKeys, ImmutableIntList rightKeys, JoinRelType joinType, Set<String> variablesStopped) throws InvalidRelException {
        return EnumerableJoin.create(left, right, condition, leftKeys, rightKeys, CorrelationId.setOf(variablesStopped), joinType);
    }

    @Override
    public EnumerableJoin copy(RelTraitSet traitSet, RexNode condition, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        JoinInfo joinInfo = JoinInfo.of(left, right, condition);
        assert (joinInfo.isEqui());
        try {
            return new EnumerableJoin(this.getCluster(), traitSet, left, right, condition, joinInfo.leftKeys, joinInfo.rightKeys, this.variablesSet, joinType);
        }
        catch (InvalidRelException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double rowCount = mq.getRowCount(this);
        switch (this.joinType) {
            case RIGHT: {
                rowCount = this.addEpsilon(rowCount);
                break;
            }
            default: {
                if (RelNodes.COMPARATOR.compare(this.left, this.right) <= 0) break;
                rowCount = this.addEpsilon(rowCount);
            }
        }
        double rightRowCount = this.right.estimateRowCount(mq);
        double leftRowCount = this.left.estimateRowCount(mq);
        rowCount = Double.isInfinite(leftRowCount) ? leftRowCount : (rowCount += Util.nLogN(leftRowCount));
        rowCount = Double.isInfinite(rightRowCount) ? rightRowCount : (rowCount += rightRowCount);
        return planner.getCostFactory().makeCost(rowCount, 0.0, 0.0);
    }

    private double addEpsilon(double d) {
        assert (d >= 0.0);
        double d0 = d;
        if (d < 10.0 && (d *= 1.001) != d0) {
            return d;
        }
        if ((d += 1.0) != d0) {
            return d;
        }
        return d *= 1.001;
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        BlockBuilder builder = new BlockBuilder();
        EnumerableRel.Result leftResult = implementor.visitChild(this, 0, (EnumerableRel)this.left, pref);
        Expression leftExpression = builder.append("left", leftResult.block);
        EnumerableRel.Result rightResult = implementor.visitChild(this, 1, (EnumerableRel)this.right, pref);
        Expression rightExpression = builder.append("right", rightResult.block);
        PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), pref.preferArray());
        PhysType keyPhysType = leftResult.physType.project(this.leftKeys, JavaRowFormat.LIST);
        return implementor.result(physType, builder.append(Expressions.call(leftExpression, BuiltInMethod.JOIN.method, Expressions.list(rightExpression, leftResult.physType.generateAccessor(this.leftKeys), rightResult.physType.generateAccessor(this.rightKeys), EnumUtils.joinSelector(this.joinType, physType, ImmutableList.of(leftResult.physType, rightResult.physType))).append(Util.first(keyPhysType.comparer(), Expressions.constant(null))).append(Expressions.constant(this.joinType.generatesNullsOnLeft())).append(Expressions.constant(this.joinType.generatesNullsOnRight())))).toBlock());
    }
}

