/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.com.yahoo.sketches.theta;

import com.alibaba.lindorm.thirdparty.com.yahoo.memory.Memory;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.Util;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.theta.CompactSketch;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.theta.PreambleUtil;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.theta.UpdateSketch;

final class DirectCompactSketch
extends CompactSketch {
    private Memory mem_;
    private int preLongs_;

    private DirectCompactSketch(boolean empty, short seedHash, int curCount, long thetaLong) {
        super(empty, seedHash, curCount, thetaLong);
    }

    static DirectCompactSketch wrapInstance(Memory srcMem, long pre0, long seed) {
        long thetaLong;
        int curCount;
        short memSeedHash;
        int flags;
        int preLongs;
        if (srcMem.isReadOnly() && !srcMem.isDirect()) {
            preLongs = srcMem.getByte(0L) & 0x3F;
            flags = srcMem.getByte(5L) & 0xFF;
            memSeedHash = srcMem.getShort(6L);
            curCount = preLongs > 1 ? srcMem.getInt(8L) : 0;
            thetaLong = preLongs > 2 ? srcMem.getLong(16L) : Long.MAX_VALUE;
        } else {
            Object memObj = srcMem.array();
            long memAdd = srcMem.getCumulativeOffset(0L);
            preLongs = PreambleUtil.extractPreLongs(memObj, memAdd);
            flags = PreambleUtil.extractFlags(memObj, memAdd);
            memSeedHash = (short)PreambleUtil.extractSeedHash(memObj, memAdd);
            curCount = preLongs > 1 ? PreambleUtil.extractCurCount(memObj, memAdd) : 0;
            thetaLong = preLongs > 2 ? PreambleUtil.extractThetaLong(memObj, memAdd) : Long.MAX_VALUE;
        }
        short computedSeedHash = Util.computeSeedHash(seed);
        Util.checkSeedHashes(memSeedHash, computedSeedHash);
        boolean empty = (flags & 4) > 0;
        DirectCompactSketch dcs = new DirectCompactSketch(empty, memSeedHash, curCount, thetaLong);
        dcs.preLongs_ = preLongs;
        dcs.mem_ = srcMem;
        return dcs;
    }

    DirectCompactSketch(UpdateSketch sketch, Memory dstMem) {
        super(sketch.isEmpty(), sketch.getSeedHash(), sketch.getRetainedEntries(true), sketch.getThetaLong());
        int emptyBit = this.isEmpty() ? 4 : 0;
        byte flags = (byte)(emptyBit | 2 | 8);
        boolean ordered = false;
        long[] compactCache = CompactSketch.compactCache(sketch.getCache(), this.getRetainedEntries(false), this.getThetaLong(), false);
        this.mem_ = DirectCompactSketch.loadCompactMemory(compactCache, this.isEmpty(), this.getSeedHash(), this.getRetainedEntries(false), this.getThetaLong(), dstMem, flags);
        this.preLongs_ = this.mem_.getByte(0L) & 0x3F;
    }

    DirectCompactSketch(long[] compactCache, boolean empty, short seedHash, int curCount, long thetaLong, Memory dstMem) {
        super(empty, seedHash, curCount, thetaLong);
        int emptyBit = empty ? 4 : 0;
        byte flags = (byte)(emptyBit | 2 | 8);
        this.mem_ = DirectCompactSketch.loadCompactMemory(compactCache, empty, seedHash, curCount, thetaLong, dstMem, flags);
    }

    @Override
    public byte[] toByteArray() {
        return DirectCompactSketch.compactMemoryToByteArray(this.mem_, this.getRetainedEntries(false));
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    long[] getCache() {
        long[] cache = new long[this.getRetainedEntries(false)];
        this.mem_.getLongArray(this.preLongs_ << 3, cache, 0, this.getRetainedEntries(false));
        return cache;
    }

    @Override
    Memory getMemory() {
        return this.mem_;
    }

    @Override
    public boolean isOrdered() {
        return false;
    }

    static byte[] compactMemoryToByteArray(Memory srcMem, int curCount) {
        int preLongs = srcMem.getByte(0L) & 0x3F;
        int outBytes = (curCount << 3) + (preLongs << 3);
        byte[] byteArrOut = new byte[outBytes];
        srcMem.getByteArray(0L, byteArrOut, 0, outBytes);
        return byteArrOut;
    }
}

