/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.com.esri.core.geometry;

import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.AttributeStreamOfInt32;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.CrackAndCluster;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.EditShape;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.Envelope;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.Envelope2D;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.Geometry;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.GeometryException;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.InternalUtils;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.MultiPath;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.MultiPathImpl;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.MultiPoint;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.MultiVertexGeometry;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.MultiVertexGeometryImpl;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.PlaneSweepCrackerHelper;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.Point;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.Point2D;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.Polygon;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.PolygonUtils;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.Polyline;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.ProgressTracker;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.Segment;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.Simplificator;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.SpatialReference;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.TopoGraph;
import java.util.ArrayList;

final class TopologicalOperations {
    TopoGraph m_topo_graph = null;
    Point2D m_dummy_pt_1 = new Point2D();
    Point2D m_dummy_pt_2 = new Point2D();
    int m_from_edge_for_polylines = -1;
    boolean[] m_mask_lookup = null;
    boolean m_bOGCOutput = false;

    boolean isGoodParentage(int parentage) {
        return parentage < this.m_mask_lookup.length ? this.m_mask_lookup[parentage] : false;
    }

    void cut(int sideIndex, int cuttee, int cutter, AttributeStreamOfInt32 cutHandles) {
        int gtCuttee = this.m_topo_graph.getShape().getGeometryType(cuttee);
        int gtCutter = this.m_topo_graph.getShape().getGeometryType(cutter);
        int dimCuttee = Geometry.getDimensionFromType(gtCuttee);
        int dimCutter = Geometry.getDimensionFromType(gtCutter);
        if (dimCuttee == 2 && dimCutter == 1) {
            this.cutPolygonPolyline_(sideIndex, cuttee, cutter, cutHandles);
            return;
        }
        throw GeometryException.GeometryInternalError();
    }

    void setEditShape(EditShape shape, ProgressTracker progressTracker) {
        if (this.m_topo_graph == null) {
            this.m_topo_graph = new TopoGraph();
        }
        this.m_topo_graph.setEditShape(shape, progressTracker);
    }

    void setEditShapeCrackAndCluster(EditShape shape, double tolerance, ProgressTracker progressTracker) {
        CrackAndCluster.execute(shape, tolerance, progressTracker, true);
        int geometry = shape.getFirstGeometry();
        while (geometry != -1) {
            if (shape.getGeometryType(geometry) == Geometry.Type.Polygon.value()) {
                Simplificator.execute(shape, geometry, -1, this.m_bOGCOutput, progressTracker);
            }
            geometry = shape.getNextGeometry(geometry);
        }
        this.setEditShape(shape, progressTracker);
    }

    private void collectPolygonPathsPreservingFrom_(int geometryFrom, int newGeometry, int visitedEdges, int visitedClusters, int geometry_dominant) {
        EditShape shape = this.m_topo_graph.getShape();
        if (shape.getGeometryType(geometryFrom) != Geometry.Type.Polygon.value()) {
            return;
        }
        int path = shape.getFirstPath(geometryFrom);
        while (path != -1) {
            int first_vertex = shape.getFirstVertex(path);
            int firstCluster = this.m_topo_graph.getClusterFromVertex(first_vertex);
            assert (firstCluster != -1);
            int secondVertex = shape.getNextVertex(first_vertex);
            int secondCluster = this.m_topo_graph.getClusterFromVertex(secondVertex);
            assert (secondCluster != -1);
            int firstHalfEdge = this.m_topo_graph.getHalfEdgeFromVertex(first_vertex);
            if (firstHalfEdge != -1) {
                assert (this.m_topo_graph.getHalfEdgeTo(firstHalfEdge) == secondCluster && this.m_topo_graph.getHalfEdgeOrigin(firstHalfEdge) == firstCluster);
                int visited = this.m_topo_graph.getHalfEdgeUserIndex(firstHalfEdge, visitedEdges);
                if (visited != 1 && visited != 2) {
                    int parentage = this.m_topo_graph.getHalfEdgeFaceParentage(firstHalfEdge);
                    if (!this.isGoodParentage(parentage)) {
                        this.m_topo_graph.setHalfEdgeUserIndex(firstHalfEdge, visitedEdges, 2);
                    } else {
                        this.m_topo_graph.setHalfEdgeUserIndex(firstHalfEdge, visitedEdges, 1);
                        int newPath = shape.insertPath(newGeometry, -1);
                        int half_edge = firstHalfEdge;
                        int vertex = first_vertex;
                        int cluster = this.m_topo_graph.getClusterFromVertex(vertex);
                        int dir = 1;
                        do {
                            int v;
                            int cv;
                            int vertex_dominant = this.getVertexByID_(vertex, geometry_dominant);
                            shape.addVertex(newPath, vertex_dominant);
                            if (visitedClusters != -1) {
                                this.m_topo_graph.setClusterUserIndex(cluster, visitedClusters, 1);
                            }
                            this.m_topo_graph.setHalfEdgeUserIndex(half_edge, visitedEdges, 1);
                            half_edge = this.m_topo_graph.getHalfEdgeNext(half_edge);
                            while ((cv = (v = dir == 1 ? shape.getNextVertex(vertex) : shape.getPrevVertex(vertex)) != -1 ? this.m_topo_graph.getClusterFromVertex(v) : -1) == cluster) {
                            }
                            int originCluster = this.m_topo_graph.getHalfEdgeOrigin(half_edge);
                            if (originCluster != cv) {
                                while ((cv = (v = dir == 1 ? shape.getPrevVertex(vertex) : shape.getNextVertex(vertex)) != -1 ? this.m_topo_graph.getClusterFromVertex(v) : -1) == cluster) {
                                }
                                if (originCluster != cv) {
                                    cv = originCluster;
                                    int iterator = this.m_topo_graph.getClusterVertexIterator(cv);
                                    v = this.m_topo_graph.getVertexFromVertexIterator(iterator);
                                } else {
                                    dir = -dir;
                                }
                            }
                            cluster = cv;
                            vertex = v;
                        } while (half_edge != firstHalfEdge);
                        shape.setClosedPath(newPath, true);
                    }
                }
            }
            path = shape.getNextPath(path);
        }
    }

    void dissolveCommonEdges_() {
        int visitedEdges = this.m_topo_graph.createUserIndexForHalfEdges();
        AttributeStreamOfInt32 edgesToDelete = new AttributeStreamOfInt32(0);
        int cluster = this.m_topo_graph.getFirstCluster();
        while (cluster != -1) {
            int firstHalfEdge;
            int half_edge = firstHalfEdge = this.m_topo_graph.getClusterHalfEdge(cluster);
            if (firstHalfEdge != -1) {
                do {
                    int twinParentage;
                    int visited;
                    if ((visited = this.m_topo_graph.getHalfEdgeUserIndex(half_edge, visitedEdges)) == 1) continue;
                    int halfEdgeTwin = this.m_topo_graph.getHalfEdgeTwin(half_edge);
                    this.m_topo_graph.setHalfEdgeUserIndex(halfEdgeTwin, visitedEdges, 1);
                    this.m_topo_graph.setHalfEdgeUserIndex(half_edge, visitedEdges, 1);
                    int parentage = this.m_topo_graph.getHalfEdgeFaceParentage(half_edge);
                    if (!this.isGoodParentage(parentage) || !this.isGoodParentage(twinParentage = this.m_topo_graph.getHalfEdgeFaceParentage(halfEdgeTwin))) continue;
                    edgesToDelete.add(half_edge);
                } while ((half_edge = this.m_topo_graph.getHalfEdgeNext(this.m_topo_graph.getHalfEdgeTwin(half_edge))) != firstHalfEdge);
            }
            cluster = this.m_topo_graph.getNextCluster(cluster);
        }
        this.m_topo_graph.deleteUserIndexForHalfEdges(visitedEdges);
        this.m_topo_graph.deleteEdgesBreakFaces_(edgesToDelete);
    }

    int getVertexByID_(int vertex, int geometry_id) {
        if (geometry_id == -1) {
            return vertex;
        }
        return this.getVertexByIDImpl_(vertex, geometry_id);
    }

    int getVertexByIDImpl_(int vertex, int geometry_id) {
        EditShape shape = this.m_topo_graph.getShape();
        int vertex_iterator = this.m_topo_graph.getClusterVertexIterator(this.m_topo_graph.getClusterFromVertex(vertex));
        do {
            int v;
            int geometry;
            if ((geometry = shape.getGeometryFromPath(shape.getPathFromVertex(v = this.m_topo_graph.getVertexFromVertexIterator(vertex_iterator)))) != geometry_id) continue;
            return v;
        } while ((vertex_iterator = this.m_topo_graph.incrementVertexIterator(vertex_iterator)) != -1);
        return vertex;
    }

    private int topoOperationPolygonPolygon_(int geometry_a, int geometry_b, int geometry_dominant) {
        this.dissolveCommonEdges_();
        EditShape shape = this.m_topo_graph.getShape();
        int newGeometry = shape.createGeometry(Geometry.Type.Polygon);
        int visitedEdges = this.m_topo_graph.createUserIndexForHalfEdges();
        this.topoOperationPolygonPolygonHelper_(geometry_a, geometry_b, newGeometry, geometry_dominant, visitedEdges, -1);
        this.m_topo_graph.deleteUserIndexForHalfEdges(visitedEdges);
        Simplificator.execute(shape, newGeometry, 1, this.m_bOGCOutput, null);
        return newGeometry;
    }

    private void topoOperationPolygonPolygonHelper_(int geometry_a, int geometry_b, int newGeometryPolygon, int geometry_dominant, int visitedEdges, int visitedClusters) {
        this.collectPolygonPathsPreservingFrom_(geometry_a, newGeometryPolygon, visitedEdges, visitedClusters, geometry_dominant);
        if (geometry_b != -1) {
            this.collectPolygonPathsPreservingFrom_(geometry_b, newGeometryPolygon, visitedEdges, visitedClusters, geometry_dominant);
        }
        EditShape shape = this.m_topo_graph.getShape();
        int cluster = this.m_topo_graph.getFirstCluster();
        while (cluster != -1) {
            int firstHalfEdge = this.m_topo_graph.getClusterHalfEdge(cluster);
            if (firstHalfEdge != -1) {
                int half_edge = firstHalfEdge;
                do {
                    int visited;
                    if ((visited = this.m_topo_graph.getHalfEdgeUserIndex(half_edge, visitedEdges)) == 1 || visited == 2) continue;
                    int parentage = this.m_topo_graph.getHalfEdgeFaceParentage(half_edge);
                    if (this.isGoodParentage(parentage)) {
                        int newPath = shape.insertPath(newGeometryPolygon, -1);
                        int faceHalfEdge = half_edge;
                        do {
                            int v;
                            int viter;
                            if ((viter = this.m_topo_graph.getHalfEdgeVertexIterator(faceHalfEdge)) != -1) {
                                v = this.m_topo_graph.getVertexFromVertexIterator(viter);
                            } else {
                                int viter1 = this.m_topo_graph.getHalfEdgeVertexIterator(this.m_topo_graph.getHalfEdgeTwin(faceHalfEdge));
                                assert (viter1 != -1);
                                v = this.m_topo_graph.getVertexFromVertexIterator(viter1);
                                v = this.m_topo_graph.getShape().getNextVertex(v);
                            }
                            assert (v != -1);
                            int vertex_dominant = this.getVertexByID_(v, geometry_dominant);
                            shape.addVertex(newPath, vertex_dominant);
                            assert (this.isGoodParentage(this.m_topo_graph.getHalfEdgeFaceParentage(faceHalfEdge)));
                            this.m_topo_graph.setHalfEdgeUserIndex(faceHalfEdge, visitedEdges, 1);
                            if (visitedClusters == -1) continue;
                            int c = this.m_topo_graph.getClusterFromVertex(vertex_dominant);
                            this.m_topo_graph.setClusterUserIndex(c, visitedClusters, 1);
                        } while ((faceHalfEdge = this.m_topo_graph.getHalfEdgeNext(faceHalfEdge)) != half_edge);
                        shape.setClosedPath(newPath, true);
                        continue;
                    }
                    this.m_topo_graph.setHalfEdgeUserIndex(half_edge, visitedEdges, 2);
                } while ((half_edge = this.m_topo_graph.getHalfEdgeNext(this.m_topo_graph.getHalfEdgeTwin(half_edge))) != firstHalfEdge);
            }
            cluster = this.m_topo_graph.getNextCluster(cluster);
        }
    }

    int[] topoOperationPolygonPolygonEx_(int geometry_a, int geometry_b, int geometry_dominant) {
        EditShape shape = this.m_topo_graph.getShape();
        int newGeometryPolygon = shape.createGeometry(Geometry.Type.Polygon);
        int newGeometryPolyline = shape.createGeometry(Geometry.Type.Polyline);
        int newGeometryMultipoint = shape.createGeometry(Geometry.Type.MultiPoint);
        this.dissolveCommonEdges_();
        int multipointPath = -1;
        int visitedEdges = this.m_topo_graph.createUserIndexForHalfEdges();
        int visitedClusters = this.m_topo_graph.createUserIndexForClusters();
        this.topoOperationPolygonPolygonHelper_(geometry_a, geometry_b, newGeometryPolygon, geometry_dominant, visitedEdges, visitedClusters);
        int cluster = this.m_topo_graph.getFirstCluster();
        while (cluster != -1) {
            int firstHalfEdge = this.m_topo_graph.getClusterHalfEdge(cluster);
            if (firstHalfEdge != -1) {
                int half_edge = firstHalfEdge;
                block1: do {
                    int visited2;
                    int visited1;
                    int visited;
                    if ((visited = (visited1 = this.m_topo_graph.getHalfEdgeUserIndex(half_edge, visitedEdges)) | (visited2 = this.m_topo_graph.getHalfEdgeUserIndex(this.m_topo_graph.getHalfEdgeTwin(half_edge), visitedEdges))) != 2) continue;
                    int parentage = this.m_topo_graph.getHalfEdgeParentage(half_edge);
                    if (this.isGoodParentage(parentage)) {
                        int newPath = shape.insertPath(newGeometryPolyline, -1);
                        int polyHalfEdge = half_edge;
                        int vert = this.selectVertex_(cluster, shape);
                        assert (vert != -1);
                        int vertex_dominant = this.getVertexByID_(vert, geometry_dominant);
                        shape.addVertex(newPath, vertex_dominant);
                        this.m_topo_graph.setClusterUserIndex(cluster, visitedClusters, 1);
                        do {
                            int clusterTo = this.m_topo_graph.getHalfEdgeTo(polyHalfEdge);
                            int vert1 = this.selectVertex_(clusterTo, shape);
                            assert (vert1 != -1);
                            int vertex_dominant1 = this.getVertexByID_(vert1, geometry_dominant);
                            shape.addVertex(newPath, vertex_dominant1);
                            this.m_topo_graph.setHalfEdgeUserIndex(polyHalfEdge, visitedEdges, 1);
                            this.m_topo_graph.setHalfEdgeUserIndex(this.m_topo_graph.getHalfEdgeTwin(polyHalfEdge), visitedEdges, 1);
                            this.m_topo_graph.setClusterUserIndex(clusterTo, visitedClusters, 1);
                            polyHalfEdge = this.m_topo_graph.getHalfEdgeNext(polyHalfEdge);
                            visited1 = this.m_topo_graph.getHalfEdgeUserIndex(polyHalfEdge, visitedEdges);
                            visited2 = this.m_topo_graph.getHalfEdgeUserIndex(this.m_topo_graph.getHalfEdgeTwin(polyHalfEdge), visitedEdges);
                            visited = visited1 | visited2;
                            if (visited != 2) continue block1;
                            parentage = this.m_topo_graph.getHalfEdgeParentage(polyHalfEdge);
                            if (this.isGoodParentage(parentage)) continue;
                            this.m_topo_graph.setHalfEdgeUserIndex(polyHalfEdge, visitedEdges, 1);
                            this.m_topo_graph.setHalfEdgeUserIndex(this.m_topo_graph.getHalfEdgeTwin(polyHalfEdge), visitedEdges, 1);
                            continue block1;
                        } while (polyHalfEdge != half_edge);
                        continue;
                    }
                    this.m_topo_graph.setHalfEdgeUserIndex(half_edge, visitedEdges, 1);
                    this.m_topo_graph.setHalfEdgeUserIndex(this.m_topo_graph.getHalfEdgeTwin(half_edge), visitedEdges, 1);
                } while ((half_edge = this.m_topo_graph.getHalfEdgeNext(this.m_topo_graph.getHalfEdgeTwin(half_edge))) != firstHalfEdge);
            }
            cluster = this.m_topo_graph.getNextCluster(cluster);
        }
        cluster = this.m_topo_graph.getFirstCluster();
        while (cluster != -1) {
            int parentage;
            int visited = this.m_topo_graph.getClusterUserIndex(cluster, visitedClusters);
            if (visited != 1 && this.isGoodParentage(parentage = this.m_topo_graph.getClusterParentage(cluster))) {
                int viter;
                if (multipointPath == -1) {
                    multipointPath = shape.insertPath(newGeometryMultipoint, -1);
                }
                if ((viter = this.m_topo_graph.getClusterVertexIterator(cluster)) != -1) {
                    int v = this.m_topo_graph.getVertexFromVertexIterator(viter);
                    int vertex_dominant = this.getVertexByID_(v, geometry_dominant);
                    shape.addVertex(multipointPath, vertex_dominant);
                }
            }
            cluster = this.m_topo_graph.getNextCluster(cluster);
        }
        this.m_topo_graph.deleteUserIndexForClusters(visitedClusters);
        this.m_topo_graph.deleteUserIndexForHalfEdges(visitedEdges);
        Simplificator.execute(shape, newGeometryPolygon, 1, this.m_bOGCOutput, null);
        int[] result = new int[]{newGeometryMultipoint, newGeometryPolyline, newGeometryPolygon};
        return result;
    }

    int selectVertex_(int cluster, EditShape shape) {
        int vert = -1;
        int iterator = this.m_topo_graph.getClusterVertexIterator(cluster);
        while (iterator != -1) {
            int geometry;
            int geomID;
            int vertex = this.m_topo_graph.getVertexFromVertexIterator(iterator);
            if (vert == -1) {
                vert = vertex;
            }
            if (this.isGoodParentage(geomID = this.m_topo_graph.getGeometryID(geometry = shape.getGeometryFromPath(shape.getPathFromVertex(vertex))))) {
                vert = vertex;
                break;
            }
            iterator = this.m_topo_graph.incrementVertexIterator(iterator);
        }
        return vert;
    }

    private double prevailingDirection_(EditShape shape, int half_edge) {
        int cluster = this.m_topo_graph.getHalfEdgeOrigin(half_edge);
        int clusterTo = this.m_topo_graph.getHalfEdgeTo(half_edge);
        int signTotal = 0;
        int signCorrect = 0;
        int iterator = this.m_topo_graph.getClusterVertexIterator(cluster);
        while (iterator != -1) {
            int vertex = this.m_topo_graph.getVertexFromVertexIterator(iterator);
            int path = shape.getPathFromVertex(vertex);
            int geometry = shape.getGeometryFromPath(path);
            int geomID = this.m_topo_graph.getGeometryID(geometry);
            int nextVert = shape.getNextVertex(vertex);
            int prevVert = shape.getPrevVertex(vertex);
            int firstVert = shape.getFirstVertex(path);
            if (firstVert == vertex) {
                this.m_from_edge_for_polylines = half_edge;
            }
            if (nextVert != -1 && this.m_topo_graph.getClusterFromVertex(nextVert) == clusterTo) {
                ++signTotal;
                if (this.isGoodParentage(geomID)) {
                    if (firstVert == nextVert) {
                        this.m_from_edge_for_polylines = this.m_topo_graph.getHalfEdgeNext(half_edge);
                    }
                    ++signCorrect;
                }
            } else if (prevVert != -1 && this.m_topo_graph.getClusterFromVertex(prevVert) == clusterTo) {
                --signTotal;
                if (this.isGoodParentage(geomID)) {
                    if (firstVert == prevVert) {
                        this.m_from_edge_for_polylines = this.m_topo_graph.getHalfEdgeNext(half_edge);
                    }
                    --signCorrect;
                }
            }
            iterator = this.m_topo_graph.incrementVertexIterator(iterator);
        }
        this.m_topo_graph.getXY(cluster, this.m_dummy_pt_1);
        this.m_topo_graph.getXY(clusterTo, this.m_dummy_pt_2);
        double len = Point2D.distance(this.m_dummy_pt_1, this.m_dummy_pt_2);
        return (double)(signCorrect != 0 ? signCorrect : signTotal) * len;
    }

    int getCombinedHalfEdgeParentage_(int e) {
        return this.m_topo_graph.getHalfEdgeParentage(e) | this.m_topo_graph.getHalfEdgeFaceParentage(e) | this.m_topo_graph.getHalfEdgeFaceParentage(this.m_topo_graph.getHalfEdgeTwin(e));
    }

    int tryMoveThroughCrossroadBackwards_(int half_edge) {
        int e = this.m_topo_graph.getHalfEdgeTwin(this.m_topo_graph.getHalfEdgePrev(half_edge));
        int goodEdge = -1;
        while (e != half_edge) {
            int parentage = this.getCombinedHalfEdgeParentage_(e);
            if (this.isGoodParentage(parentage)) {
                if (goodEdge != -1) {
                    return -1;
                }
                goodEdge = e;
            }
            e = this.m_topo_graph.getHalfEdgeTwin(this.m_topo_graph.getHalfEdgePrev(e));
        }
        return goodEdge != -1 ? this.m_topo_graph.getHalfEdgeTwin(goodEdge) : -1;
    }

    int tryMoveThroughCrossroadForward_(int half_edge) {
        int e = this.m_topo_graph.getHalfEdgeTwin(this.m_topo_graph.getHalfEdgeNext(half_edge));
        int goodEdge = -1;
        while (e != half_edge) {
            int parentage = this.getCombinedHalfEdgeParentage_(e);
            if (this.isGoodParentage(parentage)) {
                if (goodEdge != -1) {
                    return -1;
                }
                goodEdge = e;
            }
            e = this.m_topo_graph.getHalfEdgeTwin(this.m_topo_graph.getHalfEdgeNext(e));
        }
        return goodEdge != -1 ? this.m_topo_graph.getHalfEdgeTwin(goodEdge) : -1;
    }

    private void restorePolylineParts_(int first_edge, int newGeometry, int visitedEdges, int visitedClusters, int geometry_dominant) {
        boolean dir;
        int parentage;
        int halfEdgePrev;
        assert (this.isGoodParentage(this.getCombinedHalfEdgeParentage_(first_edge)));
        EditShape shape = this.m_topo_graph.getShape();
        int half_edge = first_edge;
        int halfEdgeTwin = this.m_topo_graph.getHalfEdgeTwin(half_edge);
        this.m_topo_graph.setHalfEdgeUserIndex(half_edge, visitedEdges, 1);
        this.m_topo_graph.setHalfEdgeUserIndex(halfEdgeTwin, visitedEdges, 1);
        double prevailingLength = this.prevailingDirection_(shape, half_edge);
        this.m_from_edge_for_polylines = -1;
        int fromEdge = half_edge;
        int toEdge = -1;
        boolean b_found_impassable_crossroad = false;
        int edgeCount = 1;
        while ((halfEdgePrev = this.m_topo_graph.getHalfEdgePrev(half_edge)) != halfEdgeTwin) {
            int halfEdgeTwinNext = this.m_topo_graph.getHalfEdgeNext(halfEdgeTwin);
            if (this.m_topo_graph.getHalfEdgeTwin(halfEdgePrev) != halfEdgeTwinNext) {
                if ((half_edge = this.tryMoveThroughCrossroadBackwards_(half_edge)) == -1) break;
                b_found_impassable_crossroad = true;
                halfEdgeTwin = this.m_topo_graph.getHalfEdgeTwin(half_edge);
            } else {
                half_edge = halfEdgePrev;
                halfEdgeTwin = halfEdgeTwinNext;
            }
            if (half_edge == first_edge) {
                toEdge = first_edge;
                break;
            }
            parentage = this.getCombinedHalfEdgeParentage_(half_edge);
            if (!this.isGoodParentage(parentage)) break;
            this.m_topo_graph.setHalfEdgeUserIndex(half_edge, visitedEdges, 1);
            this.m_topo_graph.setHalfEdgeUserIndex(halfEdgeTwin, visitedEdges, 1);
            fromEdge = half_edge;
            prevailingLength += this.prevailingDirection_(shape, half_edge);
            ++edgeCount;
        }
        if (toEdge == -1) {
            int halfEdgeNext;
            half_edge = first_edge;
            halfEdgeTwin = this.m_topo_graph.getHalfEdgeTwin(half_edge);
            toEdge = half_edge;
            while ((halfEdgeNext = this.m_topo_graph.getHalfEdgeNext(half_edge)) != halfEdgeTwin) {
                int halfEdgeTwinPrev = this.m_topo_graph.getHalfEdgePrev(halfEdgeTwin);
                if (this.m_topo_graph.getHalfEdgeTwin(halfEdgeNext) != halfEdgeTwinPrev) {
                    if ((half_edge = this.tryMoveThroughCrossroadForward_(half_edge)) == -1) {
                        b_found_impassable_crossroad = true;
                        break;
                    }
                    halfEdgeTwin = this.m_topo_graph.getHalfEdgeTwin(half_edge);
                } else {
                    half_edge = halfEdgeNext;
                    halfEdgeTwin = halfEdgeTwinPrev;
                }
                parentage = this.getCombinedHalfEdgeParentage_(half_edge);
                if (this.isGoodParentage(parentage)) {
                    this.m_topo_graph.setHalfEdgeUserIndex(half_edge, visitedEdges, 1);
                    this.m_topo_graph.setHalfEdgeUserIndex(halfEdgeTwin, visitedEdges, 1);
                    toEdge = half_edge;
                    prevailingLength += this.prevailingDirection_(shape, half_edge);
                    ++edgeCount;
                    continue;
                }
                break;
            }
        } else if (this.m_from_edge_for_polylines != -1) {
            fromEdge = this.m_from_edge_for_polylines;
            toEdge = this.m_topo_graph.getHalfEdgePrev(this.m_from_edge_for_polylines);
            int fromEdgeTwin = this.m_topo_graph.getHalfEdgeTwin(fromEdge);
            int fromEdgeTwinNext = this.m_topo_graph.getHalfEdgeNext(fromEdgeTwin);
            if (this.m_topo_graph.getHalfEdgeTwin(toEdge) != fromEdgeTwinNext && (toEdge = this.tryMoveThroughCrossroadBackwards_(fromEdge)) == -1) {
                throw GeometryException.GeometryInternalError();
            }
            assert (this.isGoodParentage(this.getCombinedHalfEdgeParentage_(this.m_from_edge_for_polylines)));
            assert (this.isGoodParentage(this.getCombinedHalfEdgeParentage_(toEdge)));
        }
        boolean bl = dir = prevailingLength >= 0.0;
        if (!dir) {
            int e = toEdge;
            toEdge = fromEdge;
            fromEdge = e;
            toEdge = this.m_topo_graph.getHalfEdgeTwin(toEdge);
            assert (this.isGoodParentage(this.getCombinedHalfEdgeParentage_(toEdge)));
            fromEdge = this.m_topo_graph.getHalfEdgeTwin(fromEdge);
            assert (this.isGoodParentage(this.getCombinedHalfEdgeParentage_(fromEdge)));
        }
        int newPath = shape.insertPath(newGeometry, -1);
        half_edge = fromEdge;
        int cluster = this.m_topo_graph.getHalfEdgeOrigin(fromEdge);
        int clusterLast = this.m_topo_graph.getHalfEdgeTo(toEdge);
        boolean b_closed = clusterLast == cluster;
        boolean b_closed_linestring_touches_other_linestring = b_closed && b_found_impassable_crossroad;
        int vert = this.selectVertex_(cluster, shape);
        assert (vert != -1);
        int vertex_dominant = this.getVertexByID_(vert, geometry_dominant);
        shape.addVertex(newPath, vertex_dominant);
        if (visitedClusters != -1) {
            this.m_topo_graph.setClusterUserIndex(cluster, visitedClusters, 1);
        }
        int counter = 0;
        int splitAt = b_closed_linestring_touches_other_linestring ? (edgeCount + 1) / 2 : -1;
        while (true) {
            int clusterTo = this.m_topo_graph.getHalfEdgeTo(half_edge);
            int vert_1 = this.selectVertex_(clusterTo, shape);
            vertex_dominant = this.getVertexByID_(vert_1, geometry_dominant);
            shape.addVertex(newPath, vertex_dominant);
            ++counter;
            if (visitedClusters != -1) {
                this.m_topo_graph.setClusterUserIndex(clusterTo, visitedClusters, 1);
            }
            if (b_closed_linestring_touches_other_linestring && counter == splitAt) {
                newPath = shape.insertPath(newGeometry, -1);
                shape.addVertex(newPath, vertex_dominant);
            }
            assert (this.isGoodParentage(this.getCombinedHalfEdgeParentage_(half_edge)));
            if (half_edge == toEdge) break;
            int halfEdgeNext = this.m_topo_graph.getHalfEdgeNext(half_edge);
            if (this.m_topo_graph.getHalfEdgePrev(this.m_topo_graph.getHalfEdgeTwin(half_edge)) != this.m_topo_graph.getHalfEdgeTwin(halfEdgeNext)) {
                if ((half_edge = this.tryMoveThroughCrossroadForward_(half_edge)) != -1) continue;
                throw GeometryException.GeometryInternalError();
            }
            half_edge = halfEdgeNext;
        }
    }

    private int topoOperationPolylinePolylineOrPolygon_(int geometry_dominant) {
        EditShape shape = this.m_topo_graph.getShape();
        int newGeometry = shape.createGeometry(Geometry.Type.Polyline);
        int visitedEdges = this.m_topo_graph.createUserIndexForHalfEdges();
        int cluster = this.m_topo_graph.getFirstCluster();
        while (cluster != -1) {
            int firstClusterHalfEdge;
            int clusterHalfEdge = firstClusterHalfEdge = this.m_topo_graph.getClusterHalfEdge(cluster);
            do {
                int parentage;
                int visited;
                if ((visited = this.m_topo_graph.getHalfEdgeUserIndex(clusterHalfEdge, visitedEdges)) == 1 || !this.isGoodParentage(parentage = this.getCombinedHalfEdgeParentage_(clusterHalfEdge))) continue;
                this.restorePolylineParts_(clusterHalfEdge, newGeometry, visitedEdges, -1, geometry_dominant);
            } while ((clusterHalfEdge = this.m_topo_graph.getHalfEdgeNext(this.m_topo_graph.getHalfEdgeTwin(clusterHalfEdge))) != firstClusterHalfEdge);
            cluster = this.m_topo_graph.getNextCluster(cluster);
        }
        this.m_topo_graph.deleteUserIndexForHalfEdges(visitedEdges);
        return newGeometry;
    }

    int[] topoOperationPolylinePolylineOrPolygonEx_(int geometry_dominant) {
        EditShape shape = this.m_topo_graph.getShape();
        int newPolyline = shape.createGeometry(Geometry.Type.Polyline);
        int newMultipoint = shape.createGeometry(Geometry.Type.MultiPoint);
        int visitedEdges = this.m_topo_graph.createUserIndexForHalfEdges();
        int visitedClusters = this.m_topo_graph.createUserIndexForClusters();
        int multipointPath = -1;
        int cluster = this.m_topo_graph.getFirstCluster();
        while (cluster != -1) {
            int firstClusterHalfEdge;
            int clusterHalfEdge = firstClusterHalfEdge = this.m_topo_graph.getClusterHalfEdge(cluster);
            do {
                int parentage;
                int visited;
                if ((visited = this.m_topo_graph.getHalfEdgeUserIndex(clusterHalfEdge, visitedEdges)) == 1 || !this.isGoodParentage(parentage = this.getCombinedHalfEdgeParentage_(clusterHalfEdge))) continue;
                this.restorePolylineParts_(clusterHalfEdge, newPolyline, visitedEdges, visitedClusters, geometry_dominant);
            } while ((clusterHalfEdge = this.m_topo_graph.getHalfEdgeNext(this.m_topo_graph.getHalfEdgeTwin(clusterHalfEdge))) != firstClusterHalfEdge);
            cluster = this.m_topo_graph.getNextCluster(cluster);
        }
        cluster = this.m_topo_graph.getFirstCluster();
        while (cluster != -1) {
            int parentage;
            int visited = this.m_topo_graph.getClusterUserIndex(cluster, visitedClusters);
            if (visited != 1 && this.isGoodParentage(parentage = this.m_topo_graph.getClusterParentage(cluster))) {
                int viter;
                if (multipointPath == -1) {
                    multipointPath = shape.insertPath(newMultipoint, -1);
                }
                if ((viter = this.m_topo_graph.getClusterVertexIterator(cluster)) != -1) {
                    int v = this.m_topo_graph.getVertexFromVertexIterator(viter);
                    int vertex_dominant = this.getVertexByID_(v, geometry_dominant);
                    shape.addVertex(multipointPath, vertex_dominant);
                }
            }
            cluster = this.m_topo_graph.getNextCluster(cluster);
        }
        this.m_topo_graph.deleteUserIndexForHalfEdges(visitedEdges);
        this.m_topo_graph.deleteUserIndexForClusters(visitedClusters);
        int[] result = new int[]{newMultipoint, newPolyline};
        return result;
    }

    private int topoOperationMultiPoint_() {
        EditShape shape = this.m_topo_graph.getShape();
        int newGeometry = shape.createGeometry(Geometry.Type.MultiPoint);
        int newPath = shape.insertPath(newGeometry, -1);
        int cluster = this.m_topo_graph.getFirstCluster();
        while (cluster != -1) {
            int parentage = this.m_topo_graph.getClusterParentage(cluster);
            if (this.isGoodParentage(parentage)) {
                int vert = -1;
                int iterator = this.m_topo_graph.getClusterVertexIterator(cluster);
                while (iterator != -1) {
                    int geometry;
                    int geomID;
                    int vertex = this.m_topo_graph.getVertexFromVertexIterator(iterator);
                    if (vert == -1) {
                        vert = vertex;
                    }
                    if (this.isGoodParentage(geomID = this.m_topo_graph.getGeometryID(geometry = shape.getGeometryFromPath(shape.getPathFromVertex(vertex))))) {
                        vert = vertex;
                        break;
                    }
                    iterator = this.m_topo_graph.incrementVertexIterator(iterator);
                }
                assert (vert != -1);
                shape.addVertex(newPath, vert);
            }
            cluster = this.m_topo_graph.getNextCluster(cluster);
        }
        return newGeometry;
    }

    void initMaskLookupArray_(int len) {
        this.m_mask_lookup = new boolean[len];
        for (int i = 0; i < len; ++i) {
            this.m_mask_lookup[i] = false;
        }
    }

    static MultiPoint processMultiPointIntersectOrDiff_(MultiPoint multi_point, Geometry intersector, double tolerance, boolean bClipIn) {
        int num;
        boolean bArea;
        MultiPoint multi_point_out = (MultiPoint)multi_point.createInstance();
        Point2D[] input_points = new Point2D[1000];
        PolygonUtils.PiPResult[] test_results = new PolygonUtils.PiPResult[1000];
        int npoints = multi_point.getPointCount();
        boolean bFirstOut = true;
        boolean bl = bArea = intersector.getDimension() == 2;
        if (intersector.getDimension() != 1 && intersector.getDimension() != 2) {
            throw GeometryException.GeometryInternalError();
        }
        for (int ipoints = 0; ipoints < npoints; ipoints += num) {
            num = multi_point.queryCoordinates(input_points, 1000, ipoints, -1) - ipoints;
            if (bArea) {
                PolygonUtils.testPointsInArea2D(intersector, input_points, num, tolerance, test_results);
            } else {
                PolygonUtils.testPointsOnLine2D(intersector, input_points, num, tolerance, test_results);
            }
            int i0 = 0;
            for (int i = 0; i < num; ++i) {
                boolean bTest;
                boolean bl2 = bTest = test_results[i] == PolygonUtils.PiPResult.PiPOutside;
                if (!bClipIn) {
                    boolean bl3 = bTest = !bTest;
                }
                if (!bTest) continue;
                if (bFirstOut) {
                    bFirstOut = false;
                    multi_point_out.add(multi_point, 0, ipoints);
                }
                if (i0 != i) {
                    multi_point_out.add(multi_point, ipoints + i0, ipoints + i);
                }
                i0 = i + 1;
            }
            if (bFirstOut || i0 == num) continue;
            multi_point_out.add(multi_point, ipoints + i0, ipoints + num);
        }
        if (bFirstOut) {
            return multi_point;
        }
        return multi_point_out;
    }

    static MultiPoint intersection(MultiPoint multi_point, Geometry multi_path, double tolerance) {
        return TopologicalOperations.processMultiPointIntersectOrDiff_(multi_point, multi_path, tolerance, true);
    }

    static MultiPoint difference(MultiPoint multi_point, Geometry multi_path, double tolerance) {
        return TopologicalOperations.processMultiPointIntersectOrDiff_(multi_point, multi_path, tolerance, false);
    }

    static Point processPointIntersectOrDiff_(Point point, Geometry intersector, double tolerance, boolean bClipIn) {
        boolean bTest;
        boolean bArea;
        if (point.isEmpty()) {
            return (Point)point.createInstance();
        }
        if (intersector.isEmpty()) {
            return bClipIn ? (Point)point.createInstance() : null;
        }
        Point2D[] input_points = new Point2D[1];
        PolygonUtils.PiPResult[] test_results = new PolygonUtils.PiPResult[1];
        boolean bl = bArea = intersector.getDimension() == 2;
        if (intersector.getDimension() != 1 && intersector.getDimension() != 2) {
            throw GeometryException.GeometryInternalError();
        }
        input_points[0] = point.getXY();
        if (bArea) {
            PolygonUtils.testPointsInArea2D(intersector, input_points, 1, tolerance, test_results);
        } else {
            PolygonUtils.testPointsOnLine2D(intersector, input_points, 1, tolerance, test_results);
        }
        boolean bl2 = bTest = test_results[0] == PolygonUtils.PiPResult.PiPOutside;
        if (!bClipIn) {
            boolean bl3 = bTest = !bTest;
        }
        if (!bTest) {
            return point;
        }
        return (Point)point.createInstance();
    }

    static Point intersection(Point point, Geometry geom, double tolerance) {
        return TopologicalOperations.processPointIntersectOrDiff_(point, geom, tolerance, true);
    }

    static Point difference(Point point, Geometry geom, double tolerance) {
        return TopologicalOperations.processPointIntersectOrDiff_(point, geom, tolerance, false);
    }

    static Point intersection(Point point, Point point2, double tolerance) {
        if (point.isEmpty() || point2.isEmpty()) {
            return (Point)point.createInstance();
        }
        if (CrackAndCluster.non_empty_points_need_to_cluster(tolerance, point, point2)) {
            return CrackAndCluster.cluster_non_empty_points(point, point2, 1.0, 1, 1.0, 1);
        }
        return (Point)point.createInstance();
    }

    static Point difference(Point point, Point point2, double tolerance) {
        if (point.isEmpty()) {
            return (Point)point.createInstance();
        }
        if (point2.isEmpty()) {
            return point;
        }
        if (CrackAndCluster.non_empty_points_need_to_cluster(tolerance, point, point2)) {
            return (Point)point.createInstance();
        }
        return point;
    }

    MultiVertexGeometry planarSimplifyImpl_(MultiVertexGeometry input_geom, double tolerance, boolean b_use_winding_rule_for_polygons, boolean dirty_result, ProgressTracker progress_tracker) {
        if (input_geom.isEmpty()) {
            return input_geom;
        }
        EditShape shape = new EditShape();
        int geom = shape.addGeometry(input_geom);
        return this.planarSimplify(shape, geom, tolerance, b_use_winding_rule_for_polygons, dirty_result, progress_tracker);
    }

    MultiVertexGeometry planarSimplify(EditShape shape, int geom, double tolerance, boolean b_use_winding_rule_for_polygons, boolean dirty_result, ProgressTracker progress_tracker) {
        this.m_topo_graph = new TopoGraph();
        try {
            Object plane_sweeper;
            if (dirty_result && shape.getGeometryType(geom) != Geometry.Type.MultiPoint.value()) {
                plane_sweeper = new PlaneSweepCrackerHelper();
                ((PlaneSweepCrackerHelper)plane_sweeper).sweepVertical(shape, tolerance);
                if (((PlaneSweepCrackerHelper)plane_sweeper).hadCompications()) {
                    CrackAndCluster.execute(shape, tolerance, progress_tracker, true);
                    dirty_result = false;
                } else {
                    this.m_topo_graph.check_dirty_planesweep(tolerance);
                }
            } else {
                CrackAndCluster.execute(shape, tolerance, progress_tracker, true);
                dirty_result = false;
            }
            if (!b_use_winding_rule_for_polygons || shape.getGeometryType(geom) == Geometry.Type.MultiPoint.value()) {
                this.m_topo_graph.setAndSimplifyEditShapeAlternate(shape, geom, progress_tracker);
            } else {
                this.m_topo_graph.setAndSimplifyEditShapeWinding(shape, geom, progress_tracker);
            }
            if (this.m_topo_graph.dirty_check_failed()) {
                assert (dirty_result);
                this.m_topo_graph.removeShape();
                this.m_topo_graph = null;
                plane_sweeper = this.planarSimplify(shape, geom, tolerance, b_use_winding_rule_for_polygons, false, progress_tracker);
                return plane_sweeper;
            }
            this.m_topo_graph.check_dirty_planesweep(Double.NaN);
            int ID_a = this.m_topo_graph.getGeometryID(geom);
            this.initMaskLookupArray_(ID_a + 1);
            this.m_mask_lookup[ID_a] = true;
            if (shape.getGeometryType(geom) == Geometry.Type.Polygon.value() || b_use_winding_rule_for_polygons && shape.getGeometryType(geom) != Geometry.Type.MultiPoint.value()) {
                shape.setFillRule(geom, 0);
                int resGeom = this.topoOperationPolygonPolygon_(geom, -1, -1);
                Polygon polygon = (Polygon)shape.getGeometry(resGeom);
                polygon.setFillRule(0);
                if (!dirty_result) {
                    ((MultiVertexGeometryImpl)polygon._getImpl()).setIsSimple(2, tolerance, false);
                    ((MultiPathImpl)polygon._getImpl())._updateOGCFlags();
                } else {
                    ((MultiVertexGeometryImpl)polygon._getImpl()).setIsSimple(1, 0.0, false);
                }
                Polygon polygon2 = polygon;
                return polygon2;
            }
            if (shape.getGeometryType(geom) == Geometry.Type.Polyline.value()) {
                int resGeom = this.topoOperationPolylinePolylineOrPolygon_(-1);
                Polyline polyline = (Polyline)shape.getGeometry(resGeom);
                if (!dirty_result) {
                    ((MultiVertexGeometryImpl)polyline._getImpl()).setIsSimple(2, tolerance, false);
                }
                Polyline polyline2 = polyline;
                return polyline2;
            }
            if (shape.getGeometryType(geom) == Geometry.Type.MultiPoint.value()) {
                int resGeom = this.topoOperationMultiPoint_();
                MultiPoint mp = (MultiPoint)shape.getGeometry(resGeom);
                if (!dirty_result) {
                    ((MultiVertexGeometryImpl)mp._getImpl()).setIsSimple(2, tolerance, false);
                }
                MultiPoint multiPoint = mp;
                return multiPoint;
            }
            throw GeometryException.GeometryInternalError();
        }
        finally {
            this.m_topo_graph.removeShape();
        }
    }

    static MultiVertexGeometry planarSimplify(MultiVertexGeometry input_geom, double tolerance, boolean use_winding_rule_for_polygons, boolean dirty_result, ProgressTracker progress_tracker) {
        TopologicalOperations topoOps = new TopologicalOperations();
        return topoOps.planarSimplifyImpl_(input_geom, tolerance, use_winding_rule_for_polygons, dirty_result, progress_tracker);
    }

    boolean planarSimplifyNoCrackingAndCluster(boolean OGCoutput, EditShape shape, int geom, ProgressTracker progress_tracker) {
        this.m_bOGCOutput = OGCoutput;
        this.m_topo_graph = new TopoGraph();
        int rule = shape.getFillRule(geom);
        int gt = shape.getGeometryType(geom);
        if (rule != 1 || gt == 550) {
            this.m_topo_graph.setAndSimplifyEditShapeAlternate(shape, geom, progress_tracker);
        } else {
            this.m_topo_graph.setAndSimplifyEditShapeWinding(shape, geom, progress_tracker);
        }
        if (this.m_topo_graph.dirty_check_failed()) {
            return false;
        }
        this.m_topo_graph.check_dirty_planesweep(Double.NaN);
        int ID_a = this.m_topo_graph.getGeometryID(geom);
        this.initMaskLookupArray_(ID_a + 1);
        this.m_mask_lookup[ID_a] = true;
        if (shape.getGeometryType(geom) == 1736 || rule == 1 && shape.getGeometryType(geom) != 550) {
            shape.setFillRule(geom, 0);
            int resGeom = this.topoOperationPolygonPolygon_(geom, -1, -1);
            shape.swapGeometry(resGeom, geom);
            shape.removeGeometry(resGeom);
        } else if (shape.getGeometryType(geom) == 1607) {
            int resGeom = this.topoOperationPolylinePolylineOrPolygon_(-1);
            shape.swapGeometry(resGeom, geom);
            shape.removeGeometry(resGeom);
        } else if (shape.getGeometryType(geom) == 550) {
            int resGeom = this.topoOperationMultiPoint_();
            shape.swapGeometry(resGeom, geom);
            shape.removeGeometry(resGeom);
        } else {
            throw new GeometryException("internal error");
        }
        return true;
    }

    static MultiVertexGeometry simplifyOGC(MultiVertexGeometry input_geom, double tolerance, boolean dirty_result, ProgressTracker progress_tracker) {
        TopologicalOperations topoOps = new TopologicalOperations();
        topoOps.m_bOGCOutput = true;
        return topoOps.planarSimplifyImpl_(input_geom, tolerance, false, dirty_result, progress_tracker);
    }

    public int difference(int geometry_a, int geometry_b) {
        int dim_b;
        int gtA = this.m_topo_graph.getShape().getGeometryType(geometry_a);
        int gtB = this.m_topo_graph.getShape().getGeometryType(geometry_b);
        int dim_a = Geometry.getDimensionFromType(gtA);
        if (dim_a > (dim_b = Geometry.getDimensionFromType(gtB))) {
            return geometry_a;
        }
        int ID_a = this.m_topo_graph.getGeometryID(geometry_a);
        int ID_b = this.m_topo_graph.getGeometryID(geometry_b);
        this.initMaskLookupArray_((ID_a | ID_b) + 1);
        this.m_mask_lookup[this.m_topo_graph.getGeometryID((int)geometry_a)] = true;
        if (dim_a == 2 && dim_b == 2) {
            return this.topoOperationPolygonPolygon_(geometry_a, geometry_b, -1);
        }
        if (dim_a == 1 && dim_b == 2) {
            return this.topoOperationPolylinePolylineOrPolygon_(-1);
        }
        if (dim_a == 1 && dim_b == 1) {
            return this.topoOperationPolylinePolylineOrPolygon_(-1);
        }
        if (dim_a == 0) {
            return this.topoOperationMultiPoint_();
        }
        throw GeometryException.GeometryInternalError();
    }

    int dissolve(int geometry_a, int geometry_b) {
        int dim_b;
        int gtA = this.m_topo_graph.getShape().getGeometryType(geometry_a);
        int gtB = this.m_topo_graph.getShape().getGeometryType(geometry_b);
        int dim_a = Geometry.getDimensionFromType(gtA);
        if (dim_a > (dim_b = Geometry.getDimensionFromType(gtB))) {
            return geometry_a;
        }
        if (dim_a < dim_b) {
            return geometry_b;
        }
        int ID_a = this.m_topo_graph.getGeometryID(geometry_a);
        int ID_b = this.m_topo_graph.getGeometryID(geometry_b);
        this.initMaskLookupArray_((ID_a | ID_b) + 1);
        this.m_mask_lookup[this.m_topo_graph.getGeometryID((int)geometry_a)] = true;
        this.m_mask_lookup[this.m_topo_graph.getGeometryID((int)geometry_b)] = true;
        this.m_mask_lookup[this.m_topo_graph.getGeometryID((int)geometry_a) | this.m_topo_graph.getGeometryID((int)geometry_b)] = true;
        if (dim_a == 2 && dim_b == 2) {
            return this.topoOperationPolygonPolygon_(geometry_a, geometry_b, -1);
        }
        if (dim_a == 1 && dim_b == 1) {
            return this.topoOperationPolylinePolylineOrPolygon_(-1);
        }
        if (dim_a == 0 && dim_b == 0) {
            return this.topoOperationMultiPoint_();
        }
        throw GeometryException.GeometryInternalError();
    }

    public int intersection(int geometry_a, int geometry_b) {
        boolean b_vertex_dominance;
        int gtA = this.m_topo_graph.getShape().getGeometryType(geometry_a);
        int gtB = this.m_topo_graph.getShape().getGeometryType(geometry_b);
        int dim_a = Geometry.getDimensionFromType(gtA);
        int dim_b = Geometry.getDimensionFromType(gtB);
        int ID_a = this.m_topo_graph.getGeometryID(geometry_a);
        int ID_b = this.m_topo_graph.getGeometryID(geometry_b);
        this.initMaskLookupArray_((ID_a | ID_b) + 1);
        this.m_mask_lookup[this.m_topo_graph.getGeometryID((int)geometry_a) | this.m_topo_graph.getGeometryID((int)geometry_b)] = true;
        int geometry_dominant = -1;
        boolean bl = b_vertex_dominance = this.m_topo_graph.getShape().getVertexDescription().getAttributeCount() > 1;
        if (b_vertex_dominance) {
            geometry_dominant = geometry_a;
        }
        if (dim_a == 2 && dim_b == 2) {
            return this.topoOperationPolygonPolygon_(geometry_a, geometry_b, geometry_dominant);
        }
        if (dim_a == 1 && dim_b > 0 || dim_b == 1 && dim_a > 0) {
            return this.topoOperationPolylinePolylineOrPolygon_(geometry_dominant);
        }
        if (dim_a == 0 || dim_b == 0) {
            return this.topoOperationMultiPoint_();
        }
        throw GeometryException.GeometryInternalError();
    }

    int[] intersectionEx(int geometry_a, int geometry_b) {
        boolean b_vertex_dominance;
        int gtA = this.m_topo_graph.getShape().getGeometryType(geometry_a);
        int gtB = this.m_topo_graph.getShape().getGeometryType(geometry_b);
        int dim_a = Geometry.getDimensionFromType(gtA);
        int dim_b = Geometry.getDimensionFromType(gtB);
        int ID_a = this.m_topo_graph.getGeometryID(geometry_a);
        int ID_b = this.m_topo_graph.getGeometryID(geometry_b);
        this.initMaskLookupArray_((ID_a | ID_b) + 1);
        this.m_mask_lookup[this.m_topo_graph.getGeometryID((int)geometry_a) | this.m_topo_graph.getGeometryID((int)geometry_b)] = true;
        int geometry_dominant = -1;
        boolean bl = b_vertex_dominance = this.m_topo_graph.getShape().getVertexDescription().getAttributeCount() > 1;
        if (b_vertex_dominance) {
            geometry_dominant = geometry_a;
        }
        if (dim_a == 2 && dim_b == 2) {
            return this.topoOperationPolygonPolygonEx_(geometry_a, geometry_b, geometry_dominant);
        }
        if (dim_a == 1 && dim_b > 0 || dim_b == 1 && dim_a > 0) {
            return this.topoOperationPolylinePolylineOrPolygonEx_(geometry_dominant);
        }
        if (dim_a == 0 || dim_b == 0) {
            int[] res = new int[]{this.topoOperationMultiPoint_()};
            return res;
        }
        throw GeometryException.GeometryInternalError();
    }

    public int symmetricDifference(int geometry_a, int geometry_b) {
        int gtA = this.m_topo_graph.getShape().getGeometryType(geometry_a);
        int gtB = this.m_topo_graph.getShape().getGeometryType(geometry_b);
        int dim_a = Geometry.getDimensionFromType(gtA);
        int dim_b = Geometry.getDimensionFromType(gtB);
        int ID_a = this.m_topo_graph.getGeometryID(geometry_a);
        int ID_b = this.m_topo_graph.getGeometryID(geometry_b);
        this.initMaskLookupArray_((ID_a | ID_b) + 1);
        this.m_mask_lookup[this.m_topo_graph.getGeometryID((int)geometry_a)] = true;
        this.m_mask_lookup[this.m_topo_graph.getGeometryID((int)geometry_b)] = true;
        if (dim_a == 2 && dim_b == 2) {
            return this.topoOperationPolygonPolygon_(geometry_a, geometry_b, -1);
        }
        if (dim_a == 1 && dim_b == 1) {
            return this.topoOperationPolylinePolylineOrPolygon_(-1);
        }
        if (dim_a == 0 && dim_b == 0) {
            return this.topoOperationMultiPoint_();
        }
        throw GeometryException.GeometryInternalError();
    }

    int extractShape(int geometry_in) {
        int gtA = this.m_topo_graph.getShape().getGeometryType(geometry_in);
        int dim_a = Geometry.getDimensionFromType(gtA);
        int ID_a = this.m_topo_graph.getGeometryID(geometry_in);
        this.initMaskLookupArray_(ID_a + 1);
        this.m_mask_lookup[this.m_topo_graph.getGeometryID((int)geometry_in)] = true;
        if (dim_a == 2) {
            return this.topoOperationPolygonPolygon_(geometry_in, -1, -1);
        }
        if (dim_a == 1) {
            return this.topoOperationPolylinePolylineOrPolygon_(-1);
        }
        if (dim_a == 0) {
            return this.topoOperationMultiPoint_();
        }
        throw GeometryException.GeometryInternalError();
    }

    static Geometry normalizeInputGeometry_(Geometry geom) {
        Geometry.Type gt = geom.getType();
        if (gt == Geometry.Type.Envelope) {
            Polygon poly = new Polygon(geom.getDescription());
            if (!geom.isEmpty()) {
                poly.addEnvelope((Envelope)geom, false);
            }
            return poly;
        }
        if (gt == Geometry.Type.Point) {
            MultiPoint poly = new MultiPoint(geom.getDescription());
            if (!geom.isEmpty()) {
                poly.add((Point)geom);
            }
            return poly;
        }
        if (gt == Geometry.Type.Line) {
            Polyline poly = new Polyline(geom.getDescription());
            if (!geom.isEmpty()) {
                poly.addSegment((Segment)geom, true);
            }
            return poly;
        }
        return geom;
    }

    static Geometry normalizeResult_(Geometry geomRes, Geometry geom_a, Geometry dummy, char op) {
        Geometry.Type gtRes = geomRes.getType();
        if (gtRes == Geometry.Type.Envelope) {
            Polygon poly = new Polygon(geomRes.getDescription());
            if (!geomRes.isEmpty()) {
                poly.addEnvelope((Envelope)geomRes, false);
            }
            return poly;
        }
        if (gtRes == Geometry.Type.Point && (op == '|' || op == '^')) {
            MultiPoint poly = new MultiPoint(geomRes.getDescription());
            if (!geomRes.isEmpty()) {
                poly.add((Point)geomRes);
            }
            return poly;
        }
        if (gtRes == Geometry.Type.Line) {
            Polyline poly = new Polyline(geomRes.getDescription());
            if (!geomRes.isEmpty()) {
                poly.addSegment((Segment)geomRes, true);
            }
            return poly;
        }
        if (gtRes == Geometry.Type.Point && op == '-' && geom_a.getType() == Geometry.Type.Point) {
            Point pt = new Point(geomRes.getDescription());
            if (!geomRes.isEmpty()) {
                assert (((MultiPoint)geomRes).getPointCount() == 1);
                ((MultiPoint)geomRes).getPointByVal(0, pt);
            }
            return pt;
        }
        if (gtRes == Geometry.Type.MultiPoint && op == '&' && geom_a.getType() == Geometry.Type.Point) {
            Point pt = new Point(geomRes.getDescription());
            if (!geomRes.isEmpty()) {
                assert (((MultiPoint)geomRes).getPointCount() == 1);
                ((MultiPoint)geomRes).getPointByVal(0, pt);
            }
            return pt;
        }
        return geomRes;
    }

    public static Geometry difference(Geometry geometry_a, Geometry geometry_b, SpatialReference sr, ProgressTracker progress_tracker) {
        if (geometry_a.isEmpty() || geometry_b.isEmpty() || geometry_a.getDimension() > geometry_b.getDimension()) {
            return TopologicalOperations.normalizeResult_(TopologicalOperations.normalizeInputGeometry_(geometry_a), geometry_a, geometry_b, '-');
        }
        Envelope2D env2D_1 = new Envelope2D();
        geometry_a.queryEnvelope2D(env2D_1);
        Envelope2D env2D_2 = new Envelope2D();
        geometry_b.queryEnvelope2D(env2D_2);
        if (!env2D_1.isIntersecting(env2D_2)) {
            return TopologicalOperations.normalizeResult_(TopologicalOperations.normalizeInputGeometry_(geometry_a), geometry_a, geometry_b, '-');
        }
        Envelope2D envMerged = new Envelope2D();
        envMerged.setCoords(env2D_1);
        envMerged.merge(env2D_2);
        double tolerance = InternalUtils.calculateToleranceFromGeometry(sr, envMerged, true);
        TopologicalOperations topoOps = new TopologicalOperations();
        EditShape edit_shape = new EditShape();
        int geom_a = edit_shape.addGeometry(TopologicalOperations.normalizeInputGeometry_(geometry_a));
        int geom_b = edit_shape.addGeometry(TopologicalOperations.normalizeInputGeometry_(geometry_b));
        topoOps.setEditShapeCrackAndCluster(edit_shape, tolerance, progress_tracker);
        int result = topoOps.difference(geom_a, geom_b);
        Geometry resGeom = edit_shape.getGeometry(result);
        Geometry res_geom = TopologicalOperations.normalizeResult_(resGeom, geometry_a, geometry_b, '-');
        if (Geometry.isMultiPath(res_geom.getType().value())) {
            ((MultiVertexGeometryImpl)res_geom._getImpl()).setIsSimple(2, tolerance, false);
            if (res_geom.getType() == Geometry.Type.Polygon) {
                ((MultiPathImpl)res_geom._getImpl())._updateOGCFlags();
            }
        }
        return res_geom;
    }

    public static Geometry dissolve(Geometry geometry_a, Geometry geometry_b, SpatialReference sr, ProgressTracker progress_tracker) {
        if (geometry_a.getDimension() > geometry_b.getDimension()) {
            return TopologicalOperations.normalizeResult_(TopologicalOperations.normalizeInputGeometry_(geometry_a), geometry_a, geometry_b, '|');
        }
        if (geometry_a.getDimension() < geometry_b.getDimension()) {
            return TopologicalOperations.normalizeResult_(TopologicalOperations.normalizeInputGeometry_(geometry_b), geometry_a, geometry_b, '|');
        }
        if (geometry_a.isEmpty()) {
            return TopologicalOperations.normalizeResult_(TopologicalOperations.normalizeInputGeometry_(geometry_b), geometry_a, geometry_b, '|');
        }
        if (geometry_b.isEmpty()) {
            return TopologicalOperations.normalizeResult_(TopologicalOperations.normalizeInputGeometry_(geometry_a), geometry_a, geometry_b, '|');
        }
        Envelope2D env2D_1 = new Envelope2D();
        geometry_a.queryEnvelope2D(env2D_1);
        Envelope2D env2D_2 = new Envelope2D();
        geometry_b.queryEnvelope2D(env2D_2);
        Envelope2D envMerged = new Envelope2D();
        envMerged.setCoords(env2D_1);
        envMerged.merge(env2D_2);
        double tolerance = InternalUtils.calculateToleranceFromGeometry(sr, envMerged, true);
        if (!env2D_1.isIntersecting(env2D_2.getInflated(tolerance, tolerance))) {
            Geometry geom1 = TopologicalOperations.normalizeInputGeometry_(geometry_a);
            assert (Geometry.isMultiVertex(geom1.getType().value()));
            Geometry geom2 = TopologicalOperations.normalizeInputGeometry_(geometry_b);
            assert (Geometry.isMultiVertex(geom2.getType().value()));
            assert (geom1.getType() == geom2.getType());
            switch (geom1.getType().value()) {
                case 550: {
                    Geometry res = Geometry._clone(geom1);
                    ((MultiPoint)res).add((MultiPoint)geom2, 0, -1);
                    return res;
                }
                case 1607: {
                    Geometry res = Geometry._clone(geom1);
                    ((Polyline)res).add((MultiPath)geom2, false);
                    return res;
                }
                case 1736: {
                    Geometry res = Geometry._clone(geom1);
                    ((Polygon)res).add((MultiPath)geom2, false);
                    return res;
                }
            }
            throw GeometryException.GeometryInternalError();
        }
        TopologicalOperations topoOps = new TopologicalOperations();
        EditShape edit_shape = new EditShape();
        int geom_a = edit_shape.addGeometry(TopologicalOperations.normalizeInputGeometry_(geometry_a));
        int geom_b = edit_shape.addGeometry(TopologicalOperations.normalizeInputGeometry_(geometry_b));
        topoOps.setEditShapeCrackAndCluster(edit_shape, tolerance, progress_tracker);
        int result = topoOps.dissolve(geom_a, geom_b);
        Geometry res_geom = TopologicalOperations.normalizeResult_(edit_shape.getGeometry(result), geometry_a, geometry_b, '|');
        if (Geometry.isMultiPath(res_geom.getType().value())) {
            ((MultiVertexGeometryImpl)res_geom._getImpl()).setIsSimple(2, tolerance, false);
            if (res_geom.getType() == Geometry.Type.Polygon) {
                ((MultiPathImpl)res_geom._getImpl())._updateOGCFlags();
            }
        }
        return res_geom;
    }

    static Geometry dissolveDirty(ArrayList<Geometry> geometries, SpatialReference sr, ProgressTracker progress_tracker) {
        if (geometries.size() < 2) {
            throw new IllegalArgumentException("not enough geometries to dissolve");
        }
        int dim = 0;
        int n = geometries.size();
        for (int i = 0; i < n; ++i) {
            dim = Math.max(geometries.get(i).getDimension(), dim);
        }
        Envelope2D envMerged = new Envelope2D();
        envMerged.setEmpty();
        EditShape shape = new EditShape();
        int geom = -1;
        int count = 0;
        int any_index = -1;
        int n2 = geometries.size();
        for (int i = 0; i < n2; ++i) {
            if (geometries.get(i).getDimension() != dim) continue;
            if (!geometries.get(i).isEmpty()) {
                any_index = i;
                if (geom == -1) {
                    geom = shape.addGeometry(TopologicalOperations.normalizeInputGeometry_(geometries.get(i)));
                } else {
                    shape.appendGeometry(geom, TopologicalOperations.normalizeInputGeometry_(geometries.get(i)));
                }
                Envelope2D env = new Envelope2D();
                geometries.get(i).queryLooseEnvelope2D(env);
                envMerged.merge(env);
                ++count;
                continue;
            }
            if (any_index != -1) continue;
            any_index = i;
        }
        if (count < 2) {
            return TopologicalOperations.normalizeInputGeometry_(geometries.get(any_index));
        }
        boolean winding = dim == 2;
        SpatialReference psr = dim == 0 ? sr : null;
        double tolerance = InternalUtils.calculateToleranceFromGeometry(psr, envMerged, true);
        TopologicalOperations topoOps = new TopologicalOperations();
        return topoOps.planarSimplify(shape, geom, tolerance, winding, true, progress_tracker);
    }

    public static Geometry intersection(Geometry geometry_a, Geometry geometry_b, SpatialReference sr, ProgressTracker progress_tracker) {
        Envelope2D env2D_1 = new Envelope2D();
        geometry_a.queryEnvelope2D(env2D_1);
        Envelope2D env2D_2 = new Envelope2D();
        geometry_b.queryEnvelope2D(env2D_2);
        Envelope2D envMerged = new Envelope2D();
        envMerged.setCoords(env2D_1);
        envMerged.merge(env2D_2);
        double tolerance = InternalUtils.calculateToleranceFromGeometry(sr, envMerged, true);
        Envelope2D e = new Envelope2D();
        e.setCoords(env2D_2);
        double tol_cluster = InternalUtils.adjust_tolerance_for_TE_clustering(tolerance);
        e.inflate(tol_cluster, tol_cluster);
        if (!env2D_1.isIntersecting(e)) {
            if (geometry_a.getDimension() <= geometry_b.getDimension()) {
                return TopologicalOperations.normalizeResult_(TopologicalOperations.normalizeInputGeometry_(geometry_a.createInstance()), geometry_a, geometry_b, '&');
            }
            if (geometry_a.getDimension() > geometry_b.getDimension()) {
                return TopologicalOperations.normalizeResult_(TopologicalOperations.normalizeInputGeometry_(geometry_b.createInstance()), geometry_a, geometry_b, '&');
            }
        }
        TopologicalOperations topoOps = new TopologicalOperations();
        EditShape edit_shape = new EditShape();
        int geom_a = edit_shape.addGeometry(TopologicalOperations.normalizeInputGeometry_(geometry_a));
        int geom_b = edit_shape.addGeometry(TopologicalOperations.normalizeInputGeometry_(geometry_b));
        topoOps.setEditShapeCrackAndCluster(edit_shape, tolerance, progress_tracker);
        int result = topoOps.intersection(geom_a, geom_b);
        Geometry res_geom = TopologicalOperations.normalizeResult_(edit_shape.getGeometry(result), geometry_a, geometry_b, '&');
        if (Geometry.isMultiPath(res_geom.getType().value())) {
            ((MultiVertexGeometryImpl)res_geom._getImpl()).setIsSimple(2, tolerance, false);
            if (res_geom.getType() == Geometry.Type.Polygon) {
                ((MultiPathImpl)res_geom._getImpl())._updateOGCFlags();
            }
        }
        return res_geom;
    }

    static Geometry[] intersectionEx(Geometry geometry_a, Geometry geometry_b, SpatialReference sr, ProgressTracker progress_tracker) {
        Geometry[] res_vec = new Geometry[3];
        Envelope2D env2D_1 = new Envelope2D();
        geometry_a.queryEnvelope2D(env2D_1);
        Envelope2D env2D_2 = new Envelope2D();
        geometry_b.queryEnvelope2D(env2D_2);
        Envelope2D envMerged = new Envelope2D();
        envMerged.setCoords(env2D_1);
        envMerged.merge(env2D_2);
        double tolerance = InternalUtils.calculateToleranceFromGeometry(sr, envMerged, true);
        Envelope2D e = new Envelope2D();
        e.setCoords(env2D_2);
        double tol_cluster = InternalUtils.adjust_tolerance_for_TE_clustering(tolerance);
        e.inflate(tol_cluster, tol_cluster);
        if (!env2D_1.isIntersecting(e)) {
            if (geometry_a.getDimension() <= geometry_b.getDimension()) {
                Geometry geom;
                res_vec[geom.getDimension()] = geom = TopologicalOperations.normalizeResult_(TopologicalOperations.normalizeInputGeometry_(geometry_a.createInstance()), geometry_a, geometry_b, '&');
                return res_vec;
            }
            if (geometry_a.getDimension() > geometry_b.getDimension()) {
                Geometry geom;
                res_vec[geom.getDimension()] = geom = TopologicalOperations.normalizeResult_(TopologicalOperations.normalizeInputGeometry_(geometry_b.createInstance()), geometry_a, geometry_b, '&');
                return res_vec;
            }
        }
        TopologicalOperations topoOps = new TopologicalOperations();
        EditShape edit_shape = new EditShape();
        int geom_a = edit_shape.addGeometry(TopologicalOperations.normalizeInputGeometry_(geometry_a));
        int geom_b = edit_shape.addGeometry(TopologicalOperations.normalizeInputGeometry_(geometry_b));
        topoOps.setEditShapeCrackAndCluster(edit_shape, tolerance, progress_tracker);
        int[] result_geom_handles = topoOps.intersectionEx(geom_a, geom_b);
        for (int i = 0; i < result_geom_handles.length; ++i) {
            Geometry res_geom = TopologicalOperations.normalizeResult_(edit_shape.getGeometry(result_geom_handles[i]), geometry_a, geometry_b, '&');
            if (Geometry.isMultiPath(res_geom.getType().value())) {
                ((MultiVertexGeometryImpl)res_geom._getImpl()).setIsSimple(2, tolerance, false);
                if (res_geom.getType().value() == 1736) {
                    ((MultiPathImpl)res_geom._getImpl())._updateOGCFlags();
                }
            }
            res_vec[res_geom.getDimension()] = res_geom;
        }
        return res_vec;
    }

    public static Geometry symmetricDifference(Geometry geometry_a, Geometry geometry_b, SpatialReference sr, ProgressTracker progress_tracker) {
        if (geometry_a.getDimension() > geometry_b.getDimension()) {
            return TopologicalOperations.normalizeResult_(TopologicalOperations.normalizeInputGeometry_(geometry_a), geometry_a, geometry_b, '^');
        }
        if (geometry_a.getDimension() < geometry_b.getDimension()) {
            return TopologicalOperations.normalizeResult_(TopologicalOperations.normalizeInputGeometry_(geometry_b), geometry_a, geometry_b, '^');
        }
        if (geometry_a.isEmpty()) {
            return TopologicalOperations.normalizeResult_(TopologicalOperations.normalizeInputGeometry_(geometry_b), geometry_a, geometry_b, '^');
        }
        if (geometry_b.isEmpty()) {
            return TopologicalOperations.normalizeResult_(TopologicalOperations.normalizeInputGeometry_(geometry_a), geometry_a, geometry_b, '^');
        }
        Envelope2D env2D_1 = new Envelope2D();
        geometry_a.queryEnvelope2D(env2D_1);
        Envelope2D env2D_2 = new Envelope2D();
        geometry_b.queryEnvelope2D(env2D_2);
        Envelope2D envMerged = new Envelope2D();
        envMerged.setCoords(env2D_1);
        envMerged.merge(env2D_2);
        double tolerance = InternalUtils.calculateToleranceFromGeometry(sr, envMerged, true);
        TopologicalOperations topoOps = new TopologicalOperations();
        EditShape edit_shape = new EditShape();
        int geom_a = edit_shape.addGeometry(TopologicalOperations.normalizeInputGeometry_(geometry_a));
        int geom_b = edit_shape.addGeometry(TopologicalOperations.normalizeInputGeometry_(geometry_b));
        topoOps.setEditShapeCrackAndCluster(edit_shape, tolerance, progress_tracker);
        int result = topoOps.symmetricDifference(geom_a, geom_b);
        Geometry res_geom = TopologicalOperations.normalizeResult_(edit_shape.getGeometry(result), geometry_a, geometry_b, '^');
        if (Geometry.isMultiPath(res_geom.getType().value())) {
            ((MultiVertexGeometryImpl)res_geom._getImpl()).setIsSimple(2, tolerance, false);
            if (res_geom.getType() == Geometry.Type.Polygon) {
                ((MultiPathImpl)res_geom._getImpl())._updateOGCFlags();
            }
        }
        return res_geom;
    }

    static Geometry _denormalizeGeometry(Geometry geom, Geometry geomA, Geometry geomB) {
        MultiPoint mp;
        Geometry.Type gtA = geomA.getType();
        Geometry.Type gtB = geomB.getType();
        Geometry.Type gt = geom.getType();
        if (gt == Geometry.Type.MultiPoint && (gtA == Geometry.Type.Point || gtB == Geometry.Type.Point) && (mp = (MultiPoint)geom).getPointCount() <= 1) {
            Point pt = new Point(geom.getDescription());
            if (!mp.isEmpty()) {
                mp.getPointByVal(0, pt);
            }
            return pt;
        }
        return geom;
    }

    private void flushVertices_(int geometry, AttributeStreamOfInt32 vertices) {
        EditShape shape = this.m_topo_graph.getShape();
        int path = shape.insertPath(geometry, -1);
        int size = vertices.size();
        for (int i = 0; i < size; ++i) {
            int vertex = vertices.get(i);
            shape.addVertex(path, vertex);
        }
        shape.setClosedPath(path, true);
    }

    private void setHalfEdgeOrientations_(int orientationIndex, int cutter) {
        EditShape shape = this.m_topo_graph.getShape();
        int igeometry = shape.getFirstGeometry();
        while (igeometry != -1) {
            if (igeometry == cutter) {
                int ipath = shape.getFirstPath(igeometry);
                while (ipath != -1) {
                    int ivertex = shape.getFirstVertex(ipath);
                    if (ivertex != -1) {
                        int ivertexNext = shape.getNextVertex(ivertex);
                        assert (ivertexNext != -1);
                        while (ivertexNext != -1) {
                            int clusterTo;
                            int clusterFrom = this.m_topo_graph.getClusterFromVertex(ivertex);
                            int half_edge = this.m_topo_graph.getHalfEdgeConnector(clusterFrom, clusterTo = this.m_topo_graph.getClusterFromVertex(ivertexNext));
                            if (half_edge != -1) {
                                int halfEdgeTwin = this.m_topo_graph.getHalfEdgeTwin(half_edge);
                                this.m_topo_graph.setHalfEdgeUserIndex(half_edge, orientationIndex, 1);
                                this.m_topo_graph.setHalfEdgeUserIndex(halfEdgeTwin, orientationIndex, 2);
                            }
                            ivertex = ivertexNext;
                            ivertexNext = shape.getNextVertex(ivertex);
                        }
                    }
                    ipath = shape.getNextPath(ipath);
                }
            }
            igeometry = shape.getNextGeometry(igeometry);
        }
    }

    private void processPolygonCuts_(int orientationIndex, int sideIndex, int cuttee, int cutter) {
        int idCuttee = this.m_topo_graph.getGeometryID(cuttee);
        int idCutter = this.m_topo_graph.getGeometryID(cutter);
        AttributeStreamOfInt32 vertices = new AttributeStreamOfInt32(0);
        vertices.reserve(256);
        EditShape shape = this.m_topo_graph.getShape();
        int visitedIndex = this.m_topo_graph.createUserIndexForHalfEdges();
        int cluster = this.m_topo_graph.getFirstCluster();
        while (cluster != -1) {
            int firstHalfEdge = this.m_topo_graph.getClusterHalfEdge(cluster);
            if (firstHalfEdge != -1) {
                int half_edge = firstHalfEdge;
                do {
                    int next;
                    int visited;
                    if ((visited = this.m_topo_graph.getHalfEdgeUserIndex(half_edge, visitedIndex)) == 1) continue;
                    int faceHalfEdge = half_edge;
                    int toHalfEdge = half_edge;
                    boolean bFoundCutter = false;
                    int side = 0;
                    do {
                        int edgeParentage;
                        int faceParentage;
                        int edgeParentage2;
                        this.m_topo_graph.setHalfEdgeUserIndex(faceHalfEdge, visitedIndex, 1);
                        if (!bFoundCutter && ((edgeParentage2 = this.m_topo_graph.getHalfEdgeParentage(faceHalfEdge)) & idCutter) != 0 && ((faceParentage = this.m_topo_graph.getHalfEdgeFaceParentage(faceHalfEdge)) & idCuttee) != 0) {
                            toHalfEdge = faceHalfEdge;
                            bFoundCutter = true;
                        }
                        if (!bFoundCutter) continue;
                        int clusterOrigin = this.m_topo_graph.getHalfEdgeOrigin(faceHalfEdge);
                        int iterator = this.m_topo_graph.getClusterVertexIterator(clusterOrigin);
                        assert (iterator != -1);
                        int vertex = this.m_topo_graph.getVertexFromVertexIterator(iterator);
                        vertices.add(vertex);
                        if (orientationIndex == -1 || ((edgeParentage = this.m_topo_graph.getHalfEdgeParentage(faceHalfEdge)) & idCutter) == 0) continue;
                        int orientation = this.m_topo_graph.getHalfEdgeUserIndex(faceHalfEdge, orientationIndex);
                        assert (orientation == 1 || orientation == 2);
                        side |= orientation;
                    } while ((faceHalfEdge = (next = this.m_topo_graph.getHalfEdgeNext(faceHalfEdge))) != toHalfEdge);
                    if (bFoundCutter && this.m_topo_graph.getChainArea(this.m_topo_graph.getHalfEdgeChain(toHalfEdge)) > 0.0) {
                        int geometry = shape.createGeometry(Geometry.Type.Polygon);
                        this.flushVertices_(geometry, vertices);
                        if (sideIndex != -1) {
                            shape.setGeometryUserIndex(geometry, sideIndex, side);
                        }
                    }
                    vertices.clear(false);
                } while ((half_edge = this.m_topo_graph.getHalfEdgeNext(this.m_topo_graph.getHalfEdgeTwin(half_edge))) != firstHalfEdge);
            }
            cluster = this.m_topo_graph.getNextCluster(cluster);
        }
        this.m_topo_graph.deleteUserIndexForHalfEdges(visitedIndex);
    }

    private void cutPolygonPolyline_(int sideIndex, int cuttee, int cutter, AttributeStreamOfInt32 cutHandles) {
        this.m_topo_graph.removeSpikes_();
        int orientationIndex = -1;
        if (sideIndex != -1) {
            orientationIndex = this.m_topo_graph.createUserIndexForHalfEdges();
            this.setHalfEdgeOrientations_(orientationIndex, cutter);
        }
        this.processPolygonCuts_(orientationIndex, sideIndex, cuttee, cutter);
        EditShape shape = this.m_topo_graph.getShape();
        int cutCount = 0;
        int geometry_handle = shape.getFirstGeometry();
        while (geometry_handle != -1) {
            if (geometry_handle != cuttee && geometry_handle != cutter) {
                cutHandles.add(geometry_handle);
                ++cutCount;
            }
            geometry_handle = shape.getNextGeometry(geometry_handle);
        }
        CompareCuts compareCuts = new CompareCuts(shape);
        cutHandles.Sort(0, cutCount, compareCuts);
    }

    void removeShape() {
        if (this.m_topo_graph != null) {
            this.m_topo_graph.removeShape();
            this.m_topo_graph = null;
        }
    }

    static final class CompareCuts
    extends AttributeStreamOfInt32.IntComparator {
        private EditShape m_editShape;

        public CompareCuts(EditShape editShape) {
            this.m_editShape = editShape;
        }

        @Override
        public int compare(int c1, int c2) {
            int path2;
            double area2;
            int path1 = this.m_editShape.getFirstPath(c1);
            double area1 = this.m_editShape.getRingArea(path1);
            if (area1 < (area2 = this.m_editShape.getRingArea(path2 = this.m_editShape.getFirstPath(c2)))) {
                return -1;
            }
            if (area1 == area2) {
                return 0;
            }
            return 1;
        }
    }
}

