/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.com.esri.core.geometry;

import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.Geometry;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.MapGeometry;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.Operator;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.OperatorBoundaryLocal;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.OperatorBufferLocal;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.OperatorClipLocal;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.OperatorContainsLocal;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.OperatorConvexHullLocal;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.OperatorCrossesLocal;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.OperatorCutLocal;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.OperatorDensifyByLengthLocal;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.OperatorDifferenceLocal;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.OperatorDisjointLocal;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.OperatorDistanceLocal;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.OperatorEqualsLocal;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.OperatorExportToESRIShape;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.OperatorExportToESRIShapeLocal;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.OperatorExportToGeoJsonLocal;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.OperatorExportToJson;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.OperatorExportToJsonLocal;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.OperatorExportToWkbLocal;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.OperatorExportToWkt;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.OperatorExportToWktLocal;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.OperatorFactory;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.OperatorGeneralizeLocal;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.OperatorGeodesicBufferLocal;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.OperatorGeodeticAreaLocal;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.OperatorGeodeticDensifyLocal;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.OperatorGeodeticLengthLocal;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.OperatorImportFromESRIShape;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.OperatorImportFromESRIShapeLocal;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.OperatorImportFromGeoJsonLocal;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.OperatorImportFromJson;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.OperatorImportFromJsonLocal;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.OperatorImportFromWkbLocal;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.OperatorImportFromWkt;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.OperatorImportFromWktLocal;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.OperatorIntersectionLocal;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.OperatorIntersectsLocal;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.OperatorOffsetLocal;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.OperatorOverlapsLocal;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.OperatorProjectLocal;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.OperatorProximity2DLocal;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.OperatorRelateLocal;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.OperatorShapePreservingDensifyLocal;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.OperatorSimplifyLocal;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.OperatorSimplifyLocalOGC;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.OperatorSymmetricDifferenceLocal;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.OperatorTouchesLocal;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.OperatorUnionLocal;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.OperatorWithinLocal;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.SpatialReference;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.HashMap;

public class OperatorFactoryLocal
extends OperatorFactory {
    private static final OperatorFactoryLocal INSTANCE = new OperatorFactoryLocal();
    private static final HashMap<Operator.Type, Operator> st_supportedOperators = new HashMap();

    private OperatorFactoryLocal() {
    }

    public static OperatorFactoryLocal getInstance() {
        return INSTANCE;
    }

    @Override
    public Operator getOperator(Operator.Type type) {
        if (st_supportedOperators.containsKey((Object)type)) {
            return st_supportedOperators.get((Object)type);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean isOperatorSupported(Operator.Type type) {
        return st_supportedOperators.containsKey((Object)type);
    }

    public static void saveJSONToTextFileDbg(String file_name, Geometry geometry, SpatialReference spatial_ref) {
        if (file_name == null) {
            throw new IllegalArgumentException();
        }
        OperatorFactoryLocal engine = OperatorFactoryLocal.getInstance();
        OperatorExportToJson exporterJSON = (OperatorExportToJson)engine.getOperator(Operator.Type.ExportToJson);
        String jsonString = exporterJSON.execute(spatial_ref, geometry);
        try {
            FileOutputStream outfile = new FileOutputStream(file_name);
            PrintStream p = new PrintStream(outfile);
            p.print(jsonString);
            p.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static MapGeometry loadGeometryFromJSONFileDbg(String file_name) {
        if (file_name == null) {
            throw new IllegalArgumentException();
        }
        String jsonString = null;
        try {
            int read;
            FileInputStream stream = new FileInputStream(file_name);
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            StringBuilder builder = new StringBuilder();
            char[] buffer = new char[8192];
            while ((read = ((Reader)reader).read(buffer, 0, buffer.length)) > 0) {
                builder.append(buffer, 0, read);
            }
            stream.close();
            jsonString = builder.toString();
        }
        catch (Exception stream) {
            // empty catch block
        }
        MapGeometry mapGeom = OperatorImportFromJson.local().execute(Geometry.Type.Unknown, jsonString);
        return mapGeom;
    }

    public static MapGeometry loadGeometryFromJSONStringDbg(String json) {
        if (json == null) {
            throw new IllegalArgumentException();
        }
        MapGeometry mapGeom = null;
        try {
            mapGeom = OperatorImportFromJson.local().execute(Geometry.Type.Unknown, json);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.toString());
        }
        return mapGeom;
    }

    public static Geometry loadGeometryFromEsriShapeDbg(String file_name) {
        if (file_name == null) {
            throw new IllegalArgumentException();
        }
        try {
            FileInputStream stream = new FileInputStream(file_name);
            FileChannel fchan = stream.getChannel();
            ByteBuffer bb = ByteBuffer.allocate((int)fchan.size());
            fchan.read(bb);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            Geometry g = OperatorImportFromESRIShape.local().execute(0, Geometry.Type.Unknown, bb);
            fchan.close();
            stream.close();
            return g;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException();
        }
    }

    public static void saveGeometryToEsriShapeDbg(String file_name, Geometry geometry) {
        if (file_name == null) {
            throw new IllegalArgumentException();
        }
        try {
            ByteBuffer bb = OperatorExportToESRIShape.local().execute(0, geometry);
            FileOutputStream outfile = new FileOutputStream(file_name);
            FileChannel fchan = outfile.getChannel();
            fchan.write(bb);
            fchan.close();
            outfile.close();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException();
        }
    }

    public static void saveToWKTFileDbg(String file_name, Geometry geometry, SpatialReference spatial_ref) {
        if (file_name == null) {
            throw new IllegalArgumentException();
        }
        String jsonString = OperatorExportToWkt.local().execute(0, geometry, null);
        try {
            FileOutputStream outfile = new FileOutputStream(file_name);
            PrintStream p = new PrintStream(outfile);
            p.print(jsonString);
            p.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Geometry loadGeometryFromWKTFileDbg(String file_name) {
        if (file_name == null) {
            throw new IllegalArgumentException();
        }
        String s = null;
        try {
            int read;
            FileInputStream stream = new FileInputStream(file_name);
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            StringBuilder builder = new StringBuilder();
            char[] buffer = new char[8192];
            while ((read = ((Reader)reader).read(buffer, 0, buffer.length)) > 0) {
                builder.append(buffer, 0, read);
            }
            stream.close();
            s = builder.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return OperatorImportFromWkt.local().execute(0, Geometry.Type.Unknown, s, null);
    }

    static {
        st_supportedOperators.put(Operator.Type.Project, new OperatorProjectLocal());
        st_supportedOperators.put(Operator.Type.ExportToJson, new OperatorExportToJsonLocal());
        st_supportedOperators.put(Operator.Type.ImportFromJson, new OperatorImportFromJsonLocal());
        st_supportedOperators.put(Operator.Type.ExportToESRIShape, new OperatorExportToESRIShapeLocal());
        st_supportedOperators.put(Operator.Type.ImportFromESRIShape, new OperatorImportFromESRIShapeLocal());
        st_supportedOperators.put(Operator.Type.Proximity2D, new OperatorProximity2DLocal());
        st_supportedOperators.put(Operator.Type.DensifyByLength, new OperatorDensifyByLengthLocal());
        st_supportedOperators.put(Operator.Type.Relate, new OperatorRelateLocal());
        st_supportedOperators.put(Operator.Type.Equals, new OperatorEqualsLocal());
        st_supportedOperators.put(Operator.Type.Disjoint, new OperatorDisjointLocal());
        st_supportedOperators.put(Operator.Type.Intersects, new OperatorIntersectsLocal());
        st_supportedOperators.put(Operator.Type.Within, new OperatorWithinLocal());
        st_supportedOperators.put(Operator.Type.Contains, new OperatorContainsLocal());
        st_supportedOperators.put(Operator.Type.Crosses, new OperatorCrossesLocal());
        st_supportedOperators.put(Operator.Type.Touches, new OperatorTouchesLocal());
        st_supportedOperators.put(Operator.Type.Overlaps, new OperatorOverlapsLocal());
        st_supportedOperators.put(Operator.Type.SimplifyOGC, new OperatorSimplifyLocalOGC());
        st_supportedOperators.put(Operator.Type.Simplify, new OperatorSimplifyLocal());
        st_supportedOperators.put(Operator.Type.Offset, new OperatorOffsetLocal());
        st_supportedOperators.put(Operator.Type.GeodeticDensifyByLength, new OperatorGeodeticDensifyLocal());
        st_supportedOperators.put(Operator.Type.ShapePreservingDensify, new OperatorShapePreservingDensifyLocal());
        st_supportedOperators.put(Operator.Type.GeodesicBuffer, new OperatorGeodesicBufferLocal());
        st_supportedOperators.put(Operator.Type.GeodeticLength, new OperatorGeodeticLengthLocal());
        st_supportedOperators.put(Operator.Type.GeodeticArea, new OperatorGeodeticAreaLocal());
        st_supportedOperators.put(Operator.Type.Buffer, new OperatorBufferLocal());
        st_supportedOperators.put(Operator.Type.Distance, new OperatorDistanceLocal());
        st_supportedOperators.put(Operator.Type.Intersection, new OperatorIntersectionLocal());
        st_supportedOperators.put(Operator.Type.Difference, new OperatorDifferenceLocal());
        st_supportedOperators.put(Operator.Type.SymmetricDifference, new OperatorSymmetricDifferenceLocal());
        st_supportedOperators.put(Operator.Type.Clip, new OperatorClipLocal());
        st_supportedOperators.put(Operator.Type.Cut, new OperatorCutLocal());
        st_supportedOperators.put(Operator.Type.ExportToWkb, new OperatorExportToWkbLocal());
        st_supportedOperators.put(Operator.Type.ImportFromWkb, new OperatorImportFromWkbLocal());
        st_supportedOperators.put(Operator.Type.ExportToWkt, new OperatorExportToWktLocal());
        st_supportedOperators.put(Operator.Type.ImportFromWkt, new OperatorImportFromWktLocal());
        st_supportedOperators.put(Operator.Type.ImportFromGeoJson, new OperatorImportFromGeoJsonLocal());
        st_supportedOperators.put(Operator.Type.ExportToGeoJson, new OperatorExportToGeoJsonLocal());
        st_supportedOperators.put(Operator.Type.Union, new OperatorUnionLocal());
        st_supportedOperators.put(Operator.Type.Generalize, new OperatorGeneralizeLocal());
        st_supportedOperators.put(Operator.Type.ConvexHull, new OperatorConvexHullLocal());
        st_supportedOperators.put(Operator.Type.Boundary, new OperatorBoundaryLocal());
    }
}

