/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.com.esri.core.geometry;

import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.Geometry;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.MultiVertexGeometry;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.QuadTreeImpl;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.RasterizedGeometry2D;

class GeometryAccelerators {
    private RasterizedGeometry2D m_rasterizedGeometry;
    private QuadTreeImpl m_quad_tree;
    private QuadTreeImpl m_quad_tree_for_paths;

    GeometryAccelerators() {
    }

    public RasterizedGeometry2D getRasterizedGeometry() {
        return this.m_rasterizedGeometry;
    }

    public QuadTreeImpl getQuadTree() {
        return this.m_quad_tree;
    }

    public QuadTreeImpl getQuadTreeForPaths() {
        return this.m_quad_tree_for_paths;
    }

    void _setRasterizedGeometry(RasterizedGeometry2D rg) {
        this.m_rasterizedGeometry = rg;
    }

    void _setQuadTree(QuadTreeImpl quad_tree) {
        this.m_quad_tree = quad_tree;
    }

    void _setQuadTreeForPaths(QuadTreeImpl quad_tree) {
        this.m_quad_tree_for_paths = quad_tree;
    }

    static boolean canUseRasterizedGeometry(Geometry geom) {
        return !geom.isEmpty() && (geom.getType() == Geometry.Type.Polyline || geom.getType() == Geometry.Type.Polygon);
    }

    static boolean canUseQuadTree(Geometry geom) {
        if (geom.isEmpty() || geom.getType() != Geometry.Type.Polyline && geom.getType() != Geometry.Type.Polygon) {
            return false;
        }
        return ((MultiVertexGeometry)geom).getPointCount() >= 20;
    }

    static boolean canUseQuadTreeForPaths(Geometry geom) {
        if (geom.isEmpty() || geom.getType() != Geometry.Type.Polyline && geom.getType() != Geometry.Type.Polygon) {
            return false;
        }
        return ((MultiVertexGeometry)geom).getPointCount() >= 20;
    }
}

